/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.unitils.core.Unitils;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.database.DataSourceWrapper;
import org.unitils.database.DatabaseModule;

public class DatabaseUnitils {
    public static DataSource getDataSource(String databaseName) {
        return DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).getTransactionalDataSourceAndActivateTransactionIfNeeded(DatabaseUnitils.getTestObject());
    }

    public static DataSource getDataSource() {
        return DatabaseUnitils.getDataSource("");
    }

    public static void flushDatabaseUpdates() {
        DatabaseUnitils.getDatabaseModule().flushDatabaseUpdates(DatabaseUnitils.getTestObject());
    }

    public static void startTransaction() {
        DatabaseUnitils.getDatabaseModule().startTransaction(DatabaseUnitils.getTestObject());
    }

    public static void commitTransaction() {
        DatabaseUnitils.getDatabaseModule().commitTransaction(DatabaseUnitils.getTestObject());
    }

    public static void rollbackTransaction() {
        DatabaseUnitils.getDatabaseModule().rollbackTransaction(DatabaseUnitils.getTestObject());
    }

    public static void updateDatabase() {
        DatabaseUnitils.updateDatabase("");
    }

    public static void updateDatabase(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).updateDatabase();
    }

    public static void resetDatabaseState() {
        DatabaseUnitils.resetDatabaseState("");
    }

    public static void resetDatabaseState(String databaseName) {
        DatabaseModule databaseModule = DatabaseUnitils.getDatabaseModule();
        DataSourceWrapper wrapper = databaseModule.getWrapper(databaseName);
        SQLHandler sqlHandler = wrapper.getDefaultSqlHandler();
        databaseModule.resetDatabaseState(sqlHandler, wrapper);
    }

    public static void clearSchemas() {
        DatabaseUnitils.clearSchemas("");
    }

    public static void clearSchemas(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).clearSchemas();
    }

    public static void cleanSchemas() {
        DatabaseUnitils.cleanSchemas("");
    }

    public static void cleanSchemas(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).cleanSchemas();
    }

    public static void disableConstraints() {
        DatabaseUnitils.disableConstraints("");
    }

    public static void disableConstraints(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).disableConstraints();
    }

    public static void updateSequences() {
        DatabaseUnitils.updateSequences("");
    }

    public static void updateSequences(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).updateSequences();
    }

    public static void restartSequences(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).restartSequences();
    }

    public static void generateDatasetDefinition() {
        DatabaseUnitils.generateDatasetDefinition("");
    }

    public static void generateDatasetDefinition(String databaseName) {
        DatabaseUnitils.getDatabaseModule().getWrapper(databaseName).generateDatasetDefinition();
    }

    private static DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    private static Object getTestObject() {
        Object testObject = Unitils.getInstance().getTestContext().getTestObject();
        return testObject;
    }

    public static Connection getGoodConnection(Connection connection, DataSource dataSource) {
        BasicDataSource tempDataSource;
        if (dataSource instanceof BasicDataSource && (tempDataSource = (BasicDataSource)dataSource).getDriverClassName().toLowerCase().contains("oracle") && connection instanceof DelegatingConnection) {
            boolean canAccess = tempDataSource.isAccessToUnderlyingConnectionAllowed();
            if (!canAccess) {
                tempDataSource.setAccessToUnderlyingConnectionAllowed(true);
            }
            DelegatingConnection tempConnection = (DelegatingConnection)connection;
            Connection innermostDelegate = tempConnection.getInnermostDelegate();
            if (!canAccess) {
                tempDataSource.setAccessToUnderlyingConnectionAllowed(false);
            }
            return innermostDelegate;
        }
        return connection;
    }
}

