
SET DATABASE SQL SYNTAX MYS TRUE;

drop table entry if exists;
drop table event if exists;
drop table blob if exists;

CREATE TABLE entry
(
	invoice VARCHAR(50) NOT NULL,
	event VARCHAR(50),
	paymentTotal FLOAT(2),
	paymentIdentifier VARCHAR(255),
	paymentEmail VARCHAR(255),
	enteredDate DATETIME,
	paymentDate DATETIME,
	processed BOOLEAN,
	properties TEXT,
	sessionId VARCHAR(20) NOT NULL,
	PRIMARY KEY (invoice)
) ;


CREATE TABLE event
(
	name VARCHAR(50) NOT NULL,
	eventTitle VARCHAR(255) NOT NULL,
	lastInvoice INTEGER,
	modelName VARCHAR(255),
	secretaryName VARCHAR(255) NOT NULL,
	secretaryEmail VARCHAR(255),
	secretaryNumber VARCHAR(15),
	eventDate DATETIME NOT NULL,
	closeDate DATETIME,
	openDate DATETIME,
	properties TEXT,
	creationDate TIMESTAMP default CURRENT_TIMESTAMP,
	PRIMARY KEY (name)
) ;

CREATE TABLE blob
(
	identifier VARCHAR(50) NOT NULL,
	owner VARCHAR(50) NOT NULL,
	filesize INTEGER NOT NULL,
	filename VARCHAR(255) NOT NULL,
	mimeType VARCHAR(255) NOT NULL,
	purpose VARCHAR(255) NOT NULL,
	creationDate TIMESTAMP default CURRENT_TIMESTAMP,
	PRIMARY KEY (identifier)
) ;



ALTER TABLE entry ADD CONSTRAINT FK_entries_events
	FOREIGN KEY (event) REFERENCES event (name);
