/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.AgentService;
import org.terracotta.management.resource.services.AgentsResourceService;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents")
public final class AgentsResourceServiceImpl
implements AgentsResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(AgentsResourceServiceImpl.class);
    private final AgentService agentService = (AgentService)ServiceLocator.locate(AgentService.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    public Collection<AgentEntity> getAgents(UriInfo info) {
        LOG.debug(String.format("Invoking AgentsResourceServiceImpl.getAgents: %s", info.getRequestUri()));
        String ids = (String)((PathSegment)info.getPathSegments().get(0)).getMatrixParameters().getFirst((Object)"ids");
        Set<Object> idSet = ids == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(ids.split(",")));
        try {
            return this.agentService.getAgents(idSet);
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to get agents", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    public Collection<AgentMetadataEntity> getAgentsMetadata(UriInfo info) {
        LOG.debug(String.format("Invoking AgentsResourceServiceImpl.getAgentsMetadata: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String ids = (String)((PathSegment)info.getPathSegments().get(0)).getMatrixParameters().getFirst((Object)"ids");
        Set<Object> idSet = ids == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(ids.split(",")));
        try {
            return this.agentService.getAgentsMetadata(idSet);
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to get agents metadata", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

