/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.EmbeddedEhcacheServiceLocator;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.services.CacheManagersResourceService;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents/cacheManagers")
public final class CacheManagersResourceServiceImpl
implements CacheManagersResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagersResourceServiceImpl.class);
    private final EntityResourceFactory entityResourceFactory;
    private final RequestValidator validator;
    private final CacheManagerService cacheMgrSvc;

    public CacheManagersResourceServiceImpl() {
        EmbeddedEhcacheServiceLocator entityRsrcFactoryLocator = EmbeddedEhcacheServiceLocator.locator();
        this.entityResourceFactory = entityRsrcFactoryLocator.locateEntityResourceFactory();
        EmbeddedEhcacheServiceLocator reqValidatorLocator = EmbeddedEhcacheServiceLocator.locator();
        this.validator = reqValidatorLocator.locateRequestValidator();
        EmbeddedEhcacheServiceLocator cacheMgrSvcLocator = EmbeddedEhcacheServiceLocator.locator();
        this.cacheMgrSvc = cacheMgrSvcLocator.locateCacheManagerService();
    }

    public Collection<CacheManagerEntity> getCacheManagers(UriInfo info) {
        LOG.info(String.format("Invoking getCacheManagers: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String names = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = names == null ? null : new HashSet<String>(Arrays.asList(names.split(",")));
        MultivaluedMap qParams = info.getQueryParameters();
        List attrs = (List)qParams.get((Object)"show");
        HashSet<String> cmAttrs = attrs == null || attrs.isEmpty() ? null : new HashSet<String>(attrs);
        return this.entityResourceFactory.createCacheManagerEntities(cmNames, cmAttrs);
    }

    public void updateCacheManager(UriInfo info, CacheManagerEntity resource) {
        LOG.info(String.format("Invoking getCacheManagers: %s", info.getRequestUri()));
        this.validator.validate(info);
        String cacheManagerName = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        try {
            this.cacheMgrSvc.updateCacheManager(cacheManagerName, resource);
        }
        catch (ServiceExecutionException e) {
            LOG.error("Failed to update cache manager.", e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getCause().getMessage()).build());
        }
    }
}

