/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import com.terracotta.management.ApplicationEhCacheService;
import com.terracotta.management.security.IdentityAssertionServiceClient;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.SecretKeyChainAccessor;
import com.terracotta.management.security.SecurityServiceDirectory;
import com.terracotta.management.security.impl.ConstantSecurityServiceDirectory;
import com.terracotta.management.security.impl.ContextSecurityServiceDirectory;
import com.terracotta.management.security.impl.JerseyIdentityAssertionServiceClient;
import com.terracotta.management.security.impl.KeyChainAwareSSLContextFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.net.ssl.SSLContext;
import javax.servlet.Filter;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.AbstractManagementServer;
import net.sf.ehcache.management.service.ManagementServerLifecycle;
import net.sf.ehcache.management.service.impl.RemoteAgentEndpointImplEE;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.embedded.FilterDetail;
import org.terracotta.management.embedded.NoIaFilter;
import org.terracotta.management.embedded.StandaloneServer;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.LicenseServiceImpl;
import org.terracotta.management.resource.services.Utils;

public final class ManagementServerImplEE
extends AbstractManagementServer {
    public void initialize(ManagementRESTServiceConfiguration configuration, KeyChainAccessor overridingKeyChainAccessor, SSLContextFactory overridingSSLContextFactory) {
        List<FilterDetail> filterDetails;
        String host = configuration.getHost();
        int port = configuration.getPort();
        List<EnvironmentLoaderListener> servletListeners = null;
        if (Utils.trimToNull((String)configuration.getSecurityServiceLocation()) != null) {
            EnvironmentLoaderListener securityListener = new EnvironmentLoaderListener();
            servletListeners = Collections.singletonList(securityListener);
            ShiroFilter shiroSecurityFilter = new ShiroFilter();
            FilterDetail fd = new FilterDetail((Filter)shiroSecurityFilter, "/*");
            filterDetails = Collections.singletonList(fd);
        } else {
            filterDetails = Collections.singletonList(new FilterDetail((Filter)new NoIaFilter(), "/*"));
        }
        this.loadEmbeddedAgentServiceLocator(configuration, overridingKeyChainAccessor, overridingSSLContextFactory);
        SSLContext sslContext = null;
        boolean needClientAuth = false;
        if (configuration.isSslEnabled()) {
            sslContext = this.createSslContext();
            needClientAuth = configuration.isNeedClientAuth();
        }
        ServiceLoader loaders = this.applicationEhCacheServiceLoader();
        for (ApplicationEhCacheService applicationEhCacheService : loaders) {
            Class clazz = applicationEhCacheService.getManagementServerLifecyle();
            this.managementServerLifecycles.add((ManagementServerLifecycle)ServiceLocator.locate((Class)clazz));
        }
        this.standaloneServer = new StandaloneServer(filterDetails, servletListeners, "com.terracotta.management.ApplicationEhCache", host, port, sslContext, needClientAuth);
    }

    private <T> void loadEmbeddedAgentServiceLocator(ManagementRESTServiceConfiguration configuration, KeyChainAccessor overridingKeyChainAccessor, SSLContextFactory overridingSSLContextFactory) {
        LicenseServiceImpl licenseService = new LicenseServiceImpl(true);
        ServiceLocator locator = new ServiceLocator();
        KeyChainAccessor kcAccessor = null;
        if (Utils.trimToNull((String)configuration.getSecurityServiceLocation()) != null || configuration.isSslEnabled()) {
            try {
                kcAccessor = overridingKeyChainAccessor != null ? overridingKeyChainAccessor : new SecretKeyChainAccessor();
            }
            catch (KeychainInitializationException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid keyChain configuration.", e);
            }
            locator.loadService(KeyChainAccessor.class, (Object)kcAccessor);
        }
        SSLContextFactory sslCtxtFactory = null;
        if (configuration.isSslEnabled()) {
            sslCtxtFactory = overridingSSLContextFactory != null ? overridingSSLContextFactory : new KeyChainAwareSSLContextFactory(kcAccessor, configuration.isNeedClientAuth());
            locator.loadService(SSLContextFactory.class, (Object)sslCtxtFactory);
        }
        ContextSecurityServiceDirectory contextSecurityServiceDirectory = null;
        JerseyIdentityAssertionServiceClient idAssertionSvcClient = null;
        if (configuration.getSecurityServiceLocation() != null && !"".equals(configuration.getSecurityServiceLocation())) {
            try {
                ConstantSecurityServiceDirectory securityServiceDirectory = new ConstantSecurityServiceDirectory(new URI(configuration.getSecurityServiceLocation()), Integer.valueOf(configuration.getSecurityServiceTimeout()));
                idAssertionSvcClient = new JerseyIdentityAssertionServiceClient(kcAccessor, sslCtxtFactory, (SecurityServiceDirectory)securityServiceDirectory);
                locator.loadService(IdentityAssertionServiceClient.class, (Object)idAssertionSvcClient);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid securityServiceLocation.", e);
            }
        } else if ("".equals(configuration.getSecurityServiceLocation())) {
            contextSecurityServiceDirectory = new ContextSecurityServiceDirectory(Integer.valueOf(configuration.getSecurityServiceTimeout()));
            locator.loadService(ContextSecurityServiceDirectory.class, (Object)contextSecurityServiceDirectory);
            idAssertionSvcClient = new JerseyIdentityAssertionServiceClient(kcAccessor, sslCtxtFactory, (SecurityServiceDirectory)contextSecurityServiceDirectory);
            locator.loadService(IdentityAssertionServiceClient.class, (Object)idAssertionSvcClient);
        }
        locator.loadService(LicenseService.class, (Object)licenseService).loadService(ManagementRESTServiceConfiguration.class, (Object)configuration);
        this.remoteAgentEndpointImpl = new RemoteAgentEndpointImplEE(configuration, (IdentityAssertionServiceClient)idAssertionSvcClient, contextSecurityServiceDirectory);
        ServiceLoader loader = this.applicationEhCacheServiceLoader();
        for (ApplicationEhCacheService applicationEhCacheService : loader) {
            Map serviceClasses = applicationEhCacheService.getServiceClasses(configuration, this.remoteAgentEndpointImpl);
            for (Map.Entry entry : serviceClasses.entrySet()) {
                locator.loadService((Class)entry.getKey(), entry.getValue());
            }
        }
        ServiceLocator.load((ServiceLocator)locator);
    }

    private SSLContext createSslContext() {
        SSLContextFactory sslCtxtFactory = (SSLContextFactory)ServiceLocator.locate(SSLContextFactory.class);
        try {
            return sslCtxtFactory.create();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid KeyManagerFactory algorithm.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to inability to load keyStore.", e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid KeyStore type.", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid certificates in a KeyStore.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to bad key in a KeyStore.", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to one or more invalid keys in a KeyStore.", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to bad store location.", e);
        }
    }

    static String replaceBackslashesWithSlashes(String userHomeOnWindows) {
        return userHomeOnWindows.replace("\\", "/");
    }

    public void initialize(ManagementRESTServiceConfiguration configuration) {
        this.initialize(configuration, null, null);
    }

    public void registerClusterRemoteEndpoint(String clientUUID) {
        this.remoteAgentEndpointImpl.registerMBean(clientUUID);
    }

    public void unregisterClusterRemoteEndpoint(String clientUUID) {
        this.remoteAgentEndpointImpl.unregisterMBean(clientUUID);
    }
}

