/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.Header;
import net.sf.ehcache.constructs.web.HttpDateFormatter;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.filter.SimplePageCachingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCachingHeadersPageCachingFilter
extends SimplePageCachingFilter {
    public static final String NAME = "SimpleCachingHeadersPageCachingFilter";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCachingHeadersPageCachingFilter.class);
    private static final long ONE_YEAR_IN_MILLISECONDS = 31536000000L;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private HttpDateFormatter httpDateFormatter;

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        PageInfo pageInfo = super.buildPage(request, response, chain);
        List<Header<? extends Serializable>> headers = pageInfo.getHeaders();
        long ttlMilliseconds = this.calculateTimeToLiveMilliseconds();
        Iterator<Header<? extends Serializable>> headerItr = headers.iterator();
        while (headerItr.hasNext()) {
            Header<? extends Serializable> header = headerItr.next();
            String name = header.getName();
            if (!"Last-Modified".equalsIgnoreCase(name) && !"Expires".equalsIgnoreCase(name) && !"Cache-Control".equalsIgnoreCase(name) && !"ETag".equalsIgnoreCase(name)) continue;
            headerItr.remove();
        }
        long lastModified = pageInfo.getCreated().getTime();
        lastModified = TimeUnit.MILLISECONDS.toSeconds(lastModified);
        lastModified = TimeUnit.SECONDS.toMillis(lastModified);
        headers.add(new Header<Long>("Last-Modified", lastModified));
        headers.add(new Header<Long>("Expires", System.currentTimeMillis() + ttlMilliseconds));
        headers.add(new Header<String>("Cache-Control", "max-age=" + ttlMilliseconds / 1000L));
        headers.add(new Header<String>("ETag", this.generateEtag(ttlMilliseconds)));
        return pageInfo;
    }

    private String generateEtag(long ttlMilliseconds) {
        StringBuffer stringBuffer = new StringBuffer();
        Long eTagRaw = System.currentTimeMillis() + ttlMilliseconds;
        String eTag = stringBuffer.append("\"").append(eTagRaw).append("\"").toString();
        return eTag;
    }

    protected final HttpDateFormatter getHttpDateFormatter() {
        if (this.httpDateFormatter == null) {
            this.httpDateFormatter = new HttpDateFormatter();
        }
        return this.httpDateFormatter;
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        List<Header<? extends Serializable>> headers = pageInfo.getHeaders();
        for (Header<? extends Serializable> header : headers) {
            Date pageInfoDate;
            long requestIfModifiedSince;
            if ("ETag".equals(header.getName())) {
                String requestIfNoneMatch = request.getHeader("If-None-Match");
                if (!header.getValue().equals(requestIfNoneMatch)) break;
                response.sendError(304);
                return;
            }
            if (!"Last-Modified".equals(header.getName()) || (requestIfModifiedSince = request.getDateHeader("If-Modified-Since")) == -1L) continue;
            Date requestDate = new Date(requestIfModifiedSince);
            switch (header.getType()) {
                case STRING: {
                    pageInfoDate = this.getHttpDateFormatter().parseDateFromHttpDate((String)((Object)header.getValue()));
                    break;
                }
                case DATE: {
                    pageInfoDate = new Date((Long)header.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Header " + header + " is not supported as type: " + (Object)((Object)header.getType()));
                }
            }
            if (requestDate.before(pageInfoDate)) continue;
            response.sendError(304);
            response.setHeader("Last-Modified", request.getHeader("If-Modified-Since"));
            return;
        }
        super.writeResponse(request, response, pageInfo);
    }

    protected long calculateTimeToLiveMilliseconds() {
        if (this.blockingCache.isDisabled()) {
            return -1L;
        }
        CacheConfiguration cacheConfiguration = this.blockingCache.getCacheConfiguration();
        if (cacheConfiguration.isEternal()) {
            return 31536000000L;
        }
        return cacheConfiguration.getTimeToLiveSeconds() * 1000L;
    }

    private Date createLastModified(Element ehcacheElement) {
        long lastModified = ehcacheElement.getCreationTime();
        Date lastModifiedDate = new Date(lastModified);
        LOG.debug("lastModified as long: {}", (Object)lastModified);
        LOG.debug("lastModified as Date without ms: {}", (Object)lastModifiedDate);
        return lastModifiedDate;
    }

    private String createETag(Element ehcacheElement) {
        long eTagNumber = ehcacheElement.getCreationTime();
        return new StringBuffer().append(eTagNumber).toString();
    }
}

