/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementData;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.DynamicAttributesExtractor;
import net.sf.ehcache.search.impl.DynamicSearchChecker;
import net.sf.ehcache.transaction.SoftLockID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.ToolkitInstanceFactory;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.internal.search.ToolkitAttributeExtractorInternal;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractorException;

public class AttributeExtractorManager
implements ToolkitAttributeExtractorInternal<String, Serializable> {
    private static final int MAX_STRING_ATTR_LENGTH = 16384;
    private volatile DynamicAttributesExtractor dynamicAttrExtractor;
    private final String cacheName;
    private final String cmName;
    private final ToolkitInstanceFactory instanceFactory;
    private final boolean isDynamicExtractionEnabled;
    private final Map<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
    private static final Logger LOG = LoggerFactory.getLogger(AttributeExtractorManager.class);
    private final CacheConfiguration cacheConfiguration;
    private final Map<String, Class<?>> initialSchema = new HashMap();
    private final Map<String, Attribute> searchAttributes = new HashMap<String, Attribute>();
    private final ValueModeHandler valueModeHandler;

    public AttributeExtractorManager(Ehcache cache, ToolkitInstanceFactory tkFactory, ValueModeHandler valueModeHandler) {
        this(cache.getCacheManager().getName(), cache.getCacheConfiguration(), tkFactory, valueModeHandler);
    }

    public AttributeExtractorManager(String cacheManagerName, CacheConfiguration cacheConfiguration, ToolkitInstanceFactory tkFactory, ValueModeHandler valueModeHandler) {
        this.valueModeHandler = valueModeHandler;
        this.cacheName = cacheConfiguration.getName();
        this.cacheConfiguration = cacheConfiguration;
        this.instanceFactory = tkFactory;
        this.cmName = cacheManagerName;
        if (cacheConfiguration.getSearchable() != null) {
            this.isDynamicExtractionEnabled = cacheConfiguration.getSearchable().isDynamicIndexingAllowed();
            if (this.isDynamicExtractionEnabled) {
                this.setDynamicAttrExtractor(cacheConfiguration.getDynamicExtractor());
            }
            this.setupTypeSchema();
        } else {
            this.isDynamicExtractionEnabled = false;
        }
    }

    public Map<String, Object> attributesFor(String key, Serializable value) {
        String name;
        Element elt;
        if (this.dynamicAttrExtractor == null && this.isDynamicExtractionEnabled) {
            throw new ToolkitAttributeExtractorException("Dynamic attributes extractor must be set prior to adding data to cache.");
        }
        if (this.extractors.isEmpty() && this.dynamicAttrExtractor == null) {
            return DO_NOT_INDEX;
        }
        ElementData ed = (ElementData)value;
        boolean isXa = ed.getValue() instanceof SoftLockID;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (isXa) {
            SoftLockID sl = (SoftLockID)ed.getValue();
            elt = sl.getOldElement();
            if (elt == null) {
                return DO_NOT_INDEX;
            }
        } else {
            elt = this.valueModeHandler.createElement(this.valueModeHandler.getRealKeyObject(key), ed);
        }
        HashMap<String, ? extends Object> allAttrs = new HashMap<String, Object>();
        allAttrs.putAll(DynamicSearchChecker.getSearchAttributes(elt, this.extractors.keySet(), this.dynamicAttrExtractor));
        for (Map.Entry<String, AttributeExtractor> entry : this.extractors.entrySet()) {
            name = entry.getKey();
            AttributeExtractor extractor = entry.getValue();
            Object av = extractor.attributeFor(elt, name);
            allAttrs.put(name, av);
        }
        for (Map.Entry<String, AttributeExtractor> entry : allAttrs.entrySet()) {
            int len;
            name = entry.getKey();
            AttributeExtractor av = entry.getValue();
            if (av instanceof String && (len = ((String)((Object)av)).length()) >= 16384) {
                throw new SearchException("Cannot index strings with length >= 16384");
            }
            if (av == null) continue;
            attrs.put(name, av);
        }
        return attrs;
    }

    public Map<String, Class<?>> getInitialTypeSchema() {
        return this.initialSchema;
    }

    public ToolkitMap<String, String> createAttributeMap() {
        return this.instanceFactory.getOrCreateAttributeMap(this.cmName, this.cacheName);
    }

    public boolean setupExtractors(Map<String, AttributeExtractor> requestedExtractors) {
        if (this.extractors.isEmpty()) {
            ToolkitMap<String, AttributeExtractor> clusteredExtractors = this.instanceFactory.getOrCreateExtractorsMap(this.cmName, this.cacheName);
            if (clusteredExtractors.isEmpty()) {
                clusteredExtractors.putAll(requestedExtractors);
            } else {
                AttributeExtractorManager.reportSearchAttributeDifferences(clusteredExtractors, requestedExtractors);
            }
            this.extractors.putAll((Map<String, AttributeExtractor>)clusteredExtractors);
            for (String name : this.extractors.keySet()) {
                this.searchAttributes.put(name, new Attribute(name));
            }
            return true;
        }
        AttributeExtractorManager.reportSearchAttributeDifferences(this.extractors, requestedExtractors);
        throw new IllegalStateException("Can't set up attribute extractor twice");
    }

    private static void reportSearchAttributeDifferences(Map<String, AttributeExtractor> actual, Map<String, AttributeExtractor> config) {
        HashSet<String> extraFromConfig = new HashSet<String>(config.keySet());
        extraFromConfig.removeAll(actual.keySet());
        for (String name : extraFromConfig) {
            LOG.warn("local configuration defines attribute [" + name + "] which is not present in the clustered store");
        }
        HashSet<String> extraActual = new HashSet<String>(actual.keySet());
        extraActual.removeAll(config.keySet());
        for (String name : extraActual) {
            LOG.warn("Cluster defines attribute [" + name + "] which is not present in local configuration");
        }
    }

    private void setupTypeSchema() {
        for (Map.Entry<String, SearchAttribute> sa : this.cacheConfiguration.getSearchAttributes().entrySet()) {
            String attrName = sa.getKey();
            Class<?> attrType = ConfigurationHelper.getSearchAttributeType(sa.getValue());
            if (attrType == null) continue;
            this.initialSchema.put(attrName, attrType);
        }
    }

    public DynamicAttributesExtractor getDynamicAttrExtractor() {
        return this.dynamicAttrExtractor;
    }

    public void setDynamicAttrExtractor(DynamicAttributesExtractor dynamicAttrExtractor) {
        if (!this.isDynamicExtractionEnabled) {
            throw new IllegalStateException("Dynamic attribute extraction not enabled");
        }
        this.dynamicAttrExtractor = dynamicAttrExtractor;
    }

    public Set<Attribute> getSearchAttributes() {
        HashSet allAttrs = new HashSet(this.searchAttributes.size());
        allAttrs.addAll(this.searchAttributes.values());
        if (this.getDynamicAttrExtractor() != null) {
            ToolkitMap<String, String> attrSchema = this.createAttributeMap();
            for (String attrName : attrSchema.keySet()) {
                allAttrs.add(new Attribute(attrName));
            }
        }
        return Collections.unmodifiableSet(allAttrs);
    }
}

