/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache;

import com.terracotta.entity.ehcache.EhcacheEntitiesNaming;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import org.terracotta.modules.ehcache.ToolkitInstanceFactoryImpl;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitObjectType;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.feature.NonStopFeature;

public class EnterpriseToolkitInstanceFactory
extends ToolkitInstanceFactoryImpl {
    private static final String SEARCH_ATTRIBUTE_EXTRACTORS_MAP_SUFFIX = "searchAttributeExtractorsMap";
    private static final String TOOLKIT_ATTRIBUTE_SCHEMA_MAP_SUFFIX = "toolkitSchemaMap";

    public EnterpriseToolkitInstanceFactory(TerracottaClientConfiguration terracottaClientConfiguration) {
        super(terracottaClientConfiguration);
    }

    public EnterpriseToolkitInstanceFactory(TerracottaClientConfiguration terracottaClientConfiguration, String productId) {
        super(terracottaClientConfiguration, productId);
    }

    @Override
    public ToolkitMap<String, AttributeExtractor> getOrCreateExtractorsMap(String cacheManagerName, String cacheName) {
        String extractorMapName = EhcacheEntitiesNaming.getToolkitCacheNameFor(cacheManagerName, cacheName) + "|" + SEARCH_ATTRIBUTE_EXTRACTORS_MAP_SUFFIX;
        return this.getOrCreateMap(cacheName, extractorMapName, AttributeExtractor.class);
    }

    @Override
    public boolean destroy(String cacheManagerName, String cacheName) {
        boolean existed = super.destroy(cacheManagerName, cacheName);
        this.getOrCreateExtractorsMap(cacheManagerName, cacheName).destroy();
        this.getOrCreateAttributeMap(cacheManagerName, cacheName).destroy();
        return existed;
    }

    @Override
    public ToolkitMap<String, String> getOrCreateAttributeMap(String cacheManagerName, String cacheName) {
        String attributeMapName = EhcacheEntitiesNaming.getToolkitCacheNameFor(cacheManagerName, cacheName) + "|" + TOOLKIT_ATTRIBUTE_SCHEMA_MAP_SUFFIX;
        return this.getOrCreateMap(cacheName, attributeMapName, String.class);
    }

    @Override
    protected void addNonStopConfigForCache(CacheConfiguration ehcacheConfig, String fullyQualifiedCacheName) {
        super.addNonStopConfigForCache(ehcacheConfig, fullyQualifiedCacheName);
        ((NonStopFeature)this.toolkit.getFeature(ToolkitFeatureType.NONSTOP)).getNonStopConfigurationRegistry().registerTimeoutForSearch(ehcacheConfig.getTerracottaConfiguration().getNonstopConfiguration().getSearchTimeoutMillis(), fullyQualifiedCacheName, ToolkitObjectType.CACHE);
    }

    private <T> ToolkitMap<String, T> getOrCreateMap(String cacheName, String mapName, Class<T> valueClass) {
        ToolkitMap map = this.toolkit.getMap(mapName, String.class, valueClass);
        this.addCacheMetaInfo(cacheName, ToolkitObjectType.MAP, mapName);
        return map;
    }
}

