/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.EnterpriseLicense;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;
import org.terracotta.license.util.IOUtils;
import org.terracotta.license.util.Utils;

public class EnterpriseLicenseResolverFactory
extends AbstractLicenseResolverFactory {
    private static final boolean DEBUG_LICENSE = Boolean.getBoolean("org.terracotta.license.debug");
    private static final String TC_INSTALL_ROOT = "tc.install-root";
    private static final boolean SKIP_DEFAULT_LOCATION = Boolean.getBoolean("org.terracotta.license.skip.default.locations");
    private static final String DEFAULT_LICENSE_RESOURCE_PATH = "/terracotta-license.key";
    private String licenseLocation;

    @Override
    public License resolveLicense() {
        License license = null;
        String path = null;
        path = this.getProperty("com.tc.productkey.resource.path");
        this.debugLog("Trying to load license from property com.tc.productkey.resource.path, value '" + path + "'");
        if (path != null && (license = this.resolveLicenseFromResource(path)) != null) {
            return license;
        }
        for (String key : new String[]{"org.terracotta.license.path", "com.tc.productkey.path"}) {
            path = this.getProperty(key);
            this.debugLog("Trying to load license from property " + key + ", value '" + path + "'");
            if (path == null || (license = this.resolveLicenseFromPath(path)) == null) continue;
            return license;
        }
        if (!SKIP_DEFAULT_LOCATION) {
            path = this.getProperty(TC_INSTALL_ROOT);
            this.debugLog("Trying to load license from property tc.install-root, value '" + path + "'");
            if (path != null) {
                license = this.loadFromDefaultPath(path + File.separator + "terracotta-license.key");
                if (license != null) {
                    return license;
                }
                license = this.loadFromDefaultPath(path + File.separator + "product.key");
                if (license != null) {
                    return license;
                }
            }
            this.debugLog("Trying to load license from resource /terracotta-license.key");
            license = this.resolveLicenseFromResource(DEFAULT_LICENSE_RESOURCE_PATH);
            if (license != null) {
                return license;
            }
        }
        return null;
    }

    private License loadFromDefaultPath(String path) {
        File rootLicenseKey = new File(path);
        if (rootLicenseKey.exists()) {
            try {
                return this.resolveLicenseFromPath(rootLicenseKey.getCanonicalPath());
            }
            catch (IOException e) {
                throw new LicenseException(e);
            }
        }
        return null;
    }

    @Override
    public String getLicenseLocation() {
        return this.licenseLocation;
    }

    protected License resolveLicenseFromPath(String productKeyPath) {
        License license;
        this.debugLog("Resolving license from path " + productKeyPath);
        if (productKeyPath == null) {
            return null;
        }
        if (productKeyPath.startsWith("resource:")) {
            String resourcePath = productKeyPath.substring("resource:".length());
            this.debugLog("XXX Path starts with 'resource:', will load as resource " + resourcePath);
            return this.resolveLicenseFromResource(resourcePath);
        }
        File productKeyFile = new File(productKeyPath);
        if (!productKeyFile.isFile() || !productKeyFile.canRead()) {
            throw new LicenseException("License key file " + productKeyFile.getAbsolutePath() + " does not exist or cannot be read");
        }
        FileInputStream in = null;
        try {
            this.licenseLocation = productKeyPath;
            in = new FileInputStream(productKeyFile);
            license = this.resolveLicenseFromStream(in);
        }
        catch (FileNotFoundException e) {
            try {
                throw new LicenseException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected License resolveLicenseFromResource(String resourcePath) {
        InputStream in = EnterpriseLicenseResolverFactory.class.getResourceAsStream(resourcePath);
        if (in == null) {
            return null;
        }
        try {
            this.licenseLocation = "resource " + resourcePath;
            License license = this.resolveLicenseFromStream(in);
            return license;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    protected License resolveLicenseFromStream(InputStream in) {
        if (in == null) {
            return null;
        }
        Properties licenseProps = null;
        try {
            List<String> lines = Utils.readLines(in);
            licenseProps = Utils.loadProperties(lines);
            EnterpriseLicense license = new EnterpriseLicense(licenseProps);
            license.verify();
            return license;
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException(e.getMessage());
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage());
        }
    }

    @Override
    public License resolveLicense(InputStream in) {
        this.licenseLocation = "stream";
        return this.resolveLicenseFromStream(in);
    }

    private void debugLog(String message) {
        if (DEBUG_LICENSE) {
            System.err.println(String.format("[DEBUG] %s: %s", EnterpriseLicenseResolverFactory.class.getName(), message));
            System.err.flush();
        }
    }

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

