/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.terracotta.license.AbstractLicense;
import org.terracotta.license.LicenseConstants;

public class EnterpriseLicense
extends AbstractLicense {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final List<String> PRINT_ORDER = Arrays.asList("Date of Issue", "Expiration Date", "License Type", "License Number", "Licensee", "Email", "Product", "Edition", "Capabilities", "Max Client Count", "ehcache.maxOffHeap", "terracotta.serverArray.maxOffHeap");

    public EnterpriseLicense(Properties properties) {
        super(properties);
    }

    public String toString() {
        String value;
        StringBuffer sb = new StringBuffer();
        TreeSet<Object> keys = new TreeSet<Object>(this.properties.keySet());
        for (String string : PRINT_ORDER) {
            value = this.properties.getProperty(string);
            if (value == null || LicenseConstants.IGNORED_KEYS.contains(string)) continue;
            this.addLine(sb, string, value);
        }
        for (String string : keys) {
            if (PRINT_ORDER.contains(string)) continue;
            value = this.properties.getProperty(string);
            if (LicenseConstants.IGNORED_KEYS.contains(string)) continue;
            this.addLine(sb, string, value);
        }
        return sb.toString();
    }

    private StringBuffer addLine(StringBuffer sb, String key, String value) {
        return sb.append(key).append(": ").append(value).append(NEWLINE);
    }
}

