/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.search;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.listener.ListenableStorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.util.Factory;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.GroupedQueryResult;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.LuceneIndexManager;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NonGroupedQueryResult;
import com.terracottatech.search.NullProcessingContext;
import com.terracottatech.search.ProcessingContext;
import com.terracottatech.search.SearchBuilder;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.Util;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheStoreHelper;
import net.sf.ehcache.DiskStorePathManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementIdHelper;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.DynamicAttributesExtractor;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.DynamicSearchChecker;
import net.sf.ehcache.search.impl.GroupedResultImpl;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TxCopyingCacheStore;
import net.sf.ehcache.store.offheap.search.SearchStorageEngineListener;
import net.sf.ehcache.store.offheap.search.Slf4jLoggerFactory;
import net.sf.ehcache.store.offheap.search.StandaloneQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexedSearchManager
implements SearchManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexedSearchManager.class);
    private static final boolean USE_COMMIT_THREAD = LuceneIndexedSearchManager.getProp("useCommitThread", false);
    private static final boolean USE_RAM_DIR = LuceneIndexedSearchManager.getProp("useRamDir", false);
    private static final boolean DISABLE_FIELD_COMPRESSION = LuceneIndexedSearchManager.getProp("disableLuceneFieldCompression", false);
    private static final int MAX_CONCURRENT_QUERIES = LuceneIndexedSearchManager.getProp("maxConcurrentProperties", 4);
    private static final int INDEXES_PER_CACHE = LuceneIndexedSearchManager.getProp("indexesPerCache", 4);
    private static final int OFFHEAP_FILESYSTEM_CONCURRENCY = LuceneIndexedSearchManager.getProp("offHeapFileSystemConcurrency", 4);
    private static final int OFFHEAP_FILESYSTEM_BLOCK_SIZE = LuceneIndexedSearchManager.getProp("offHeapFileSystemBlockSize", 8192);
    private static final int OFFHEAP_FILESYSTEM_PAGE_SIZE = LuceneIndexedSearchManager.getProp("offHeapFileSystemPageSize", 262144);
    private static final Integer MAX_MERGE_THREADS = LuceneIndexedSearchManager.getProp("maxLuceneMergeThreads");
    private static final int MAX_BOOLEAN_CLAUSE_COUNT = LuceneIndexedSearchManager.getProp("maxBooleanClauses", 1024);
    private static final Integer MAX_INDEX_RAM_BUFFER_MB = LuceneIndexedSearchManager.getProp("maxRAMBufferPerIndex");
    private static final Set<String> EXTRA_ATTRS = Collections.singleton("__TC_KEY_FIELD");
    private static final Object[] EMPTY = new Object[0];
    private static final ProcessingContext NULL_CONTEXT = new NullProcessingContext();
    private final LuceneIndexManager indexManager;
    private final ConcurrentMap<String, CacheResources> cacheResources = new ConcurrentHashMap<String, CacheResources>();
    private static final String CLEAN_SHUTDOWN_MARKER = ".cleanShutdown";
    private final boolean useOffheapDirectory;
    private final File cleanShutdown;
    private final AtomicBoolean shouldIndex = new AtomicBoolean(true);

    public LuceneIndexedSearchManager(DiskStorePathManager diskStorePathManager, PageSource pageSource) {
        this.useOffheapDirectory = pageSource != null;
        Configuration searchConfig = new Configuration(INDEXES_PER_CACHE, MAX_CONCURRENT_QUERIES, this.useOffheapDirectory, USE_RAM_DIR, USE_COMMIT_THREAD, OFFHEAP_FILESYSTEM_CONCURRENCY, OFFHEAP_FILESYSTEM_BLOCK_SIZE, OFFHEAP_FILESYSTEM_PAGE_SIZE);
        searchConfig.setDoAccessChecks(false);
        searchConfig.setMaxClauseCount(MAX_BOOLEAN_CLAUSE_COUNT);
        searchConfig.setDisableStoredFieldCompression(DISABLE_FIELD_COMPRESSION);
        if (MAX_MERGE_THREADS != null) {
            searchConfig.setMaxMergeThreadCount(MAX_MERGE_THREADS);
        }
        if (MAX_INDEX_RAM_BUFFER_MB != null) {
            searchConfig.setMaxRamBufferSize(MAX_INDEX_RAM_BUFFER_MB.intValue());
        }
        File indexDirectory = diskStorePathManager.getFile("search-index");
        this.cleanShutdown = diskStorePathManager.getFile(CLEAN_SHUTDOWN_MARKER);
        try {
            if (indexDirectory.isDirectory()) {
                if (!this.wasShutdownCleanly()) {
                    LOGGER.info("Detected un-clean shutdown in the former session. Deleting existing search index files in [" + indexDirectory.getAbsolutePath() + "]");
                    Util.cleanDirectory(indexDirectory);
                    this.shouldIndex.set(true);
                } else if (!this.useOffheapDirectory) {
                    LOGGER.info("Detected clean shutdown in the former session. Not attempting search index recovery in [" + indexDirectory.getAbsolutePath() + "]");
                    this.shouldIndex.set(false);
                }
            }
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        this.indexManager = this.useOffheapDirectory ? new LuceneIndexManager(indexDirectory, false, new Slf4jLoggerFactory(), searchConfig, pageSource) : new LuceneIndexManager(indexDirectory, false, new Slf4jLoggerFactory(), searchConfig);
    }

    public void initAttributeTypeSchema(String cacheName, Map<String, Class<?>> schema) {
        try {
            if (!schema.isEmpty()) {
                this.indexManager.initIndexSchema(cacheName, schema);
            }
        }
        catch (IndexException e) {
            throw new CacheException("Failed to initialize attribute type schema for cache " + cacheName, e);
        }
    }

    public void startup() {
        try {
            this.indexManager.init();
        }
        catch (IOException e) {
            throw new CacheException("Failed to initialize search index", e);
        }
    }

    public void shutdown() {
        this.cacheResources.clear();
        try {
            this.indexManager.shutdown();
            if (!this.useOffheapDirectory) {
                this.createCleanShutdownFile();
            }
        }
        catch (IndexException e) {
            LOGGER.warn("Failed to cleanly shutdown index manager", (Throwable)e);
        }
    }

    public void destroy(String cacheName) {
        this.cacheResources.remove(cacheName);
        try {
            this.indexManager.destroy(cacheName, NULL_CONTEXT);
        }
        catch (IndexException e) {
            throw new CacheException("Failed to destroy index for cache " + cacheName, e);
        }
    }

    @Override
    public void clear(String cacheName, int segmentId) {
        try {
            this.indexManager.clear(cacheName, segmentId, NULL_CONTEXT);
        }
        catch (IndexException e) {
            throw new CacheException(e);
        }
    }

    public boolean shouldIndex() {
        return this.shouldIndex.get();
    }

    public void recoveryComplete() {
        LOGGER.info("Search Indices recovered, deleting old clean-shutdown file and resuming normal operation.");
        this.cleanShutdown.delete();
        this.shouldIndex.set(true);
    }

    @Override
    public void put(String cacheName, int segmentId, Element element, byte[] serializedKey, Map<String, AttributeExtractor> extractors, DynamicAttributesExtractor dynamicIndexer) {
        ArrayList<NVPair> attrs = new ArrayList<NVPair>(extractors.size());
        for (Map.Entry<String, AttributeExtractor> extractor : extractors.entrySet()) {
            String name = extractor.getKey();
            Object value = extractor.getValue().attributeFor(element, name);
            if (value == null) continue;
            attrs.add(AbstractNVPair.createNVPair(name, value));
        }
        Map<String, ? extends Object> dynamicAttrs = DynamicSearchChecker.getSearchAttributes(element, extractors.keySet(), dynamicIndexer);
        for (Map.Entry<String, ? extends Object> entry : dynamicAttrs.entrySet()) {
            if (entry.getValue() == null) continue;
            attrs.add(AbstractNVPair.createNVPair(entry.getKey(), entry.getValue()));
        }
        CacheResources cr = (CacheResources)this.cacheResources.get(cacheName);
        if (cr == null) {
            throw new IllegalStateException("Missing cache resources for cache " + cacheName);
        }
        for (String attrName : dynamicAttrs.keySet()) {
            cr.knownSearchAttributes.put(attrName, new Attribute(attrName));
        }
        try {
            this.indexManager.update(cacheName, LuceneIndexedSearchManager.serializeToString(serializedKey), new ValueID(ElementIdHelper.getId(element)), attrs, Collections.EMPTY_LIST, segmentId, NULL_CONTEXT);
        }
        catch (IndexException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void remove(String cacheName, Object uniqueKey, int segmentId, boolean isRemoval) {
        if (!isRemoval) {
            return;
        }
        try {
            this.indexManager.remove(cacheName, LuceneIndexedSearchManager.serializeToString(uniqueKey), segmentId, NULL_CONTEXT);
        }
        catch (IndexException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public Results executeQuery(StoreQuery query, Map<String, AttributeExtractor> attributeExtractors, DynamicAttributesExtractor dynIndexer) {
        SearchResult searchResults;
        final Cache cache = query.getCache();
        boolean requestExtraAttrs = query.requestsKeys() || query.requestsValues();
        Set<String> extraAttributes = requestExtraAttrs ? EXTRA_ATTRS : Collections.emptySet();
        StandaloneQueryInterpreter interpreter = new StandaloneQueryInterpreter(extraAttributes);
        interpreter.process(query);
        SearchBuilder.Search search = interpreter.build();
        try {
            searchResults = this.indexManager.searchIndex(cache.getName(), -1L, -1L, search.getQueryStack(), false, search.isIncludeValues(), search.getAttributes(), search.getGroupByAttrs(), search.getSortAttributes(), search.getAggregatorList(), search.getMaxResults(), -1);
        }
        catch (IndexException e) {
            throw new SearchException(e.getMessage());
        }
        List<Object> aggregateResults = LuceneIndexedSearchManager.getAggregateResults(searchResults.getAggregators());
        ArrayList<BaseResult> resultList = new ArrayList<BaseResult>(searchResults.getQueryResults().size());
        boolean isGroupBy = !search.getGroupByAttrs().isEmpty();
        for (IndexQueryResult indexResult : searchResults.getQueryResults()) {
            Map<String, Object> attributes = LuceneIndexedSearchManager.makeAttributeMap(indexResult.getAttributes());
            BaseResult result = null;
            if (!isGroupBy) {
                Serializable key;
                if (requestExtraAttrs) {
                    String serializedKey = (String)attributes.remove("__TC_KEY_FIELD");
                    key = this.deserializeFromString(cache.getName(), serializedKey);
                } else {
                    key = null;
                }
                if (search.getMaxResults() > 0) {
                    attributes.keySet().retainAll(search.getAttributes());
                }
                if (attributes.isEmpty() && !requestExtraAttrs) break;
                NonGroupedQueryResult queryRes = (NonGroupedQueryResult)indexResult;
                ValueID value = queryRes.getValue();
                result = new ResultImpl(key, value, query, attributes, EMPTY){
                    private volatile Object resolvedValue;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Object basicGetValue() {
                        Object rv = this.resolvedValue;
                        if (rv != null) {
                            return rv;
                        }
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            rv = this.resolvedValue;
                            if (rv != null) {
                                return rv;
                            }
                            ValueID vid = (ValueID)super.basicGetValue();
                            CacheStoreHelper cacheStoreHelper = new CacheStoreHelper(cache);
                            Store store = cacheStoreHelper.getStore();
                            Element e = store instanceof TxCopyingCacheStore ? ((TxCopyingCacheStore)store).getOldElement(key) : cache.getQuiet(key);
                            if (e != null && ElementIdHelper.getId(e) == vid.toLong()) {
                                this.resolvedValue = rv = e.getObjectValue();
                                return rv;
                            }
                            return null;
                        }
                    }
                };
                result.setAggregateResults(aggregateResults);
            } else {
                if (search.getMaxResults() >= 0 && resultList.size() == search.getMaxResults()) break;
                GroupedQueryResult queryRes = (GroupedQueryResult)indexResult;
                aggregateResults = LuceneIndexedSearchManager.getAggregateResults(queryRes.getAggregators());
                result = new GroupedResultImpl(query, attributes, EMPTY, aggregateResults, LuceneIndexedSearchManager.makeAttributeMap(queryRes.getGroupedAttributes()));
            }
            resultList.add(result);
        }
        if (searchResults.isAnyCriteriaMatch() && resultList.isEmpty() && !aggregateResults.isEmpty()) {
            AggregateOnlyResult aggOnly = new AggregateOnlyResult(query);
            aggOnly.setAggregateResults(aggregateResults);
            resultList.add(aggOnly);
        }
        ResultsImpl rv = new ResultsImpl(resultList, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), searchResults.isAnyCriteriaMatch() && !aggregateResults.isEmpty());
        return rv;
    }

    private static List<Object> getAggregateResults(List<Aggregator> aggregators) {
        if (aggregators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(aggregators.size());
        for (Aggregator aggregator : aggregators) {
            list.add(aggregator.getResult());
        }
        return list;
    }

    private static Map<String, Object> makeAttributeMap(Collection<NVPair> attributes) {
        HashMap<String, Object> map = new HashMap<String, Object>(attributes.size());
        for (NVPair pair : attributes) {
            map.put(pair.getName(), pair.getObjectValue());
        }
        return map;
    }

    public <T extends ListenableStorageEngine<Serializable, Element>> Factory<T> newSearchStorageEngineListeningFactory(final Factory<T> storageEngineFactory, Portability<Serializable> keyPortability, final CacheConfiguration cacheConfiguration) {
        CacheResources cr;
        String cacheName = cacheConfiguration.getName();
        CacheResources prev = this.cacheResources.putIfAbsent(cacheName, cr = new CacheResources(keyPortability, cacheConfiguration));
        if (prev != null) {
            if (prev.getKeyPortability() != keyPortability) {
                throw new AssertionError((Object)("Observed more than one keyPortability for cache " + cacheName));
            }
            cr = prev;
        }
        final CacheResources finalCr = cr;
        return new Factory<T>(){

            @Override
            public T newInstance() {
                ListenableStorageEngine storageEngine = (ListenableStorageEngine)storageEngineFactory.newInstance();
                storageEngine.registerListener(new SearchStorageEngineListener(LuceneIndexedSearchManager.this, cacheConfiguration, finalCr.getNextSegmentId()));
                return storageEngine;
            }
        };
    }

    @Override
    public Set<Attribute> getSearchAttributes(String cacheName) {
        CacheResources cr = (CacheResources)this.cacheResources.get(cacheName);
        if (cr == null) {
            return Collections.emptySet();
        }
        return new HashSet<Attribute>(cr.knownSearchAttributes.values());
    }

    private boolean wasShutdownCleanly() {
        return this.cleanShutdown.exists();
    }

    private void createCleanShutdownFile() {
        try {
            LOGGER.info("Creating clean-shutdown file in [" + this.cleanShutdown.getAbsolutePath() + "]");
            this.cleanShutdown.createNewFile();
        }
        catch (IOException e) {
            throw new CacheException("Failed to create the clean-shutdown file " + e);
        }
    }

    private static boolean getProp(String prop, boolean defaultValue) {
        String sysProp = LuceneIndexedSearchManager.class.getName() + "." + prop;
        String val = System.getProperty(sysProp);
        if (val != null) {
            return Boolean.parseBoolean(val.trim());
        }
        return defaultValue;
    }

    private static int getProp(String prop, int defaultValue) {
        String sysProp = LuceneIndexedSearchManager.class.getName() + "." + prop;
        return Integer.getInteger(sysProp, defaultValue);
    }

    private static Integer getProp(String prop) {
        String sysProp = LuceneIndexedSearchManager.class.getName() + "." + prop;
        return Integer.getInteger(sysProp);
    }

    private static String serializeToString(Object key) {
        byte[] buf = (byte[])key;
        StringBuilder sb = new StringBuilder(buf.length);
        for (byte b : buf) {
            sb.append((char)(b & 0xFF));
        }
        return sb.toString();
    }

    private Serializable deserializeFromString(String cacheName, String serializedKey) {
        char[] buf = serializedKey.toCharArray();
        byte[] dest = new byte[buf.length];
        int i = 0;
        for (char c : buf) {
            dest[i++] = (byte)(c & 0xFF);
        }
        return (Serializable)((CacheResources)this.cacheResources.get(cacheName)).getKeyPortability().decode(ByteBuffer.wrap(dest));
    }

    private static class CacheResources {
        private final AtomicInteger segmentIdSequence = new AtomicInteger();
        private final Portability<Serializable> keyPortability;
        private final ConcurrentMap<String, Attribute> knownSearchAttributes;

        private CacheResources(Portability<Serializable> keyPortability, CacheConfiguration cfg) {
            this.keyPortability = keyPortability;
            this.knownSearchAttributes = new ConcurrentHashMap<String, Attribute>(cfg.getSearchAttributes().size());
            for (SearchAttribute sa : cfg.getSearchAttributes().values()) {
                this.knownSearchAttributes.put(sa.getName(), new Attribute(sa.getName()));
            }
        }

        private Portability<Serializable> getKeyPortability() {
            return this.keyPortability;
        }

        private int getNextSegmentId() {
            return this.segmentIdSequence.getAndIncrement();
        }
    }
}

