/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import com.terracottatech.offheapstore.paging.PageSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.FeaturesManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.store.CacheStore;
import net.sf.ehcache.store.ElementIdAssigningStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.cachingtier.OnHeapCachingTier;
import net.sf.ehcache.store.heap.RestartableHeapStore;
import net.sf.ehcache.store.offheap.OffHeapStoreFactory;
import net.sf.ehcache.store.offheap.configuration.HeuristicPoolConfiguration;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStoreFactory;
import net.sf.ehcache.store.offheap.disk.persistent.OffHeapPersistentDiskStore;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolImpl;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.store.restartability.RestartableSoftLockManager;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.SoftLockManagerImpl;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.TransactionIDFactoryImpl;
import net.sf.ehcache.util.AtomicLongSequence;
import net.sf.ehcache.util.EnterpriseUpdateChecker;
import net.sf.ehcache.util.LongSequence;
import net.sf.ehcache.util.UpdateChecker;
import net.sf.ehcache.writer.writebehind.RestartableWriteBehindQueueManager;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.ehcachedx.util.Vm;
import org.terracotta.license.LicenseException;
import org.terracotta.license.ehcache.LicenseManager;

public class EnterpriseFeaturesManager
implements FeaturesManager {
    private final EhcacheRestartability restartability;
    private final CacheManager cacheManager;
    private final PageSource pageSource;
    private volatile LuceneIndexedSearchManager luceneIndexedSearchManager;
    private volatile OffHeapPool offheapPool;

    public EnterpriseFeaturesManager(CacheManager manager) {
        LicenseManager.assertLicenseValid();
        this.cacheManager = manager;
        TerracottaClientConfiguration terracottaClientCfg = this.cacheManager.getConfiguration().getTerracottaConfiguration();
        if (terracottaClientCfg != null) {
            LicenseManager.verifyWanReplication(terracottaClientCfg);
        }
        this.restartability = new EhcacheRestartability(manager);
        if (Boolean.getBoolean("net.sf.ehcache.search.useOffheapIndex")) {
            if (!manager.getConfiguration().isMaxBytesLocalOffHeapSet()) {
                throw new InvalidConfigurationException("To use offheap search index you must configure a cacheManager level maxBytesLocalOffHeap");
            }
            this.pageSource = this.getOrCreateCacheManagerOffHeapPool().getPageSource();
        } else {
            this.pageSource = null;
        }
    }

    private OffHeapPool getOrCreateCacheManagerOffHeapPool() {
        if (this.offheapPool == null) {
            HeuristicPoolConfiguration poolConfig = this.getPoolConfig(this.cacheManager);
            long size = poolConfig.getMaximumSize();
            LicenseManager.verifyOffHeapUsage(this.cacheManager, null, size);
            this.offheapPool = new OffHeapPoolImpl(poolConfig);
            LicenseManager.commitOffHeapUsage(this.cacheManager, null, size);
        }
        return this.offheapPool;
    }

    @Override
    public synchronized void startup() {
        this.restartability.startup();
        if (this.luceneIndexedSearchManager != null) {
            this.luceneIndexedSearchManager.recoveryComplete();
        }
    }

    @Override
    public synchronized void dispose() {
        this.restartability.shutdown();
        if (this.luceneIndexedSearchManager != null) {
            this.luceneIndexedSearchManager.shutdown();
        }
    }

    @Override
    public synchronized Store createStore(Cache cache, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration cacheConfig = cache.getCacheConfiguration();
        long offHeapSize = 0L;
        if (cacheConfig.isOverflowToOffHeap()) {
            offHeapSize = EnterpriseFeaturesManager.getOffHeapSize(cache.getCacheConfiguration(), cache.getCacheManager().getConfiguration().getMaxBytesLocalOffHeap());
            try {
                LicenseManager.verifyOffHeapUsage(cache.getCacheManager(), cache.getName(), offHeapSize);
            }
            catch (LicenseException e) {
                throw new CacheException(e.getMessage());
            }
        }
        Store store = this.basicCreateStore(cache, onHeapPool, onDiskPool);
        if (offHeapSize > 0L) {
            LicenseManager.commitOffHeapUsage(cache.getCacheManager(), cache.getName(), offHeapSize);
        }
        if (cache.isSearchable()) {
            LongSequence sequence = cacheConfig.getPersistenceConfiguration() == null || cacheConfig.getPersistenceConfiguration().getStrategy() != PersistenceConfiguration.Strategy.LOCALRESTARTABLE ? new AtomicLongSequence() : this.restartability.getElementIdSequence(cache.getName());
            store = new ElementIdAssigningStore(store, sequence);
        }
        return store;
    }

    private Store basicCreateStore(Cache cache, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        PersistenceConfiguration persistence = config.getPersistenceConfiguration();
        if (persistence == null) {
            if (EnterpriseFeaturesManager.isDiskPersistent(config)) {
                throw new AssertionError((Object)"Configuration is inconsistent");
            }
            return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
        }
        switch (persistence.getStrategy()) {
            case NONE: {
                return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
            }
            case LOCALTEMPSWAP: {
                if (EnterpriseFeaturesManager.isDiskPersistent(config)) {
                    return this.createPersistentStore(cache, onHeapPool, onDiskPool);
                }
                return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
            }
            case LOCALRESTARTABLE: {
                boolean synchronousWrites = persistence.getSynchronousWrites();
                return this.createRestartableStore(cache, onHeapPool, onDiskPool, synchronousWrites);
            }
            case DISTRIBUTED: {
                throw new InvalidConfigurationException("Cannot use \"distributed\" persistence in an unclustered cache.");
            }
        }
        throw new AssertionError((Object)"this should be unreachable code");
    }

    private static long getOffHeapSize(CacheConfiguration cacheConfig, long cacheManagerOffHeapBytes) {
        if (cacheConfig.isMaxBytesLocalOffHeapPercentageSet()) {
            return cacheManagerOffHeapBytes * (long)cacheConfig.getMaxBytesLocalOffHeapPercentage().intValue() / 100L;
        }
        return cacheConfig.getMaxBytesLocalOffHeap();
    }

    private LuceneIndexedSearchManager getOrCreateSearchManager(Cache cache) {
        if (!cache.isSearchable()) {
            return null;
        }
        if (this.luceneIndexedSearchManager == null) {
            this.luceneIndexedSearchManager = new LuceneIndexedSearchManager(this.cacheManager.getDiskStorePathManager(), this.pageSource);
            this.luceneIndexedSearchManager.startup();
        }
        this.luceneIndexedSearchManager.initAttributeTypeSchema(cache.getName(), this.getSearchSchema(cache.getCacheConfiguration().getSearchAttributes()));
        return this.luceneIndexedSearchManager;
    }

    private Map<String, Class<?>> getSearchSchema(Map<String, SearchAttribute> attributes) {
        HashMap schema = new HashMap();
        for (Map.Entry<String, SearchAttribute> sa : attributes.entrySet()) {
            String attrName = sa.getKey();
            Class<?> attrType = ConfigurationHelper.getSearchAttributeType(sa.getValue());
            if (attrType == null) continue;
            schema.put(attrName, attrType);
        }
        return Collections.unmodifiableMap(schema);
    }

    private Store createNonPersistentStore(Cache cache, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        if (config.isOverflowToDisk()) {
            LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
            if (config.isOverflowToOffHeap()) {
                OffHeapDiskStore authority = OffHeapDiskStoreFactory.create(cache, onDiskPool, searchManager);
                return new CacheStore(OffHeapStoreFactory.createCachingTier(cache, this.getOffHeapPool(cache), OnHeapCachingTier.createOnHeapCache(cache, onHeapPool)), authority, config);
            }
            OffHeapDiskStore authority = OffHeapDiskStoreFactory.create(cache, onDiskPool, searchManager);
            OnHeapCachingTier<Object, Element> onHeapCache = OnHeapCachingTier.createOnHeapCache(cache, onHeapPool);
            return new CacheStore(onHeapCache, authority, config);
        }
        if (config.isOverflowToOffHeap()) {
            LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
            return new CacheStore(OnHeapCachingTier.createOnHeapCache(cache, onHeapPool), OffHeapStoreFactory.createAuthority(cache, this.getOffHeapPool(cache), searchManager));
        }
        return MemoryStore.create(cache, onHeapPool);
    }

    private Store createPersistentStore(Cache cache, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
        if (config.isOverflowToOffHeap()) {
            OffHeapPersistentDiskStore authority = OffHeapDiskStoreFactory.createPersistent(cache, onDiskPool, searchManager);
            return new CacheStore(OffHeapStoreFactory.createCachingTier(cache, this.getOffHeapPool(cache), OnHeapCachingTier.createOnHeapCache(cache, onHeapPool)), authority, config);
        }
        OffHeapPersistentDiskStore authority = OffHeapDiskStoreFactory.createPersistent(cache, onDiskPool, searchManager);
        OnHeapCachingTier<Object, Element> onHeapCache = OnHeapCachingTier.createOnHeapCache(cache, onHeapPool);
        return new CacheStore(onHeapCache, authority, config);
    }

    private Store createRestartableStore(Cache cache, Pool onHeapPool, Pool onDiskPool, boolean synchronousWrites) {
        Boolean persistentTxns;
        CacheConfiguration config = cache.getCacheConfiguration();
        if (!CacheConfiguration.TransactionalMode.OFF.equals((Object)config.getTransactionalMode()) && Boolean.FALSE.equals(persistentTxns = cache.getCacheManager().getOrCreateTransactionIDFactory().isPersistent())) {
            throw new InvalidConfigurationException("Transactions system is already bootstrapped as non-persistent - cannot add a restartable cache");
        }
        if (config.isOverflowToDisk()) {
            throw new AssertionError();
        }
        if (config.isOverflowToOffHeap()) {
            LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
            return new CacheStore(OnHeapCachingTier.createOnHeapCache(cache, onHeapPool), OffHeapStoreFactory.createRestartableAuthority(this.restartability, cache, this.getOffHeapPool(cache), searchManager, synchronousWrites));
        }
        return RestartableHeapStore.create(this.restartability, synchronousWrites, cache, onHeapPool);
    }

    public static long getMaxBytesAllocatable() {
        return Math.min(Vm.maxDirectMemory(), LicenseManager.getEhcacheOffHeapTotalSizeLimit());
    }

    private OffHeapPool getOffHeapPool(Cache cache) {
        if (cache.getCacheConfiguration().getMaxBytesLocalOffHeap() > 0L) {
            return null;
        }
        return this.getOrCreateCacheManagerOffHeapPool();
    }

    private HeuristicPoolConfiguration getPoolConfig(CacheManager manager) {
        return new HeuristicPoolConfiguration(manager.getName(), EnterpriseFeaturesManager.calculateCacheManagerFreeMaxBytesLocalOffHeap(manager), EnterpriseFeaturesManager.calculateCacheCountSharingCacheManagerOffHeapPool(manager));
    }

    private static long calculateCacheManagerFreeMaxBytesLocalOffHeap(CacheManager manager) {
        Map<String, CacheConfiguration> cacheConfigurations = manager.getConfiguration().getCacheConfigurations();
        long totalCacheSpecificMemory = 0L;
        for (CacheConfiguration cacheConfig : cacheConfigurations.values()) {
            totalCacheSpecificMemory += EnterpriseFeaturesManager.getOffHeapSize(cacheConfig, manager.getConfiguration().getMaxBytesLocalOffHeap());
        }
        return manager.getConfiguration().getMaxBytesLocalOffHeap() - totalCacheSpecificMemory;
    }

    private static int calculateCacheCountSharingCacheManagerOffHeapPool(CacheManager manager) {
        Map<String, CacheConfiguration> cacheConfigurations = manager.getConfiguration().getCacheConfigurations();
        Iterator<Map.Entry<String, CacheConfiguration>> iterator = cacheConfigurations.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, CacheConfiguration> entry = iterator.next();
            if (entry.getValue().getMaxBytesLocalOffHeapPercentage() != null && entry.getValue().getMaxBytesLocalOffHeap() <= 0L) continue;
            ++count;
        }
        return count;
    }

    private static boolean isDiskPersistent(CacheConfiguration cacheConfig) {
        return cacheConfig.isDiskPersistent();
    }

    @Override
    public WriteBehind createWriteBehind(Cache cache) {
        return new RestartableWriteBehindQueueManager(cache.getCacheConfiguration(), this.restartability);
    }

    @Override
    public TransactionIDFactory createTransactionIDFactory() {
        if (this.restartability.bootstrapped()) {
            return this.restartability.getTransactionIDFactory();
        }
        return new TransactionIDFactoryImpl();
    }

    @Override
    public SoftLockManager createSoftLockManager(Ehcache cache, SoftLockFactory lockFactory) {
        if (cache.getCacheConfiguration().getPersistenceConfiguration() != null && cache.getCacheConfiguration().getPersistenceConfiguration().getStrategy() == PersistenceConfiguration.Strategy.LOCALRESTARTABLE) {
            return new RestartableSoftLockManager(cache.getName(), lockFactory, this.restartability);
        }
        return new SoftLockManagerImpl(cache.getName(), lockFactory);
    }

    @Override
    public UpdateChecker createUpdateChecker() {
        return new EnterpriseUpdateChecker(this.cacheManager);
    }
}

