/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.search.FieldCache;
import org.terracotta.shaded.lucene.search.FieldComparator;
import org.terracotta.shaded.lucene.util.BytesRef;

public class StringFieldComparator
extends FieldComparator<BytesRef> {
    private final BytesRef[] values;
    private FieldCache.DocTerms docTerms;
    private final String field;
    private BytesRef bottom;
    private final BytesRef tempBR = new BytesRef();
    private final int nullMult;

    StringFieldComparator(int numHits, String field, boolean reverse) {
        this.values = new BytesRef[numHits];
        this.nullMult = reverse ? -1 : 1;
        this.field = field;
    }

    @Override
    public int compare(int slot1, int slot2) {
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        return this.compareValues(val1, val2);
    }

    @Override
    public int compareBottom(int doc) {
        BytesRef val2 = this.docTerms.getTerm(doc, this.tempBR);
        return this.compareValues(this.bottom, val2);
    }

    @Override
    public void copy(int slot, int doc) {
        if (this.values[slot] == null) {
            this.values[slot] = new BytesRef();
        }
        this.docTerms.getTerm(doc, this.values[slot]);
    }

    @Override
    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.docTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field);
        return this;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    @Override
    public BytesRef value(int slot) {
        return this.values[slot];
    }

    @Override
    public int compareValues(BytesRef val1, BytesRef val2) {
        if (StringFieldComparator.isNull(val1)) {
            if (StringFieldComparator.isNull(val2)) {
                return 0;
            }
            return -this.nullMult;
        }
        if (StringFieldComparator.isNull(val2)) {
            return this.nullMult;
        }
        return val1.compareTo(val2);
    }

    @Override
    public int compareDocToValue(int doc, BytesRef value) {
        BytesRef val1 = this.docTerms.getTerm(doc, this.tempBR);
        return this.compareValues(val1, value);
    }

    private static boolean isNull(BytesRef val) {
        return val == null || val.length == 0;
    }
}

