/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

final class QueryID {
    final long requesterId;
    private final long queryId;
    private final int hash;

    QueryID(long requesterId, long queryId) {
        this.requesterId = requesterId;
        this.queryId = queryId;
        this.hash = this.computeHash();
    }

    private int computeHash() {
        int prime = 31;
        int result = 31 + (int)(this.requesterId ^ this.requesterId >>> 32);
        result = 31 * result + (int)(this.queryId ^ this.queryId >>> 32);
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryID)) {
            return false;
        }
        QueryID q2 = (QueryID)obj;
        return this.requesterId == q2.requesterId && this.queryId == q2.queryId;
    }

    public String toString() {
        return new StringBuilder(128).append("requesterId=").append(this.requesterId).append(", queryId=").append(this.queryId).toString();
    }
}

