/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.offheapstore.filesystem.FileSystem;
import com.terracottatech.offheapstore.filesystem.impl.OffheapFileSystem;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexFile;
import com.terracottatech.search.IndexFileImpl;
import com.terracottatech.search.IndexOwner;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.LuceneIndex;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NVPairEnum;
import com.terracottatech.search.ProcessingContext;
import com.terracottatech.search.SearchBuilder;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.SearchResultsManager;
import com.terracottatech.search.SyncSnapshot;
import com.terracottatech.search.Util;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.store.OffHeapDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.FSDirectory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.store.RAMDirectory;
import org.terracotta.shaded.lucene.util.Constants;
import org.terracotta.shaded.lucene.util.IOUtils;

public class LuceneIndexManager {
    private final Logger logger;
    private final AtomicBoolean init = new AtomicBoolean();
    private final ConcurrentMap<String, IndexGroup> idxGroups = new ConcurrentHashMap<String, IndexGroup>();
    private final ConcurrentMap<String, Directory> tempDirs = new ConcurrentHashMap<String, Directory>();
    private final ConcurrentMap<Directory, IndexOutput> tempRamOutput = new ConcurrentHashMap<Directory, IndexOutput>();
    private final File indexDir;
    private final boolean ramdir;
    private final boolean offHeapdir;
    private final LoggerFactory loggerFactory;
    private final Configuration cfg;
    private final int perCacheIdxCt;
    private final ExecutorService queryThreadPool;
    private final FileSystem offHeapFileSystem;
    private boolean shutdown;
    static final String TERRACOTTA_CACHE_NAME_FILE = "__terracotta_cache_name.txt";
    static final String TERRACOTTA_SCHEMA_FILE = "__terracotta_schema.properties";

    public LuceneIndexManager(File indexDir, boolean isPermStore, LoggerFactory loggerFactory, Configuration cfg) {
        this(indexDir, isPermStore, loggerFactory, cfg, null);
    }

    public LuceneIndexManager(File indexDir, boolean isPermStore, LoggerFactory loggerFactory, Configuration cfg, PageSource pageSource) {
        this.loggerFactory = loggerFactory;
        this.cfg = cfg;
        this.logger = loggerFactory.getLogger(LuceneIndexManager.class);
        this.perCacheIdxCt = cfg.indexesPerCache();
        this.logger.info("Lucene version: " + Constants.LUCENE_MAIN_VERSION);
        this.queryThreadPool = LuceneIndexManager.createQueryThreadPool(cfg.maxConcurrentQueries(), this.perCacheIdxCt);
        this.indexDir = indexDir;
        boolean useRamdir = cfg.useRamDir();
        boolean useOffHeapdir = cfg.useOffHeap();
        if (useRamdir && useOffHeapdir) {
            throw new AssertionError((Object)"Can't have both Ram Directory and OffHeap Directory enabled !");
        }
        if (isPermStore && (useRamdir || useOffHeapdir)) {
            this.logger.warn("Persistent mode is specified - ignoring ram/offheap directory setting.");
        }
        this.ramdir = !isPermStore && useRamdir;
        boolean bl = this.offHeapdir = !isPermStore && useOffHeapdir;
        if (this.ramdir) {
            this.logger.warn("Using on-heap ram directory for search indices. Heap usage is unbounded");
        }
        if (this.offHeapdir) {
            this.logger.info("Using off-heap directory for search indices ");
            this.offHeapFileSystem = new OffheapFileSystem(pageSource, cfg.getOffHeapFileBlockSize(), cfg.getOffHeapFileMaxPageSize(), cfg.getOffHeapFileSegmentCount());
        } else {
            this.offHeapFileSystem = null;
        }
    }

    private static ExecutorService createQueryThreadPool(int maxConcurrentQueries, int idxPerCache) {
        return Executors.newFixedThreadPool(maxConcurrentQueries * idxPerCache, new ThreadFactory(){
            private final AtomicInteger ct = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread worker = new Thread(r, "SearchQueryWorker-" + this.ct.incrementAndGet());
                worker.setDaemon(true);
                return worker;
            }
        });
    }

    public void init() throws IOException {
        if (this.init.compareAndSet(false, true)) {
            Util.ensureDirectory(this.indexDir);
            this.logger.info("Initializing lucene index directory at " + this.indexDir.getAbsolutePath() + " offheap : " + this.offHeapdir + " ram : " + this.ramdir + " index/cache ratio : " + this.perCacheIdxCt);
            ArrayList<File> incomplete = new ArrayList<File>();
            FileFilter dirsOnly = new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isDirectory();
                }
            };
            for (File dir : this.indexDir.listFiles(dirsOnly)) {
                try {
                    boolean isCleanGroup = true;
                    File schemaFile = new File(dir, TERRACOTTA_SCHEMA_FILE);
                    File[] subDirs = dir.listFiles(dirsOnly);
                    if (!schemaFile.canRead() || subDirs.length != this.perCacheIdxCt) {
                        incomplete.add(dir);
                        isCleanGroup = false;
                    } else {
                        for (File subDir : subDirs) {
                            if (LuceneIndex.hasInitFile(subDir)) continue;
                            incomplete.add(dir);
                            isCleanGroup = false;
                            break;
                        }
                    }
                    if (!isCleanGroup) continue;
                    this.getOrCreateGroup(LuceneIndexManager.loadName(dir), null);
                }
                catch (IndexException e) {
                    IOException ioe = new IOException(e);
                    throw ioe;
                }
            }
            for (File dir : incomplete) {
                this.logger.warn("Removing incomplete index directory: " + dir.getAbsolutePath());
                Util.deleteDirectory(dir);
            }
            if (!this.tempDirs.isEmpty()) {
                throw new AssertionError((Object)("Not all temp ram/offheap dirs consumed: " + this.tempDirs));
            }
            if (!this.tempRamOutput.isEmpty()) {
                throw new AssertionError((Object)("Not all ram/offheap output closed: " + this.tempRamOutput));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initIndexSchema(String indexName, Map<String, Class<?>> schema) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group == null) {
            ConcurrentMap<String, IndexGroup> concurrentMap = this.idxGroups;
            synchronized (concurrentMap) {
                IndexGroup prev;
                group = this.getGroup(indexName);
                if (group == null && (prev = this.idxGroups.put(indexName, group = new IndexGroup(indexName, false))) != null) {
                    throw new AssertionError((Object)("replaced group for " + indexName));
                }
            }
            group.storeName();
            IndexGroup indexGroup = group;
            synchronized (indexGroup) {
                Map<String, AttributeProperties> idxSchema = LuceneIndexManager.convertSchema(schema);
                group.storeSchema(idxSchema);
                group.schema.putAll(idxSchema);
            }
        }
        this.logger.warn("Attempting to pass in new schema to existing index: " + indexName);
    }

    public void optimizeSearchIndex(String indexName) {
        IndexGroup indexes = this.getGroup(indexName);
        if (indexes == null) {
            this.logger.warn("Ignoring request to optimize non-existent indexes [" + indexName + "]");
            return;
        }
        indexes.optimize();
    }

    public String[] getSearchIndexNames() {
        if (!this.indexDir.isDirectory()) {
            return new String[0];
        }
        String[] res = new String[this.indexDir.list().length];
        int i = 0;
        try {
            for (File idx : this.indexDir.listFiles()) {
                res[i++] = LuceneIndexManager.loadName(idx);
            }
            return res;
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGroup(String indexName) throws IndexException {
        IndexGroup group;
        ConcurrentMap<String, IndexGroup> concurrentMap = this.idxGroups;
        synchronized (concurrentMap) {
            group = (IndexGroup)this.idxGroups.remove(indexName);
        }
        if (group == null) {
            return;
        }
        this.logger.info("Destroying existing search index for " + indexName);
        group.close(true);
        try {
            Util.deleteDirectory(group.getPath());
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexGroup getOrCreateGroup(String name, List<NVPair> attrs) throws IndexException {
        IndexGroup group = this.getGroup(name);
        if (group == null) {
            ConcurrentMap<String, IndexGroup> concurrentMap = this.idxGroups;
            synchronized (concurrentMap) {
                IndexGroup prev;
                group = this.getGroup(name);
                if (group == null && (prev = this.idxGroups.put(name, group = new IndexGroup(name, attrs == null))) != null) {
                    throw new AssertionError((Object)("replaced group for " + name));
                }
            }
            group.storeName();
            IndexGroup indexGroup = group;
            synchronized (indexGroup) {
                Map<String, AttributeProperties> idxSchema;
                if (attrs == null) {
                    idxSchema = group.loadSchema();
                } else {
                    idxSchema = LuceneIndexManager.extractSchema(attrs);
                    group.storeSchema(idxSchema);
                }
                group.schema.putAll(idxSchema);
            }
        }
        return group;
    }

    private IndexGroup getGroup(String name) {
        return (IndexGroup)this.idxGroups.get(name);
    }

    public SearchResult searchIndex(String name, SearchBuilder.Search s) throws IndexException {
        return this.searchIndex(name, s.getRequesterId(), s.getQueryId(), s.getQueryStack(), s.isIncludeKeys(), s.isIncludeValues(), s.getAttributes(), s.getGroupByAttrs(), s.getSortAttributes(), s.getAggregatorList(), s.getMaxResults(), s.getBatchSize());
    }

    public SearchResult searchIndex(String name, long requesterId, long queryId, List queryStack, boolean includeKeys, boolean includeValues, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, List<NVPair> aggregators, int maxResults, int prefetchSize) throws IndexException {
        IndexGroup indexes = this.getGroup(name);
        if (indexes == null) {
            return SearchResult.NULL_RESULT;
        }
        return indexes.searchIndex(requesterId, queryId, queryStack, includeKeys, includeValues, attributeSet, groupByAttributes, sortAttributes, aggregators, maxResults, prefetchSize);
    }

    public synchronized void shutdown() throws IndexException {
        if (this.shutdown) {
            return;
        }
        this.queryThreadPool.shutdown();
        this.shutdown = true;
        for (IndexGroup group : this.idxGroups.values()) {
            group.close();
        }
        this.idxGroups.clear();
    }

    private Directory directoryFor(String name, String idxId, File path) throws IOException {
        String dirName = LuceneIndexManager.getDirName(name, idxId);
        if (this.ramdir || this.offHeapdir) {
            Directory dir = (Directory)this.tempDirs.remove(dirName);
            if (dir == null) {
                throw new AssertionError((Object)("missing ramdir/offheap dir for " + dirName + ": " + this.tempDirs));
            }
            return dir;
        }
        return FSDirectory.open(path);
    }

    private Directory createDirectoryFor(File path, String name) throws IOException {
        if (this.ramdir) {
            return new RAMDirectory();
        }
        if (this.offHeapdir) {
            Random random = new Random();
            return new OffHeapDirectory(this.offHeapFileSystem, String.valueOf(random.nextInt()));
        }
        return FSDirectory.open(path);
    }

    public void remove(String indexName, String key, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.remove(key, segmentId, context);
        } else {
            this.logger.info("Remove ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    public void replace(String indexName, String key, ValueID value, ValueID previousValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.replaceIfPresent(key, value, previousValue, attributes, storeOnlyAttributes, segmentId, context);
        } else {
            this.logger.info("Replace ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    public void removeIfValueEqual(String indexName, Map<String, ValueID> toRemove, long segmentId, ProcessingContext context, boolean fromEviction) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.removeIfValueEqual(toRemove, segmentId, context);
        } else {
            if (!fromEviction) {
                this.logger.info("RemoveIfValueEqual ignored: no such index group [" + indexName + "] exists");
            }
            context.processed();
        }
    }

    public void update(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes);
        group.update(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void insert(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes);
        group.insert(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void putIfAbsent(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes);
        group.putIfAbsent(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void destroy(String indexName, ProcessingContext context) throws IndexException {
        this.destroyGroup(indexName);
        context.processed();
    }

    public void clear(String indexName, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.clear(segmentId, context);
        } else {
            this.logger.info("Clear ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    private static Map<String, AttributeProperties> extractSchema(List<NVPair> attributes) throws IndexException {
        HashMap<String, AttributeProperties> schema = new HashMap<String, AttributeProperties>(attributes.size());
        for (NVPair attr : attributes) {
            AttributeProperties prev = schema.put(attr.getName(), new AttributeProperties(attr, true));
            if (prev == null || LuceneIndexManager.getAttributeTypeString(attr).equals(prev.getType())) continue;
            throw new IndexException("Differing types for repeated attribute: " + attr.getName());
        }
        return schema;
    }

    private static Map<String, AttributeProperties> convertSchema(Map<String, Class<?>> configSchema) throws IndexException {
        HashMap<String, AttributeProperties> schema = new HashMap<String, AttributeProperties>(configSchema.size());
        for (Map.Entry<String, Class<?>> entry : configSchema.entrySet()) {
            String attrName = entry.getKey();
            LuceneIndexManager.checkAttributeName(attrName);
            Class<?> attrType = entry.getValue();
            ValueType vType = ValueType.valueOf(attrType);
            if (vType == null) {
                throw new IndexException(String.format("Unsupported type %s specified for attribute %s", attrType.getName(), attrName));
            }
            boolean isEnum = vType == ValueType.ENUM;
            schema.put(attrName, new AttributeProperties(isEnum ? attrType.getName() : vType.name(), true, isEnum));
        }
        return schema;
    }

    public SyncSnapshot snapshot(final String id) throws IndexException {
        final Map<String, List<IndexFile>> filesToSync = this.getFilesToSync(id);
        return new SyncSnapshot(){

            @Override
            public void release() {
                for (String name : filesToSync.keySet()) {
                    LuceneIndexManager.this.release(id, name);
                }
            }

            @Override
            public Map<String, List<IndexFile>> getFilesToSync() {
                return filesToSync;
            }
        };
    }

    public InputStream getIndexFile(String cacheName, String indexId, String fileName) throws IOException {
        IndexGroup group = this.getGroup(cacheName);
        if (group == null) {
            throw new AssertionError((Object)("missing index group for " + cacheName));
        }
        return group.getIndexFile(indexId, fileName);
    }

    private void release(String syncId, String name) {
        IndexGroup group = this.getGroup(name);
        if (group != null) {
            group.release(syncId);
        } else {
            this.logger.error("No such index group [" + name + "] exists to release");
        }
    }

    private Map<String, List<IndexFile>> getFilesToSync(String syncId) throws IndexException {
        HashMap<String, List<IndexFile>> filesSyncMap = new HashMap<String, List<IndexFile>>();
        for (Map.Entry entry : this.idxGroups.entrySet()) {
            String cacheName = (String)entry.getKey();
            List idxFiles = ((IndexGroup)entry.getValue()).getSyncFiles(syncId);
            if (idxFiles == null) continue;
            filesSyncMap.put(cacheName, idxFiles);
        }
        return filesSyncMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyIndexSync(String cacheName, String indexId, String fileName, byte[] fileData, boolean isTCFile, boolean isLast) throws IOException {
        if (!this.ramdir && !this.offHeapdir || isTCFile) {
            File indexFile = LuceneIndexManager.resolveIndexFilePath(this.indexDir, cacheName, indexId, fileName);
            indexFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(indexFile, true);
            try {
                fos.write(fileData);
                fos.flush();
            }
            finally {
                fos.close();
            }
        }
        if ((this.ramdir || this.offHeapdir) && !isTCFile) {
            Directory dir = this.getOrCreateTempRamDirectory(cacheName, indexId);
            IndexOutput output = (IndexOutput)this.tempRamOutput.get(dir);
            if (output == null) {
                output = dir.createOutput(fileName, IOContext.DEFAULT);
                this.tempRamOutput.put(dir, output);
            }
            output.writeBytes(fileData, fileData.length);
            if (isLast) {
                output.close();
                this.tempRamOutput.remove(dir);
            }
        }
    }

    private static File resolveIndexFilePath(File indexDir, String cacheName, String indexId, String fileName) throws IOException {
        File cacheIndexDir = new File(indexDir, Util.sanitizeCacheName(cacheName));
        if (indexId != null) {
            cacheIndexDir = new File(cacheIndexDir, indexId);
        }
        Util.ensureDirectory(cacheIndexDir);
        return new File(cacheIndexDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(File destDir, SyncSnapshot snapshot) throws IOException {
        if (this.ramdir || this.offHeapdir) {
            throw new UnsupportedOperationException("Backups not supported for non-persistent index.");
        }
        try {
            for (Map.Entry<String, List<IndexFile>> e : snapshot.getFilesToSync().entrySet()) {
                String cacheName = e.getKey();
                for (IndexFile indexFile : e.getValue()) {
                    File destIndexFile = LuceneIndexManager.resolveIndexFilePath(destDir, cacheName, indexFile.getIndexId(), indexFile.getDestFilename());
                    File sourceIndexFile = LuceneIndexManager.resolveIndexFilePath(this.indexDir, cacheName, indexFile.getIndexId(), indexFile.getLuceneFilename());
                    IOUtils.copy(sourceIndexFile, destIndexFile);
                }
            }
        }
        finally {
            snapshot.release();
        }
    }

    public SearchResult loadResultSet(long clientId, long queryId, String cacheName, int offset, int fetchSize) throws IndexException {
        IndexGroup group = this.getGroup(cacheName);
        if (group != null) {
            return group.loadResults(clientId, queryId, offset, fetchSize);
        }
        throw new IndexException(String.format("Index for cache %s does not exist.", cacheName));
    }

    public void releaseResultSet(long clientId, long queryId, String cacheName) throws IndexException {
        IndexGroup group = this.getGroup(cacheName);
        if (group != null) {
            group.resultsMgr.resultsProcessed(clientId, queryId);
        } else {
            this.logger.info("Result close request ignored: no such index group [" + cacheName + "] exists");
        }
    }

    public void releaseAllResultsFor(long clientId) throws IndexException {
        for (IndexGroup group : this.idxGroups.values()) {
            group.resultsMgr.clearResultsFor(clientId);
        }
    }

    private static String getDirName(String cacheName, String idxId) {
        return cacheName + File.separator + idxId;
    }

    private static void checkAttributeName(String attrName) throws IndexException {
        if (attrName.equals("__TC_KEY_FIELD") || attrName.equals("__TC_VALUE_FIELD") || attrName.equals("__TC_SEGMENT_ID")) {
            throw new IndexException("Illegal attribute name present: " + attrName);
        }
    }

    static String getAttributeTypeString(NVPair nvpair) {
        return nvpair instanceof NVPairEnum ? ((NVPairEnum)nvpair).getClassName() : nvpair.getType().name();
    }

    private synchronized Directory getOrCreateTempRamDirectory(String cacheName, String idxId) throws IOException {
        String indexName = LuceneIndexManager.getDirName(cacheName, idxId);
        Directory memoryDir = (Directory)this.tempDirs.get(indexName);
        if (memoryDir != null) {
            return memoryDir;
        }
        if (this.ramdir) {
            memoryDir = new RAMDirectory();
        } else if (this.offHeapdir) {
            Random random = new Random();
            memoryDir = new OffHeapDirectory(this.offHeapFileSystem, String.valueOf(random.nextInt()));
        } else {
            throw new AssertionError((Object)"Shouldnt get here");
        }
        Directory existing = this.tempDirs.put(indexName, memoryDir);
        if (existing != null) {
            throw new AssertionError((Object)("Directory for " + indexName + " already exists"));
        }
        return memoryDir;
    }

    private static String loadName(File path) throws IndexException {
        FileInputStream in = null;
        try {
            int read;
            in = new FileInputStream(new File(path, TERRACOTTA_CACHE_NAME_FILE));
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[2];
            while ((read = in.read(buf)) != -1) {
                if (read != 2) {
                    throw new IOException("read " + read + " bytes");
                }
                char c = (char)(buf[0] << 8 | buf[1] & 0xFF);
                sb.append(c);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static class AttributeProperties {
        private final String type;
        private final boolean indexed;
        private final boolean isEnum;

        AttributeProperties(String type, boolean indexed, boolean isEnum) {
            this.type = type;
            this.indexed = indexed;
            this.isEnum = isEnum;
        }

        private AttributeProperties(NVPair nvpair, boolean isIndexed) {
            this.isEnum = nvpair instanceof NVPairEnum;
            this.type = LuceneIndexManager.getAttributeTypeString(nvpair);
            this.indexed = isIndexed;
        }

        String getType() {
            return this.type;
        }

        boolean isIndexed() {
            return this.indexed;
        }

        boolean isEnum() {
            return this.isEnum;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.type + ",indexed=" + this.indexed + ")";
        }
    }

    final class IndexGroup
    implements IndexOwner {
        private final ConcurrentMap<Integer, LuceneIndex> indices;
        private final String groupName;
        private final ConcurrentMap<String, AttributeProperties> schema;
        private final Map<String, File> schemaSnapshots;
        private final Timer searcherRefreshTimer;
        private final SearchResultsManager resultsMgr;

        private IndexGroup(String name, boolean load) throws IndexException {
            this.indices = new ConcurrentHashMap<Integer, LuceneIndex>(LuceneIndexManager.this.perCacheIdxCt);
            this.schema = new ConcurrentHashMap<String, AttributeProperties>();
            this.schemaSnapshots = new HashMap<String, File>();
            this.groupName = name;
            this.schema.put("__TC_KEY_FIELD", new AttributeProperties(ValueType.STRING.name(), true, false));
            this.schema.put("__TC_VALUE_FIELD", new AttributeProperties(ValueType.LONG.name(), true, false));
            this.schema.put("__TC_SEGMENT_ID", new AttributeProperties(ValueType.LONG.name(), true, false));
            this.searcherRefreshTimer = new Timer(this.groupName + "-searcherRefreshTask", true);
            try {
                Util.ensureDirectory(this.getPath());
                this.createIndices(load);
                this.resultsMgr = new SearchResultsManager(this.getPath(), this, LuceneIndexManager.this.cfg, LuceneIndexManager.this.queryThreadPool, LuceneIndexManager.this.loggerFactory);
            }
            catch (IOException x) {
                throw new IndexException(x);
            }
        }

        private void close(boolean waitForMerges) throws IndexException {
            this.searcherRefreshTimer.cancel();
            this.resultsMgr.shutdown();
            for (LuceneIndex index : this.indices.values()) {
                index.close(waitForMerges);
            }
        }

        private void close() throws IndexException {
            this.close(false);
        }

        private LuceneIndex getIndex(long segmentId) {
            return (LuceneIndex)this.indices.get(this.getIndexId(segmentId));
        }

        private int getIndexId(long segmentId) {
            return (int)(Math.abs(segmentId) % (long)LuceneIndexManager.this.perCacheIdxCt);
        }

        private InputStream getIndexFile(String indexId, String fileName) throws IOException {
            if (indexId != null) {
                Integer idxId;
                try {
                    idxId = Integer.valueOf(indexId);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(String.format("Illegal index id %s", indexId), e);
                }
                LuceneIndex idx = (LuceneIndex)this.indices.get(idxId);
                if (idx == null) {
                    throw new AssertionError((Object)String.format("Non-existent index id %d specified for group %s", idxId, this.groupName));
                }
                return idx.getIndexFile(fileName);
            }
            return new BufferedInputStream(new FileInputStream(new File(this.getPath(), fileName)));
        }

        private synchronized void release(String syncId) {
            boolean deleted;
            File schemaSnapshot = this.schemaSnapshots.remove(syncId);
            if (schemaSnapshot != null && schemaSnapshot.exists() && !(deleted = schemaSnapshot.delete())) {
                LuceneIndexManager.this.logger.warn("failed to delete temp schema snapshot: " + schemaSnapshot.getAbsolutePath());
            }
            for (LuceneIndex index : this.indices.values()) {
                index.release(syncId);
            }
        }

        private synchronized List<IndexFile> getSyncFiles(String syncId) throws IndexException {
            ArrayList<IndexFile> files = new ArrayList<IndexFile>();
            File schemaFile = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            if (schemaFile.exists()) {
                File snapshot;
                try {
                    snapshot = File.createTempFile("tmp", LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, this.getPath());
                    this.schemaSnapshots.put(syncId, snapshot);
                    Util.copyFile(schemaFile, snapshot);
                }
                catch (IOException e) {
                    throw new IndexException(e);
                }
                files.add(new IndexFileImpl(LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, snapshot.getName(), null, true, snapshot.length()));
            } else {
                LuceneIndexManager.this.logger.info("Schema file doesn't exist: " + schemaFile);
            }
            files.add(new IndexFileImpl(LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE, LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE, null, true, new File(this.getPath(), LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE).length()));
            for (LuceneIndex idx : this.indices.values()) {
                List<IndexFile> idxFiles = idx.getSnapshot(syncId);
                if (idxFiles == null) continue;
                files.addAll(idxFiles);
            }
            return files;
        }

        private void optimize() {
            for (LuceneIndex index : this.indices.values()) {
                try {
                    index.optimize();
                }
                catch (Exception e) {
                    LuceneIndexManager.this.logger.error("Error optimizing index [" + this.groupName + "/" + index.getName() + "]", e);
                }
            }
        }

        private void replaceIfPresent(String key, ValueID value, ValueID previousValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run replaceIfPresent: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.replaceIfPresent(key, value, previousValue, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void removeIfValueEqual(Map<String, ValueID> toRemove, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run removeIfValueEqual: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.removeIfValueEqual(toRemove, context);
        }

        private void remove(String key, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run remove: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.remove(key, context);
        }

        private void clear(long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run clear: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.clear(segmentId, context);
        }

        private void update(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run update: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.update(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void insert(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run insert: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.insert(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void putIfAbsent(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run putIfAbsent: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.putIfAbsent(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private SearchResult loadResults(long requesterId, long queryId, int offset, int fetchSize) throws IndexException {
            return this.resultsMgr.loadResults(requesterId, queryId, offset, fetchSize);
        }

        private SearchResult searchIndex(long requesterId, long queryId, List queryStack, boolean includeKeys, boolean includeValues, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, List<NVPair> aggPairs, int maxResults, int prefetchSize) throws IndexException {
            IndexReader[] readers = new IndexReader[this.indices.size()];
            int i = 0;
            try {
                for (LuceneIndex idx : this.indices.values()) {
                    readers[i++] = idx.getReader();
                }
                SearchResult i$ = this.resultsMgr.executeQuery(requesterId, queryId, queryStack, readers, includeKeys, includeValues, attributeSet, groupByAttributes, sortAttributes, aggPairs, maxResults, prefetchSize);
                return i$;
            }
            catch (IOException iox) {
                throw new IndexException(iox);
            }
            finally {
                for (IndexReader r : readers) {
                    try {
                        if (r == null) continue;
                        r.decRef();
                    }
                    catch (IOException x) {}
                }
            }
        }

        private File getPath() {
            return new File(LuceneIndexManager.this.indexDir, Util.sanitizeCacheName(this.groupName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndices(boolean load) throws IndexException, IOException {
            LuceneIndexManager luceneIndexManager = LuceneIndexManager.this;
            synchronized (luceneIndexManager) {
                if (LuceneIndexManager.this.shutdown) {
                    throw new IndexException("Index manager shutdown");
                }
                if (!this.indices.isEmpty()) {
                    throw new AssertionError((Object)("not empty: " + this.indices));
                }
                File groupPath = this.getPath();
                for (int idxSegment = 0; idxSegment < LuceneIndexManager.this.perCacheIdxCt; ++idxSegment) {
                    LuceneIndex luceneIndex;
                    String idxStr = String.valueOf(idxSegment);
                    File path = new File(groupPath, idxStr);
                    if (!load) {
                        LuceneIndexManager.this.logger.info(String.format("Creating search index [%s/%d]", this.groupName, idxSegment));
                        luceneIndex = new LuceneIndex(LuceneIndexManager.this.createDirectoryFor(path, this.groupName), idxStr, path, this, LuceneIndexManager.this.cfg, LuceneIndexManager.this.loggerFactory);
                    } else {
                        luceneIndex = new LuceneIndex(LuceneIndexManager.this.directoryFor(this.groupName, idxStr, path), idxStr, path, this, LuceneIndexManager.this.cfg, LuceneIndexManager.this.loggerFactory);
                        LuceneIndexManager.this.logger.info(String.format("Opening existing search index [%s/%d]", this.groupName, idxSegment));
                    }
                    this.indices.put(idxSegment, luceneIndex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkSchema(List<NVPair> attributes, boolean indexed) throws IndexException {
            for (NVPair nvpair : attributes) {
                String typeString;
                String type;
                String attrName = nvpair.getName();
                LuceneIndexManager.checkAttributeName(attrName);
                AttributeProperties attrProps = (AttributeProperties)this.schema.get(attrName);
                if (attrProps == null) {
                    IndexGroup indexGroup = this;
                    synchronized (indexGroup) {
                        attrProps = (AttributeProperties)this.schema.get(attrName);
                        if (attrProps == null) {
                            HashMap<String, AttributeProperties> clone = new HashMap<String, AttributeProperties>(this.schema);
                            attrProps = new AttributeProperties(nvpair, indexed);
                            AttributeProperties prev = clone.put(attrName, attrProps);
                            if (prev != null) {
                                throw new AssertionError((Object)("replaced mapping for " + attrName));
                            }
                            LuceneIndexManager.this.logger.info("Updating stored schema");
                            this.storeSchema(clone);
                            prev = this.schema.put(attrName, attrProps);
                            if (prev != null) {
                                throw new AssertionError((Object)("replaced mapping for " + attrName));
                            }
                        }
                    }
                }
                if ((type = attrProps.getType()).equals(typeString = LuceneIndexManager.getAttributeTypeString(nvpair))) continue;
                throw new IndexException("Attribute type (" + typeString + ") does not match schema type (" + type + ")");
            }
        }

        @Override
        public Map<String, AttributeProperties> getSchema() {
            return Collections.unmodifiableMap(this.schema);
        }

        @Override
        public Timer getReaderRefreshTimer() {
            return this.searcherRefreshTimer;
        }

        private void storeSchema(Map<String, AttributeProperties> schemaToStore) throws IndexException {
            boolean deleted;
            File tmp;
            File path = this.getPath();
            try {
                tmp = File.createTempFile("tmp", LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, path);
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            Properties props = new Properties();
            for (Map.Entry<String, AttributeProperties> entry : schemaToStore.entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue().getType() + "," + entry.getValue().isIndexed() + "," + entry.getValue().isEnum());
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(tmp);
                props.store(fout, null);
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            finally {
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException ioe) {
                    LuceneIndexManager.this.logger.warn(ioe);
                }
            }
            File schemaFile = new File(path, LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            if (schemaFile.exists() && !(deleted = schemaFile.delete())) {
                throw new IndexException("Cannot delete old schema file: " + schemaFile.getAbsolutePath());
            }
            boolean moved = tmp.renameTo(schemaFile);
            if (!moved) {
                throw new IndexException("Failed to rename temp file [" + tmp.getAbsolutePath() + "] to [" + schemaFile.getAbsolutePath() + "]");
            }
        }

        private Map<String, AttributeProperties> loadSchema() throws IndexException {
            File schemaFile = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            Properties data = new Properties();
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(schemaFile);
                data.load(fin);
            }
            catch (IOException ioe) {
                throw new IndexException(ioe);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ioe) {
                        LuceneIndexManager.this.logger.warn(ioe);
                    }
                }
            }
            HashMap<String, AttributeProperties> res = new HashMap<String, AttributeProperties>();
            Enumeration<?> i = data.propertyNames();
            while (i.hasMoreElements()) {
                String indexed;
                String key = (String)i.nextElement();
                String value = data.getProperty(key).trim();
                String[] split = value.split(",");
                if (split.length != 3) {
                    throw new IndexException("Unexpected format: " + value);
                }
                String typeName = split[0];
                String isEnum = split[2];
                if (!"false".equals(isEnum) && !"true".equals(isEnum)) {
                    throw new IndexException("Unexpected format for indexed: " + isEnum);
                }
                if (!Boolean.valueOf(isEnum).booleanValue()) {
                    try {
                        Enum.valueOf(ValueType.class, typeName);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IndexException("No such type (" + typeName + ") for key " + key);
                    }
                }
                if (!"false".equals(indexed = split[1]) && !"true".equals(indexed)) {
                    throw new IndexException("Unexpected format for indexed: " + indexed);
                }
                res.put(key, new AttributeProperties(typeName, (boolean)Boolean.valueOf(indexed), Boolean.valueOf(isEnum)));
            }
            return res;
        }

        private void storeName() throws IndexException {
            File file = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                for (char c : this.groupName.toCharArray()) {
                    byte b1 = (byte)(0xFF & c >> 8);
                    byte b2 = (byte)(0xFF & c);
                    out.write(b1);
                    out.write(b2);
                }
                out.flush();
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        LuceneIndexManager.this.logger.error("error closing " + file, ioe);
                    }
                }
            }
        }
    }
}

