/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.DisableCompressionCodec;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexFile;
import com.terracottatech.search.IndexFileImpl;
import com.terracottatech.search.IndexOwner;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.OptimizedCompressionCodec;
import com.terracottatech.search.ProcessingContext;
import com.terracottatech.search.Util;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.terracotta.shaded.lucene.codecs.Codec;
import org.terracotta.shaded.lucene.document.Document;
import org.terracotta.shaded.lucene.document.DoubleField;
import org.terracotta.shaded.lucene.document.Field;
import org.terracotta.shaded.lucene.document.FieldType;
import org.terracotta.shaded.lucene.document.FloatField;
import org.terracotta.shaded.lucene.document.IntField;
import org.terracotta.shaded.lucene.document.LongField;
import org.terracotta.shaded.lucene.document.StoredField;
import org.terracotta.shaded.lucene.document.StringField;
import org.terracotta.shaded.lucene.index.ConcurrentMergeScheduler;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.DirectoryReader;
import org.terracotta.shaded.lucene.index.IndexCommit;
import org.terracotta.shaded.lucene.index.IndexWriter;
import org.terracotta.shaded.lucene.index.IndexWriterConfig;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.terracotta.shaded.lucene.index.ReaderManager;
import org.terracotta.shaded.lucene.index.SnapshotDeletionPolicy;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.BooleanClause;
import org.terracotta.shaded.lucene.search.BooleanQuery;
import org.terracotta.shaded.lucene.search.IndexSearcher;
import org.terracotta.shaded.lucene.search.NumericRangeQuery;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.TermQuery;
import org.terracotta.shaded.lucene.search.TopDocs;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.NamedThreadFactory;
import org.terracotta.shaded.lucene.util.Version;

public class LuceneIndex {
    private static final ExecutorService s_commitThreadPool = Executors.newSingleThreadExecutor(new NamedThreadFactory("index-commit-pool"){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = super.newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static final long READER_REFRESH_RATE = 60000L;
    static final String TERRACOTTA_INIT_FILE = "__terracotta_init.txt";
    static final String SEGMENT_ID_FIELD_NAME = "__TC_SEGMENT_ID";
    public static final String KEY_FIELD_NAME = "__TC_KEY_FIELD";
    static final String VALUE_FIELD_NAME = "__TC_VALUE_FIELD";
    private final Directory luceneDirectory;
    private final SnapshotDeletionPolicy snapshotter;
    private final IndexWriter writer;
    private final ReaderManager readerMgr;
    private final File path;
    private final String name;
    private Future<?> committer;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Logger logger;
    private final boolean useCommitThread;
    private List<ProcessingContext> pending = this.newPendingList();
    private final IndexOwner idxGroup;
    private final AtomicReference<Thread> accessor = new AtomicReference();
    private final boolean doAccessCheck;
    private final ReentrantLock commitLock = new ReentrantLock();

    LuceneIndex(Directory directory, String name, File path, IndexOwner parent, Configuration cfg, LoggerFactory loggerFactory) throws IndexException {
        this.doAccessCheck = cfg.doAccessChecks();
        this.logger = loggerFactory.getLogger(this.getClass().getName() + "-" + path.getName());
        this.snapshotter = new SnapshotDeletionPolicy(new KeepOnlyLastCommitDeletionPolicy());
        this.path = path;
        this.name = name;
        this.luceneDirectory = directory;
        this.useCommitThread = cfg.useCommitThread();
        this.idxGroup = parent;
        try {
            Util.ensureDirectory(path);
            IndexWriterConfig idxWriterCfg = new IndexWriterConfig(Version.LUCENE_41, null);
            idxWriterCfg.setIndexDeletionPolicy(this.snapshotter);
            idxWriterCfg.setRAMBufferSizeMB(cfg.getMaxRamBufferSize());
            idxWriterCfg.setMaxBufferedDocs(cfg.getMaxBufferedDocs());
            ConcurrentMergeScheduler cms = new ConcurrentMergeScheduler();
            cms.setMaxMergeCount(cfg.getMaxMergeCount());
            cms.setMaxThreadCount(cfg.getMaxMergeThreadCount());
            idxWriterCfg.setMergeScheduler(cms);
            if (cfg.disableStoredFieldCompression()) {
                idxWriterCfg.setCodec(new DisableCompressionCodec());
            } else {
                OptimizedCompressionCodec cd = new OptimizedCompressionCodec();
                idxWriterCfg.setCodec(cd);
                this.logger.info("Using stored fields format: " + ((Codec)cd).storedFieldsFormat());
            }
            this.writer = new IndexWriter(this.luceneDirectory, idxWriterCfg);
            this.writer.commit();
            this.readerMgr = new ReaderManager(this.writer, true);
            parent.getReaderRefreshTimer().schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        LuceneIndex.this.readerMgr.maybeRefresh();
                    }
                    catch (IOException e) {
                        LuceneIndex.this.logger.error(e);
                    }
                }
            }, 60000L, 60000L);
            this.logger.info("Directory type: " + this.luceneDirectory.getClass().getName() + " with max buffer size " + idxWriterCfg.getRAMBufferSizeMB() + ", disableDocCompression=" + cfg.disableStoredFieldCompression());
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        try {
            this.createInitFile();
        }
        catch (IOException ioe) {
            try {
                this.writer.close();
            }
            catch (IOException ioe2) {
                this.logger.error(ioe2);
            }
            throw new IndexException(ioe);
        }
    }

    String getName() {
        return this.name;
    }

    InputStream getIndexFile(String fileName) throws IOException {
        File file = new File(this.path, fileName);
        if (file.isFile()) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        return new IndexInputAdapter(this.luceneDirectory.openInput(fileName, IOContext.READ));
    }

    void optimize() throws CorruptIndexException, IOException {
        this.writer.forceMerge(1);
    }

    protected void createInitFile() throws IOException {
        new File(this.path, TERRACOTTA_INIT_FILE).createNewFile();
    }

    static boolean hasInitFile(File path) {
        return new File(path, TERRACOTTA_INIT_FILE).isFile();
    }

    private List<ProcessingContext> newPendingList() {
        return new ArrayList<ProcessingContext>(256);
    }

    List<IndexFile> getSnapshot(String syncId) throws IndexException {
        try {
            this.writer.commit();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Taking snapshot for index: " + this.name);
            }
            ArrayList<IndexFile> files = new ArrayList<IndexFile>();
            files.add(new IndexFileImpl(TERRACOTTA_INIT_FILE, TERRACOTTA_INIT_FILE, this.path.getName(), true, new File(this.path, TERRACOTTA_INIT_FILE).length()));
            IndexCommit ic = this.snapshotter.snapshot(syncId);
            Collection<String> fileNames = ic.getFileNames();
            for (String fileName : fileNames) {
                if (fileName.endsWith(".lock")) continue;
                files.add(new IndexFileImpl(fileName, fileName, this.path.getName(), false, this.luceneDirectory.fileLength(fileName)));
            }
            return files;
        }
        catch (IOException e) {
            this.logger.error(e);
            throw new IndexException("Error getting index snapshot", e);
        }
    }

    void release(String syncId) {
        if (!this.snapshotter.isSnapshotted(syncId)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Releasing snapshot for index");
        }
        try {
            this.snapshotter.release(syncId);
        }
        catch (IOException e) {
            this.logger.warn("Unable to release snapshot with id " + syncId, e);
        }
    }

    private void addPendingContext(ProcessingContext context) {
        if (this.useCommitThread) {
            this.commitLock.lock();
            this.pending.add(context);
            if (this.committer == null) {
                this.committer = s_commitThreadPool.submit(new CommitTask());
            }
            this.commitLock.unlock();
        } else {
            context.processed();
        }
    }

    static Object getFieldValue(Document doc, String attrKey, ValueType type) {
        IndexableField field = doc.getField(attrKey);
        if (field == null) {
            return null;
        }
        Number num = field.numericValue();
        String str = field.stringValue();
        BytesRef bytes = field.binaryValue();
        switch (type) {
            case BOOLEAN: {
                if (num == null) {
                    return null;
                }
                int value = num.intValue();
                if (value == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case BYTE: {
                return num == null ? (Number)num : (Number)num.byteValue();
            }
            case BYTE_ARRAY: {
                return bytes == null ? null : bytes.bytes;
            }
            case CHAR: {
                return num == null ? null : Character.valueOf((char)num.intValue());
            }
            case DATE: {
                return num == null ? null : new Date(num.longValue());
            }
            case SQL_DATE: {
                return num == null ? null : new java.sql.Date(num.longValue());
            }
            case DOUBLE: {
                return num == null ? null : Double.valueOf(num.doubleValue());
            }
            case FLOAT: {
                return num == null ? (Number)num : (Number)Float.valueOf(num.floatValue());
            }
            case INT: {
                return num == null ? (Number)num : (Number)num.intValue();
            }
            case LONG: {
                return num == null ? (Number)num : (Number)num.longValue();
            }
            case SHORT: {
                return num == null ? (Number)num : (Number)num.shortValue();
            }
            case STRING: 
            case ENUM: {
                return str;
            }
            case NULL: {
                throw new AssertionError();
            }
            case VALUE_ID: {
                return num == null ? null : new ValueID(num.longValue());
            }
        }
        throw new AssertionError((Object)type);
    }

    void remove(String key, ProcessingContext context) throws IndexException {
        this.checkAccessor();
        try {
            this.writer.deleteDocuments(new Term(KEY_FIELD_NAME, key));
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
        this.addPendingContext(context);
    }

    void removeIfValueEqual(Map<String, ValueID> toRemove, ProcessingContext context) throws IndexException {
        this.checkAccessor();
        try {
            for (Map.Entry<String, ValueID> e : toRemove.entrySet()) {
                String key = e.getKey();
                ValueID oidValue = e.getValue();
                BooleanQuery query = new BooleanQuery();
                long vId = oidValue.toLong();
                query.add(new BooleanClause(new TermQuery(new Term(KEY_FIELD_NAME, key)), BooleanClause.Occur.MUST));
                query.add(new BooleanClause(NumericRangeQuery.newLongRange(VALUE_FIELD_NAME, vId, vId, true, true), BooleanClause.Occur.MUST));
                this.writer.deleteDocuments((Query)query);
            }
            this.addPendingContext(context);
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
    }

    void clear(long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.writer.deleteDocuments((Query)NumericRangeQuery.newLongRange(SEGMENT_ID_FIELD_NAME, segmentOid, segmentOid, true, true));
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
        this.addPendingContext(context);
    }

    void replaceIfPresent(String key, ValueID value, ValueID oldValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            ValueID existingValue = this.valueForKey(key);
            if (existingValue == null || oldValue != ValueID.NULL_ID && !existingValue.equals(oldValue)) {
                context.processed();
                return;
            }
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, false);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    void putIfAbsent(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            ValueID existingValue = this.valueForKey(key);
            if (existingValue != null) {
                context.processed();
                return;
            }
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, true);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    void update(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, false);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    void insert(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, true);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    private void upsertInternal(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, boolean isInsert) throws IndexException {
        this.checkAccessor();
        this.idxGroup.checkSchema(attributes, true);
        this.idxGroup.checkSchema(storeOnlyAttributes, false);
        Document doc = new Document();
        LuceneIndex.addKeyField(doc, key);
        LuceneIndex.addLongField(doc, VALUE_FIELD_NAME, value.toLong(), true);
        LuceneIndex.addLongField(doc, SEGMENT_ID_FIELD_NAME, segmentOid, true);
        this.addFields(doc, attributes, true);
        this.addFields(doc, storeOnlyAttributes, false);
        try {
            if (isInsert) {
                this.writer.addDocument(doc);
            } else {
                this.writer.updateDocument(new Term(KEY_FIELD_NAME, key), doc);
            }
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    private void checkAccessor() {
        Thread orig;
        Thread current;
        if (this.doAccessCheck && !this.accessor.compareAndSet(null, current = Thread.currentThread()) && (orig = this.accessor.get()) != current) {
            throw new AssertionError((Object)("Index is being accessed by a different thread. Original=[" + orig.getName() + "]"));
        }
    }

    private static void addKeyField(Document doc, String key) {
        doc.add(new StringField(KEY_FIELD_NAME, key, Field.Store.YES));
    }

    private void addFields(Document doc, List<NVPair> attributes, boolean indexed) throws IndexException {
        block17: for (NVPair nvpair : attributes) {
            String attrName = nvpair.getName();
            ValueType type = nvpair.getType();
            switch (type) {
                case BOOLEAN: {
                    AbstractNVPair.BooleanNVPair booleanPair = (AbstractNVPair.BooleanNVPair)nvpair;
                    LuceneIndex.addBooleanField(doc, attrName, booleanPair.getValue(), indexed);
                    continue block17;
                }
                case BYTE: {
                    AbstractNVPair.ByteNVPair bytePair = (AbstractNVPair.ByteNVPair)nvpair;
                    LuceneIndex.addByteField(doc, attrName, bytePair.getValue(), indexed);
                    continue block17;
                }
                case BYTE_ARRAY: {
                    AbstractNVPair.ByteArrayNVPair byteArrayPair = (AbstractNVPair.ByteArrayNVPair)nvpair;
                    LuceneIndex.addByteArrayField(doc, attrName, byteArrayPair.getValue(), indexed);
                    continue block17;
                }
                case CHAR: {
                    AbstractNVPair.CharNVPair charPair = (AbstractNVPair.CharNVPair)nvpair;
                    LuceneIndex.addCharField(doc, attrName, charPair.getValue(), indexed);
                    continue block17;
                }
                case DATE: {
                    AbstractNVPair.DateNVPair datePair = (AbstractNVPair.DateNVPair)nvpair;
                    LuceneIndex.addDateField(doc, attrName, datePair.getValue(), indexed);
                    continue block17;
                }
                case SQL_DATE: {
                    AbstractNVPair.SqlDateNVPair sqlDatePair = (AbstractNVPair.SqlDateNVPair)nvpair;
                    LuceneIndex.addSqlDateField(doc, attrName, sqlDatePair.getValue(), indexed);
                    continue block17;
                }
                case DOUBLE: {
                    AbstractNVPair.DoubleNVPair doubleNVPair = (AbstractNVPair.DoubleNVPair)nvpair;
                    LuceneIndex.addDoubleField(doc, attrName, doubleNVPair.getValue(), indexed);
                    continue block17;
                }
                case ENUM: {
                    AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)nvpair;
                    LuceneIndex.addEnumField(doc, attrName, AbstractNVPair.enumStorageString(enumPair), indexed);
                    continue block17;
                }
                case FLOAT: {
                    AbstractNVPair.FloatNVPair floatNVPair = (AbstractNVPair.FloatNVPair)nvpair;
                    LuceneIndex.addFloatField(doc, attrName, floatNVPair.getValue(), indexed);
                    continue block17;
                }
                case INT: {
                    AbstractNVPair.IntNVPair intNVPair = (AbstractNVPair.IntNVPair)nvpair;
                    LuceneIndex.addIntField(doc, attrName, intNVPair.getValue(), indexed);
                    continue block17;
                }
                case LONG: {
                    AbstractNVPair.LongNVPair longNVPair = (AbstractNVPair.LongNVPair)nvpair;
                    LuceneIndex.addLongField(doc, attrName, longNVPair.getValue(), indexed);
                    continue block17;
                }
                case SHORT: {
                    AbstractNVPair.ShortNVPair shortNVPair = (AbstractNVPair.ShortNVPair)nvpair;
                    LuceneIndex.addShortField(doc, attrName, shortNVPair.getValue(), indexed);
                    continue block17;
                }
                case STRING: {
                    AbstractNVPair.StringNVPair stringNVPair = (AbstractNVPair.StringNVPair)nvpair;
                    LuceneIndex.addStringField(doc, attrName, stringNVPair.getValue(), indexed);
                    continue block17;
                }
                case NULL: {
                    throw new AssertionError();
                }
                case VALUE_ID: {
                    AbstractNVPair.ValueIdNVPair oidNVPair = (AbstractNVPair.ValueIdNVPair)nvpair;
                    LuceneIndex.addLongField(doc, attrName, oidNVPair.getValue().toLong(), indexed);
                    continue block17;
                }
            }
            throw new AssertionError((Object)type.name());
        }
    }

    private static void addStringField(Document doc, String fieldName, String value, boolean indexed) {
        if (indexed) {
            doc.add(LuceneIndex.createField(fieldName, value.toLowerCase(), StringField.TYPE_NOT_STORED));
        }
        doc.add(LuceneIndex.createField(fieldName, value, StoredField.TYPE));
    }

    private static void addShortField(Document doc, String fieldName, short value, boolean indexed) {
        LuceneIndex.addIntField(doc, fieldName, value, indexed);
    }

    private static void addLongField(Document doc, String fieldName, long value, boolean indexed) {
        doc.add(new LongField(fieldName, value, indexed ? LongField.TYPE_STORED : NonIndexedFieldType.LONG));
    }

    private static void addIntField(Document doc, String attrName, int value, boolean indexed) {
        doc.add(new IntField(attrName, value, indexed ? IntField.TYPE_STORED : NonIndexedFieldType.INT));
    }

    private static void addFloatField(Document doc, String attrName, float value, boolean indexed) {
        doc.add(new FloatField(attrName, value, indexed ? FloatField.TYPE_STORED : NonIndexedFieldType.FLOAT));
    }

    private static void addEnumField(Document doc, String attrName, String enumStorageString, boolean indexed) {
        doc.add(LuceneIndex.createField(attrName, enumStorageString, indexed ? StringField.TYPE_STORED : StoredField.TYPE));
    }

    private static void addDoubleField(Document doc, String attrName, double value, boolean indexed) {
        doc.add(new DoubleField(attrName, value, indexed ? DoubleField.TYPE_STORED : NonIndexedFieldType.DOUBLE));
    }

    private static void addSqlDateField(Document doc, String attrName, java.sql.Date value, boolean indexed) {
        LuceneIndex.addLongField(doc, attrName, value.getTime(), indexed);
    }

    private static void addDateField(Document doc, String attrName, Date value, boolean indexed) {
        LuceneIndex.addLongField(doc, attrName, value.getTime(), indexed);
    }

    private static void addCharField(Document doc, String attrName, char value, boolean indexed) {
        LuceneIndex.addIntField(doc, attrName, value, indexed);
    }

    private static void addByteArrayField(Document doc, String attrName, byte[] value, boolean indexed) throws IndexException {
        if (indexed) {
            throw new IndexException("byte array attributes can only be stored (not indexed)");
        }
        doc.add(new Field(attrName, value, StoredField.TYPE));
    }

    private static void addByteField(Document doc, String attrName, byte value, boolean indexed) {
        LuceneIndex.addIntField(doc, attrName, value, indexed);
    }

    private static void addBooleanField(Document doc, String attrName, boolean value, boolean indexed) {
        LuceneIndex.addIntField(doc, attrName, value ? 1 : 0, indexed);
    }

    private ValueID valueForKey(String key) throws IndexException {
        DirectoryReader indexReader = null;
        try {
            indexReader = this.getReader();
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TermQuery query = new TermQuery(new Term(KEY_FIELD_NAME, key));
            TopDocs docs = searcher.search((Query)query, 2);
            if (docs.scoreDocs.length > 1) {
                throw new AssertionError((Object)("more than one result for key: " + key));
            }
            if (docs.scoreDocs.length == 0) {
                ValueID valueID = null;
                return valueID;
            }
            int docId = docs.scoreDocs[0].doc;
            Document doc = indexReader.document(docId, Collections.singleton(VALUE_FIELD_NAME));
            long oid = (Long)LuceneIndex.getFieldValue(doc, VALUE_FIELD_NAME, ValueType.LONG);
            ValueID valueID = new ValueID(oid);
            return valueID;
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        finally {
            try {
                if (this.readerMgr != null) {
                    this.readerMgr.release(indexReader);
                }
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }
    }

    DirectoryReader getReader() throws IOException {
        this.readerMgr.maybeRefreshBlocking();
        return (DirectoryReader)this.readerMgr.acquire();
    }

    private static Field createField(String attrName, String value, FieldType type) {
        return new Field(attrName, value, type);
    }

    void close(boolean waitForMerges) throws IndexException {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.useCommitThread) {
                try {
                    this.commitLock.lock();
                    Future<?> commitResult = this.committer;
                    this.commitLock.unlock();
                    if (commitResult != null) {
                        commitResult.get();
                    }
                }
                catch (InterruptedException e1) {
                    throw new IndexException(e1);
                }
                catch (ExecutionException ex) {
                    throw new IndexException(ex);
                }
            }
            try {
                this.readerMgr.close();
                this.writer.close(waitForMerges);
                this.luceneDirectory.close();
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }
    }

    private static class IndexInputAdapter
    extends InputStream {
        private final IndexInput input;

        private IndexInputAdapter(IndexInput input) {
            this.input = input;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = Math.min(this.available(), len);
            this.input.readBytes(b, off, len, false);
            return read;
        }

        @Override
        public int available() {
            long available = this.input.length() - this.input.getFilePointer();
            if (available >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)available;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public long skip(long n) {
            throw new UnsupportedOperationException();
        }
    }

    private class CommitTask
    implements Callable<Void> {
        private CommitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                block3: while (true) {
                    LuceneIndex.this.commitLock.lock();
                    if (LuceneIndex.this.pending.isEmpty()) {
                        break;
                    }
                    List committed = LuceneIndex.this.pending;
                    LuceneIndex.this.pending = LuceneIndex.this.newPendingList();
                    if (!LuceneIndex.this.shutdown.get()) {
                        LuceneIndex.this.writer.commit();
                    }
                    LuceneIndex.this.commitLock.unlock();
                    Iterator i$ = committed.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block3;
                        ProcessingContext context = (ProcessingContext)i$.next();
                        context.processed();
                    }
                    break;
                }
            }
            finally {
                if (!LuceneIndex.this.commitLock.isHeldByCurrentThread()) {
                    LuceneIndex.this.commitLock.lock();
                }
                LuceneIndex.this.committer = null;
                LuceneIndex.this.commitLock.unlock();
            }
            return null;
        }
    }

    private static final class NonIndexedFieldType
    extends FieldType {
        private static final NonIndexedFieldType INT = new NonIndexedFieldType(FieldType.NumericType.INT);
        private static final NonIndexedFieldType LONG = new NonIndexedFieldType(FieldType.NumericType.LONG);
        private static final NonIndexedFieldType DOUBLE = new NonIndexedFieldType(FieldType.NumericType.DOUBLE);
        private static final NonIndexedFieldType FLOAT = new NonIndexedFieldType(FieldType.NumericType.FLOAT);

        private NonIndexedFieldType(FieldType.NumericType numType) {
            super(IntField.TYPE_STORED);
            this.setIndexed(false);
            this.setNumericType(numType);
            this.freeze();
        }
    }
}

