/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.search.FieldCache;
import org.terracotta.shaded.lucene.search.ScoreCachingWrappingScorer;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.util.Bits;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.packed.PackedInts;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setBottom(int var1);

    public abstract int compareBottom(int var1) throws IOException;

    public abstract void copy(int var1, int var2) throws IOException;

    public abstract FieldComparator<T> setNextReader(AtomicReaderContext var1) throws IOException;

    public void setScorer(Scorer scorer) {
    }

    public abstract T value(int var1);

    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public abstract int compareDocToValue(int var1, T var2) throws IOException;

    protected static final int binarySearch(BytesRef br, FieldCache.DocTermsIndex a, BytesRef key) {
        return FieldComparator.binarySearch(br, a, key, 1, a.numOrd() - 1);
    }

    protected static final int binarySearch(BytesRef br, FieldCache.DocTermsIndex a, BytesRef key, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef midVal = a.lookup(mid, br);
            int cmp = midVal != null ? midVal.compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final class TermValDocValuesComparator
    extends FieldComparator<BytesRef> {
        private BytesRef[] values;
        private DocValues.Source docTerms;
        private final String field;
        private BytesRef bottom;
        private final BytesRef tempBR = new BytesRef();

        TermValDocValuesComparator(int numHits, String field) {
            this.values = new BytesRef[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            assert (this.values[slot1] != null);
            assert (this.values[slot2] != null);
            return this.values[slot1].compareTo(this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottom != null);
            return this.bottom.compareTo(this.docTerms.getBytes(doc, this.tempBR));
        }

        @Override
        public void copy(int slot, int doc) {
            if (this.values[slot] == null) {
                this.values[slot] = new BytesRef();
            }
            this.docTerms.getBytes(doc, this.values[slot]);
        }

        @Override
        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            DocValues dv = context.reader().docValues(this.field);
            this.docTerms = dv != null ? dv.getSource() : DocValues.getDefaultSource(DocValues.Type.BYTES_VAR_DEREF);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            assert (val1 != null);
            assert (val2 != null);
            return val1.compareTo(val2);
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            return this.docTerms.getBytes(doc, this.tempBR).compareTo(value);
        }
    }

    public static final class TermValComparator
    extends FieldComparator<BytesRef> {
        private BytesRef[] values;
        private FieldCache.DocTerms docTerms;
        private final String field;
        private BytesRef bottom;
        private final BytesRef tempBR = new BytesRef();

        TermValComparator(int numHits, String field) {
            this.values = new BytesRef[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) {
            BytesRef val2 = this.docTerms.getTerm(doc, this.tempBR);
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.bottom.compareTo(val2);
        }

        @Override
        public void copy(int slot, int doc) {
            if (this.values[slot] == null) {
                this.values[slot] = new BytesRef();
            }
            this.docTerms.getTerm(doc, this.values[slot]);
        }

        @Override
        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            this.docTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            return this.docTerms.getTerm(doc, this.tempBR).compareTo(value);
        }
    }

    public static final class TermOrdValDocValuesComparator
    extends FieldComparator<BytesRef> {
        final int[] ords;
        final BytesRef[] values;
        final int[] readerGen;
        int currentReaderGen = -1;
        DocValues.SortedSource termsIndex;
        Comparator<BytesRef> comp;
        private final String field;
        int bottomSlot = -1;
        int bottomOrd;
        boolean bottomSameReader;
        BytesRef bottomValue;
        final BytesRef tempBR = new BytesRef();

        public TermOrdValDocValuesComparator(int numHits, String field) {
            this.ords = new int[numHits];
            this.values = new BytesRef[numHits];
            this.readerGen = new int[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.comp.compare(val1, val2);
        }

        @Override
        public int compareBottom(int doc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copy(int slot, int doc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            return this.termsIndex.getBytes(doc, this.tempBR).compareTo(value);
        }

        @Override
        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            int docBase = context.docBase;
            DocValues dv = context.reader().docValues(this.field);
            if (dv == null) {
                this.termsIndex = DocValues.getDefaultSortedSource(DocValues.Type.BYTES_VAR_SORTED, context.reader().maxDoc());
            } else {
                this.termsIndex = dv.getSource().asSortedSource();
                if (this.termsIndex == null) {
                    throw new IllegalStateException("DocValues exist for field \"" + this.field + "\", but not as a sorted source: type=" + (Object)((Object)dv.getSource().getType()) + " reader=" + context.reader());
                }
            }
            this.comp = this.termsIndex.getComparator();
            PerSegmentComparator perSegComp = null;
            if (this.termsIndex.hasPackedDocToOrd()) {
                PackedInts.Reader docToOrd = this.termsIndex.getDocToOrd();
                if (docToOrd.hasArray()) {
                    Object arr = docToOrd.getArray();
                    assert (arr != null);
                    if (arr instanceof byte[]) {
                        perSegComp = new ByteOrdComparator((byte[])arr, this.termsIndex, docBase);
                    } else if (arr instanceof short[]) {
                        perSegComp = new ShortOrdComparator((short[])arr, this.termsIndex, docBase);
                    } else if (arr instanceof int[]) {
                        perSegComp = new IntOrdComparator((int[])arr, this.termsIndex, docBase);
                    }
                }
                if (perSegComp == null) {
                    perSegComp = new AnyPackedDocToOrdComparator(docToOrd, docBase);
                }
            } else if (perSegComp == null) {
                perSegComp = new AnyOrdComparator(docBase);
            }
            ++this.currentReaderGen;
            if (this.bottomSlot != -1) {
                ((FieldComparator)perSegComp).setBottom(this.bottomSlot);
            }
            return perSegComp;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == 0);
                this.bottomOrd = 0;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int index = this.termsIndex.getOrdByValue(this.bottomValue, this.tempBR);
                if (index < 0) {
                    this.bottomOrd = -index - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = index;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        private final class AnyOrdComparator
        extends PerSegmentComparator {
            private final int docBase;

            public AnyOrdComparator(int docBase) {
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                int docOrd = TermOrdValDocValuesComparator.this.termsIndex.ord(doc);
                if (TermOrdValDocValuesComparator.this.bottomSameReader) {
                    return TermOrdValDocValuesComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValDocValuesComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValDocValuesComparator.this.ords[slot] = ord = TermOrdValDocValuesComparator.this.termsIndex.ord(doc);
                if (TermOrdValDocValuesComparator.this.values[slot] == null) {
                    TermOrdValDocValuesComparator.this.values[slot] = new BytesRef();
                }
                TermOrdValDocValuesComparator.this.termsIndex.getByOrd(ord, TermOrdValDocValuesComparator.this.values[slot]);
                TermOrdValDocValuesComparator.this.readerGen[slot] = TermOrdValDocValuesComparator.this.currentReaderGen;
            }
        }

        private final class AnyPackedDocToOrdComparator
        extends PerSegmentComparator {
            private final PackedInts.Reader readerOrds;
            private final int docBase;

            public AnyPackedDocToOrdComparator(PackedInts.Reader readerOrds, int docBase) {
                this.readerOrds = readerOrds;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValDocValuesComparator.this.bottomSlot != -1);
                int docOrd = (int)this.readerOrds.get(doc);
                if (TermOrdValDocValuesComparator.this.bottomSameReader) {
                    return TermOrdValDocValuesComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValDocValuesComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValDocValuesComparator.this.ords[slot] = ord = (int)this.readerOrds.get(doc);
                if (TermOrdValDocValuesComparator.this.values[slot] == null) {
                    TermOrdValDocValuesComparator.this.values[slot] = new BytesRef();
                }
                TermOrdValDocValuesComparator.this.termsIndex.getByOrd(ord, TermOrdValDocValuesComparator.this.values[slot]);
                TermOrdValDocValuesComparator.this.readerGen[slot] = TermOrdValDocValuesComparator.this.currentReaderGen;
            }
        }

        private final class IntOrdComparator
        extends PerSegmentComparator {
            private final int[] readerOrds;
            private final DocValues.SortedSource termsIndex;
            private final int docBase;

            public IntOrdComparator(int[] readerOrds, DocValues.SortedSource termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValDocValuesComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc];
                if (TermOrdValDocValuesComparator.this.bottomSameReader) {
                    return TermOrdValDocValuesComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValDocValuesComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValDocValuesComparator.this.ords[slot] = ord = this.readerOrds[doc];
                if (TermOrdValDocValuesComparator.this.values[slot] == null) {
                    TermOrdValDocValuesComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getByOrd(ord, TermOrdValDocValuesComparator.this.values[slot]);
                TermOrdValDocValuesComparator.this.readerGen[slot] = TermOrdValDocValuesComparator.this.currentReaderGen;
            }
        }

        private final class ShortOrdComparator
        extends PerSegmentComparator {
            private final short[] readerOrds;
            private final DocValues.SortedSource termsIndex;
            private final int docBase;

            public ShortOrdComparator(short[] readerOrds, DocValues.SortedSource termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValDocValuesComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc] & 0xFFFF;
                if (TermOrdValDocValuesComparator.this.bottomSameReader) {
                    return TermOrdValDocValuesComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValDocValuesComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValDocValuesComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFFFF;
                if (TermOrdValDocValuesComparator.this.values[slot] == null) {
                    TermOrdValDocValuesComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getByOrd(ord, TermOrdValDocValuesComparator.this.values[slot]);
                TermOrdValDocValuesComparator.this.readerGen[slot] = TermOrdValDocValuesComparator.this.currentReaderGen;
            }
        }

        private final class ByteOrdComparator
        extends PerSegmentComparator {
            private final byte[] readerOrds;
            private final DocValues.SortedSource termsIndex;
            private final int docBase;

            public ByteOrdComparator(byte[] readerOrds, DocValues.SortedSource termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValDocValuesComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc] & 0xFF;
                if (TermOrdValDocValuesComparator.this.bottomSameReader) {
                    return TermOrdValDocValuesComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValDocValuesComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValDocValuesComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFF;
                if (TermOrdValDocValuesComparator.this.values[slot] == null) {
                    TermOrdValDocValuesComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getByOrd(ord, TermOrdValDocValuesComparator.this.values[slot]);
                TermOrdValDocValuesComparator.this.readerGen[slot] = TermOrdValDocValuesComparator.this.currentReaderGen;
            }
        }

        abstract class PerSegmentComparator
        extends FieldComparator<BytesRef> {
            PerSegmentComparator() {
            }

            @Override
            public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
                return TermOrdValDocValuesComparator.this.setNextReader(context);
            }

            @Override
            public int compare(int slot1, int slot2) {
                return TermOrdValDocValuesComparator.this.compare(slot1, slot2);
            }

            @Override
            public void setBottom(int bottom) {
                TermOrdValDocValuesComparator.this.setBottom(bottom);
            }

            @Override
            public BytesRef value(int slot) {
                return TermOrdValDocValuesComparator.this.value(slot);
            }

            @Override
            public int compareValues(BytesRef val1, BytesRef val2) {
                assert (val1 != null);
                assert (val2 != null);
                return TermOrdValDocValuesComparator.this.comp.compare(val1, val2);
            }

            @Override
            public int compareDocToValue(int doc, BytesRef value) {
                return TermOrdValDocValuesComparator.this.compareDocToValue(doc, value);
            }
        }
    }

    public static final class TermOrdValComparator
    extends FieldComparator<BytesRef> {
        final int[] ords;
        final BytesRef[] values;
        final int[] readerGen;
        int currentReaderGen = -1;
        FieldCache.DocTermsIndex termsIndex;
        private final String field;
        int bottomSlot = -1;
        int bottomOrd;
        boolean bottomSameReader;
        BytesRef bottomValue;
        final BytesRef tempBR = new BytesRef();

        public TermOrdValComparator(int numHits, String field) {
            this.ords = new int[numHits];
            this.values = new BytesRef[numHits];
            this.readerGen = new int[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copy(int slot, int doc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            BytesRef docValue = this.termsIndex.getTerm(doc, this.tempBR);
            if (docValue == null) {
                if (value == null) {
                    return 0;
                }
                return -1;
            }
            if (value == null) {
                return 1;
            }
            return docValue.compareTo(value);
        }

        @Override
        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            int docBase = context.docBase;
            this.termsIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.field);
            PackedInts.Reader docToOrd = this.termsIndex.getDocToOrd();
            PerSegmentComparator perSegComp = null;
            if (docToOrd.hasArray()) {
                Object arr = docToOrd.getArray();
                if (arr instanceof byte[]) {
                    perSegComp = new ByteOrdComparator((byte[])arr, this.termsIndex, docBase);
                } else if (arr instanceof short[]) {
                    perSegComp = new ShortOrdComparator((short[])arr, this.termsIndex, docBase);
                } else if (arr instanceof int[]) {
                    perSegComp = new IntOrdComparator((int[])arr, this.termsIndex, docBase);
                }
            }
            if (perSegComp == null) {
                perSegComp = new AnyOrdComparator(docToOrd, this.termsIndex, docBase);
            }
            ++this.currentReaderGen;
            if (this.bottomSlot != -1) {
                ((FieldComparator)perSegComp).setBottom(this.bottomSlot);
            }
            return perSegComp;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == 0);
                this.bottomOrd = 0;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int index = TermOrdValComparator.binarySearch(this.tempBR, this.termsIndex, this.bottomValue);
                if (index < 0) {
                    this.bottomOrd = -index - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = index;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        private final class AnyOrdComparator
        extends PerSegmentComparator {
            private final PackedInts.Reader readerOrds;
            private final FieldCache.DocTermsIndex termsIndex;
            private final int docBase;

            public AnyOrdComparator(PackedInts.Reader readerOrds, FieldCache.DocTermsIndex termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValComparator.this.bottomSlot != -1);
                int docOrd = (int)this.readerOrds.get(doc);
                if (TermOrdValComparator.this.bottomSameReader) {
                    return TermOrdValComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValComparator.this.ords[slot] = ord = (int)this.readerOrds.get(doc);
                if (ord == 0) {
                    TermOrdValComparator.this.values[slot] = null;
                } else {
                    assert (ord > 0);
                    if (TermOrdValComparator.this.values[slot] == null) {
                        TermOrdValComparator.this.values[slot] = new BytesRef();
                    }
                    this.termsIndex.lookup(ord, TermOrdValComparator.this.values[slot]);
                }
                TermOrdValComparator.this.readerGen[slot] = TermOrdValComparator.this.currentReaderGen;
            }
        }

        private final class IntOrdComparator
        extends PerSegmentComparator {
            private final int[] readerOrds;
            private final FieldCache.DocTermsIndex termsIndex;
            private final int docBase;

            public IntOrdComparator(int[] readerOrds, FieldCache.DocTermsIndex termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc];
                if (TermOrdValComparator.this.bottomSameReader) {
                    return TermOrdValComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc];
                if (ord == 0) {
                    TermOrdValComparator.this.values[slot] = null;
                } else {
                    assert (ord > 0);
                    if (TermOrdValComparator.this.values[slot] == null) {
                        TermOrdValComparator.this.values[slot] = new BytesRef();
                    }
                    this.termsIndex.lookup(ord, TermOrdValComparator.this.values[slot]);
                }
                TermOrdValComparator.this.readerGen[slot] = TermOrdValComparator.this.currentReaderGen;
            }
        }

        private final class ShortOrdComparator
        extends PerSegmentComparator {
            private final short[] readerOrds;
            private final FieldCache.DocTermsIndex termsIndex;
            private final int docBase;

            public ShortOrdComparator(short[] readerOrds, FieldCache.DocTermsIndex termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc] & 0xFFFF;
                if (TermOrdValComparator.this.bottomSameReader) {
                    return TermOrdValComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFFFF;
                if (ord == 0) {
                    TermOrdValComparator.this.values[slot] = null;
                } else {
                    assert (ord > 0);
                    if (TermOrdValComparator.this.values[slot] == null) {
                        TermOrdValComparator.this.values[slot] = new BytesRef();
                    }
                    this.termsIndex.lookup(ord, TermOrdValComparator.this.values[slot]);
                }
                TermOrdValComparator.this.readerGen[slot] = TermOrdValComparator.this.currentReaderGen;
            }
        }

        private final class ByteOrdComparator
        extends PerSegmentComparator {
            private final byte[] readerOrds;
            private final FieldCache.DocTermsIndex termsIndex;
            private final int docBase;

            public ByteOrdComparator(byte[] readerOrds, FieldCache.DocTermsIndex termsIndex, int docBase) {
                this.readerOrds = readerOrds;
                this.termsIndex = termsIndex;
                this.docBase = docBase;
            }

            @Override
            public int compareBottom(int doc) {
                assert (TermOrdValComparator.this.bottomSlot != -1);
                int docOrd = this.readerOrds[doc] & 0xFF;
                if (TermOrdValComparator.this.bottomSameReader) {
                    return TermOrdValComparator.this.bottomOrd - docOrd;
                }
                if (TermOrdValComparator.this.bottomOrd >= docOrd) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void copy(int slot, int doc) {
                int ord;
                TermOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFF;
                if (ord == 0) {
                    TermOrdValComparator.this.values[slot] = null;
                } else {
                    assert (ord > 0);
                    if (TermOrdValComparator.this.values[slot] == null) {
                        TermOrdValComparator.this.values[slot] = new BytesRef();
                    }
                    this.termsIndex.lookup(ord, TermOrdValComparator.this.values[slot]);
                }
                TermOrdValComparator.this.readerGen[slot] = TermOrdValComparator.this.currentReaderGen;
            }
        }

        abstract class PerSegmentComparator
        extends FieldComparator<BytesRef> {
            PerSegmentComparator() {
            }

            @Override
            public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
                return TermOrdValComparator.this.setNextReader(context);
            }

            @Override
            public int compare(int slot1, int slot2) {
                return TermOrdValComparator.this.compare(slot1, slot2);
            }

            @Override
            public void setBottom(int bottom) {
                TermOrdValComparator.this.setBottom(bottom);
            }

            @Override
            public BytesRef value(int slot) {
                return TermOrdValComparator.this.value(slot);
            }

            @Override
            public int compareValues(BytesRef val1, BytesRef val2) {
                if (val1 == null) {
                    if (val2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (val2 == null) {
                    return 1;
                }
                return val1.compareTo(val2);
            }

            @Override
            public int compareDocToValue(int doc, BytesRef value) {
                return TermOrdValComparator.this.compareDocToValue(doc, value);
            }
        }
    }

    public static final class DocComparator
    extends FieldComparator<Integer> {
        private final int[] docIDs;
        private int docBase;
        private int bottom;

        DocComparator(int numHits) {
            this.docIDs = new int[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.docIDs[slot1] - this.docIDs[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            return this.bottom - (this.docBase + doc);
        }

        @Override
        public void copy(int slot, int doc) {
            this.docIDs[slot] = this.docBase + doc;
        }

        @Override
        public FieldComparator<Integer> setNextReader(AtomicReaderContext context) {
            this.docBase = context.docBase;
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.docIDs[bottom];
        }

        @Override
        public Integer value(int slot) {
            return this.docIDs[slot];
        }

        @Override
        public int compareDocToValue(int doc, Integer valueObj) {
            int docValue = this.docBase + doc;
            int value = valueObj;
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float> {
        private final float[] scores;
        private float bottom;
        private Scorer scorer;

        RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            float score1 = this.scores[slot1];
            float score2 = this.scores[slot2];
            return score1 > score2 ? -1 : (score1 < score2 ? 1 : 0);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            return this.bottom > score ? -1 : (this.bottom < score ? 1 : 0);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.scores[slot] = this.scorer.score();
            assert (!Float.isNaN(this.scores[slot]));
        }

        @Override
        public FieldComparator<Float> setNextReader(AtomicReaderContext context) {
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = !(scorer instanceof ScoreCachingWrappingScorer) ? new ScoreCachingWrappingScorer(scorer) : scorer;
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.scores[slot]);
        }

        @Override
        public int compareValues(Float first, Float second) {
            return second.compareTo(first);
        }

        @Override
        public int compareDocToValue(int doc, Float valueObj) throws IOException {
            float value = valueObj.floatValue();
            float docValue = this.scorer.score();
            assert (!Float.isNaN(docValue));
            if (docValue < value) {
                return 1;
            }
            if (docValue > value) {
                return -1;
            }
            return 0;
        }
    }

    public static final class LongComparator
    extends NumericComparator<Long> {
        private final long[] values;
        private final FieldCache.LongParser parser;
        private long[] currentReaderValues;
        private long bottom;

        LongComparator(int numHits, String field, FieldCache.Parser parser, Long missingValue) {
            super(field, missingValue);
            this.values = new long[numHits];
            this.parser = (FieldCache.LongParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            long v1 = this.values[slot1];
            long v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            long v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0L && !this.docsWithField.get(doc)) {
                v2 = (Long)this.missingValue;
            }
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            long v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0L && !this.docsWithField.get(doc)) {
                v2 = (Long)this.missingValue;
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Long> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getLongs(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Long value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Long valueObj) {
            long value = valueObj;
            long docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0L && !this.docsWithField.get(doc)) {
                docValue = (Long)this.missingValue;
            }
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class IntDocValuesComparator
    extends FieldComparator<Long> {
        private final long[] values;
        private DocValues.Source currentReaderValues;
        private final String field;
        private long bottom;

        IntDocValuesComparator(int numHits, String field) {
            this.values = new long[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            long v1 = this.values[slot1];
            long v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            long v2 = this.currentReaderValues.getInt(doc);
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues.getInt(doc);
        }

        @Override
        public FieldComparator<Long> setNextReader(AtomicReaderContext context) throws IOException {
            DocValues docValues = context.reader().docValues(this.field);
            this.currentReaderValues = docValues != null ? docValues.getSource() : DocValues.getDefaultSource(DocValues.Type.FIXED_INTS_64);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Long value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Long valueObj) {
            long value = valueObj;
            long docValue = this.currentReaderValues.getInt(doc);
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class IntComparator
    extends NumericComparator<Integer> {
        private final int[] values;
        private final FieldCache.IntParser parser;
        private int[] currentReaderValues;
        private int bottom;

        IntComparator(int numHits, String field, FieldCache.Parser parser, Integer missingValue) {
            super(field, missingValue);
            this.values = new int[numHits];
            this.parser = (FieldCache.IntParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            int v1 = this.values[slot1];
            int v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            int v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Integer)this.missingValue;
            }
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            int v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Integer)this.missingValue;
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Integer> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getInts(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Integer value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Integer valueObj) {
            int value = valueObj;
            int docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0 && !this.docsWithField.get(doc)) {
                docValue = (Integer)this.missingValue;
            }
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class ShortComparator
    extends NumericComparator<Short> {
        private final short[] values;
        private final FieldCache.ShortParser parser;
        private short[] currentReaderValues;
        private short bottom;

        ShortComparator(int numHits, String field, FieldCache.Parser parser, Short missingValue) {
            super(field, missingValue);
            this.values = new short[numHits];
            this.parser = (FieldCache.ShortParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.values[slot1] - this.values[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            short v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Short)this.missingValue;
            }
            return this.bottom - v2;
        }

        @Override
        public void copy(int slot, int doc) {
            short v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Short)this.missingValue;
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Short> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getShorts(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Short value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Short valueObj) {
            short value = valueObj;
            short docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0 && !this.docsWithField.get(doc)) {
                docValue = (Short)this.missingValue;
            }
            return docValue - value;
        }
    }

    public static final class FloatComparator
    extends NumericComparator<Float> {
        private final float[] values;
        private final FieldCache.FloatParser parser;
        private float[] currentReaderValues;
        private float bottom;

        FloatComparator(int numHits, String field, FieldCache.Parser parser, Float missingValue) {
            super(field, missingValue);
            this.values = new float[numHits];
            this.parser = (FieldCache.FloatParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            float v1 = this.values[slot1];
            float v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            float v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0.0f && !this.docsWithField.get(doc)) {
                v2 = ((Float)this.missingValue).floatValue();
            }
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            float v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0.0f && !this.docsWithField.get(doc)) {
                v2 = ((Float)this.missingValue).floatValue();
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Float> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getFloats(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.values[slot]);
        }

        @Override
        public int compareDocToValue(int doc, Float valueObj) {
            float value = valueObj.floatValue();
            float docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0.0f && !this.docsWithField.get(doc)) {
                docValue = ((Float)this.missingValue).floatValue();
            }
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class FloatDocValuesComparator
    extends FieldComparator<Double> {
        private final double[] values;
        private final String field;
        private DocValues.Source currentReaderValues;
        private double bottom;

        FloatDocValuesComparator(int numHits, String field) {
            this.values = new double[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            double v1 = this.values[slot1];
            double v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            double v2 = this.currentReaderValues.getFloat(doc);
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues.getFloat(doc);
        }

        @Override
        public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
            DocValues docValues = context.reader().docValues(this.field);
            this.currentReaderValues = docValues != null ? docValues.getSource() : DocValues.getDefaultSource(DocValues.Type.FLOAT_64);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Double valueObj) {
            double value = valueObj;
            double docValue = this.currentReaderValues.getFloat(doc);
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class DoubleComparator
    extends NumericComparator<Double> {
        private final double[] values;
        private final FieldCache.DoubleParser parser;
        private double[] currentReaderValues;
        private double bottom;

        DoubleComparator(int numHits, String field, FieldCache.Parser parser, Double missingValue) {
            super(field, missingValue);
            this.values = new double[numHits];
            this.parser = (FieldCache.DoubleParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            double v1 = this.values[slot1];
            double v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            double v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0.0 && !this.docsWithField.get(doc)) {
                v2 = (Double)this.missingValue;
            }
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            double v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0.0 && !this.docsWithField.get(doc)) {
                v2 = (Double)this.missingValue;
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getDoubles(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Double valueObj) {
            double value = valueObj;
            double docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0.0 && !this.docsWithField.get(doc)) {
                docValue = (Double)this.missingValue;
            }
            if (docValue < value) {
                return -1;
            }
            if (docValue > value) {
                return 1;
            }
            return 0;
        }
    }

    public static final class ByteComparator
    extends NumericComparator<Byte> {
        private final byte[] values;
        private final FieldCache.ByteParser parser;
        private byte[] currentReaderValues;
        private byte bottom;

        ByteComparator(int numHits, String field, FieldCache.Parser parser, Byte missingValue) {
            super(field, missingValue);
            this.values = new byte[numHits];
            this.parser = (FieldCache.ByteParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.values[slot1] - this.values[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            byte v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Byte)this.missingValue;
            }
            return this.bottom - v2;
        }

        @Override
        public void copy(int slot, int doc) {
            byte v2 = this.currentReaderValues[doc];
            if (this.docsWithField != null && v2 == 0 && !this.docsWithField.get(doc)) {
                v2 = (Byte)this.missingValue;
            }
            this.values[slot] = v2;
        }

        @Override
        public FieldComparator<Byte> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getBytes(context.reader(), this.field, this.parser, this.missingValue != null);
            return super.setNextReader(context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Byte value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, Byte value) {
            byte docValue = this.currentReaderValues[doc];
            if (this.docsWithField != null && docValue == 0 && !this.docsWithField.get(doc)) {
                docValue = (Byte)this.missingValue;
            }
            return docValue - value;
        }
    }

    public static abstract class NumericComparator<T extends Number>
    extends FieldComparator<T> {
        protected final T missingValue;
        protected final String field;
        protected Bits docsWithField;

        public NumericComparator(String field, T missingValue) {
            this.field = field;
            this.missingValue = missingValue;
        }

        @Override
        public FieldComparator<T> setNextReader(AtomicReaderContext context) throws IOException {
            if (this.missingValue != null) {
                this.docsWithField = FieldCache.DEFAULT.getDocsWithField(context.reader(), this.field);
                if (this.docsWithField instanceof Bits.MatchAllBits) {
                    this.docsWithField = null;
                }
            } else {
                this.docsWithField = null;
            }
            return this;
        }
    }
}

