/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.store.StoreQuery;
import org.terracotta.modules.ehcache.search.ClusteredGroupedResult;
import org.terracotta.modules.ehcache.search.ClusteredResultImpl;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.toolkit.search.SearchResult;

public class ClusteredResultsList
implements List<Result> {
    private final List<SearchResult> srcResults;
    private final StoreQuery query;
    private final ValueModeHandler valueHandler;

    public ClusteredResultsList(List<SearchResult> srcRes, StoreQuery query, ValueModeHandler valueHandler) {
        this.srcResults = srcRes;
        this.query = query;
        this.valueHandler = valueHandler;
    }

    @Override
    public Iterator<Result> iterator() {
        return new Itr(this, this.srcResults.iterator());
    }

    @Override
    public ListIterator<Result> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Result> listIterator(int index) {
        return new ListItr(this, this.srcResults.listIterator(index));
    }

    @Override
    public List<Result> subList(int fromIndex, int toIndex) {
        return new SubList(this, this.srcResults.subList(fromIndex, toIndex));
    }

    @Override
    public synchronized int size() {
        return this.srcResults.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.srcResults.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.indexOf(o) > -1;
    }

    @Override
    public synchronized Object[] toArray() {
        return ClusteredResultsList.createTempList(this.srcResults, this.query, this.valueHandler).toArray();
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        return ClusteredResultsList.createTempList(this.srcResults, this.query, this.valueHandler).toArray(dest);
    }

    @Override
    public synchronized Result get(int index) {
        return this.listIterator(index).next();
    }

    @Override
    public synchronized int indexOf(Object o) {
        return ClusteredResultsList.createTempList(this.srcResults, this.query, this.valueHandler).indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return ClusteredResultsList.createTempList(this.srcResults, this.query, this.valueHandler).lastIndexOf(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return ClusteredResultsList.createTempList(this.srcResults, this.query, this.valueHandler).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Result> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Result> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Result set(int index, Result element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Result element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Result remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Result o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    private static boolean isGroupBy(StoreQuery q) {
        return !q.groupByAttributes().isEmpty();
    }

    private static Result getResult(StoreQuery q, SearchResult sr, ValueModeHandler vmh) {
        return ClusteredResultsList.isGroupBy(q) ? new ClusteredGroupedResult(q, sr.getAttributes(), sr.getSortAttributes(), sr.getAggregatorResults(), sr.getGroupByValues()) : new ClusteredResultImpl(vmh, sr, q);
    }

    private static List<Result> createTempList(List<SearchResult> srcList, StoreQuery q, ValueModeHandler vmh) {
        ArrayList<Result> res = new ArrayList<Result>(srcList.size());
        for (SearchResult sr : srcList) {
            res.add(ClusteredResultsList.getResult(q, sr, vmh));
        }
        return res;
    }

    private static class SubList
    implements List<Result> {
        private final List<SearchResult> srcSubList;
        private final ClusteredResultsList parent;

        public SubList(ClusteredResultsList parent, List<SearchResult> subList) {
            this.parent = parent;
            this.srcSubList = subList;
        }

        @Override
        public Iterator<Result> iterator() {
            return new Itr(this.parent, this.srcSubList.iterator());
        }

        @Override
        public ListIterator<Result> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<Result> listIterator(int index) {
            return new ListItr(this.parent, this.srcSubList.listIterator(index));
        }

        @Override
        public List<Result> subList(int fromIndex, int toIndex) {
            return new SubList(this.parent, this.srcSubList.subList(fromIndex, toIndex));
        }

        @Override
        public int size() {
            return this.srcSubList.size();
        }

        @Override
        public boolean isEmpty() {
            return this.srcSubList.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).contains(o);
        }

        @Override
        public Object[] toArray() {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).containsAll(c);
        }

        @Override
        public Result get(int index) {
            SearchResult sr = this.srcSubList.get(index);
            return ClusteredResultsList.getResult(this.parent.query, sr, this.parent.valueHandler);
        }

        @Override
        public int indexOf(Object o) {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ClusteredResultsList.createTempList(this.srcSubList, this.parent.query, this.parent.valueHandler).lastIndexOf(o);
        }

        @Override
        public boolean add(Result o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Result> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Result> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result set(int index, Result element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Result element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result remove(int index) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ListItr
    implements ListIterator<Result> {
        private final ListIterator<SearchResult> listIterator;
        private final ClusteredResultsList parent;

        ListItr(ClusteredResultsList parent, ListIterator<SearchResult> listIterator) {
            this.parent = parent;
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Result next() {
            return ClusteredResultsList.getResult(this.parent.query, this.listIterator.next(), this.parent.valueHandler);
        }

        @Override
        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public Result previous() {
            return ClusteredResultsList.getResult(this.parent.query, this.listIterator.previous(), this.parent.valueHandler);
        }

        @Override
        public int nextIndex() {
            return this.listIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.listIterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Result o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Result o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Itr
    implements Iterator<Result> {
        private final Iterator<SearchResult> iterator;
        private final ClusteredResultsList parent;

        Itr(ClusteredResultsList parent, Iterator<SearchResult> iterator) {
            this.iterator = iterator;
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Result next() {
            return ClusteredResultsList.getResult(this.parent.query, this.iterator.next(), this.parent.valueHandler);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

