/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta.security;

import java.util.concurrent.atomic.AtomicReference;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.terracotta.toolkit.SecretProvider;

public class SingletonSecretProviderWrapper
implements SecretProvider {
    private static final AtomicReference<SecretProvider> delegate = new AtomicReference();

    public static void useAsDelegate(String secretProviderClassname) {
        try {
            delegate.set((SecretProvider)ClassLoaderUtil.loadClass(secretProviderClassname).newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("SecretProvider initialization problem: Check the value of property \"%s\" (currently set to \"%s\"), the class it matches or your classpath", "com.terracotta.express.SecretProvider", secretProviderClassname), e);
        }
        delegate.get().fetchSecret();
    }

    public void fetchSecret() {
    }

    public byte[] getSecret() {
        return delegate.get().getSecret();
    }
}

