/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.nio.NIOConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NIOBackupTool {
    private static final int MAX_LOCK_RETRIES = 100;

    public static void backup(File sourceFrsFolder, File destFrsFolder) throws IOException {
        if (!sourceFrsFolder.isDirectory()) {
            throw new IOException(sourceFrsFolder + " is not a directory.");
        }
        if (!destFrsFolder.mkdirs()) {
            throw new IOException("Failed to create the destination directory " + destFrsFolder);
        }
        FileLock lock = NIOBackupTool.lockFrsFolder(sourceFrsFolder);
        NIOBackupTool.copyConfiguration(sourceFrsFolder, destFrsFolder);
        NIOBackupTool.copyDataFiles(sourceFrsFolder, destFrsFolder);
        File destBackupLockFile = new File(destFrsFolder, "frs.backup.lck");
        if (!destBackupLockFile.createNewFile()) {
            System.err.println("Unabled to create backup lockfile.");
        }
        lock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyDataFiles(File sourceFrsFolder, File destFrsFolder) throws IOException {
        String string = NIOBackupTool.copyLockString(sourceFrsFolder);
        synchronized (string) {
            for (String file : NIOBackupTool.listSortedFiles(sourceFrsFolder)) {
                File sourceFile = new File(sourceFrsFolder, file);
                File destFile = new File(destFrsFolder, file);
                NIOBackupTool.copyFile(sourceFile, destFile);
            }
        }
    }

    private static FileLock lockFrsFolder(File frsFolder) throws IOException {
        File frsBackupLock = new File(frsFolder, "frs.backup.lck");
        if (!frsBackupLock.exists() || !frsBackupLock.isFile()) {
            throw new IOException("Missing backup lockfile.");
        }
        FileInputStream fis = new FileInputStream(frsBackupLock);
        FileChannel channel = fis.getChannel();
        for (int i = 0; i < 100; ++i) {
            FileLock lock;
            try {
                lock = channel.lock(0L, Long.MAX_VALUE, true);
            }
            catch (OverlappingFileLockException e) {
                lock = null;
            }
            if (lock != null) {
                return lock;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IOException("Failed to lock data folder " + frsFolder);
    }

    private static List<String> listSortedFiles(File frsFolder) {
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(frsFolder.list(NIOConstants.SEGMENT_FILENAME_FILTER)));
        Collections.sort(files, NIOConstants.SEGMENT_NAME_COMPARATOR);
        return files;
    }

    private static void copyConfiguration(File sourceFrsFolder, File destFrsFolder) throws IOException {
        File sourceConfiguration = new File(sourceFrsFolder, "frs.properties");
        if (sourceConfiguration.exists() && sourceConfiguration.isFile()) {
            NIOBackupTool.copyFile(sourceConfiguration, new File(destFrsFolder, "frs.properties"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new IOException("Source " + sourceFile + " exists=" + sourceFile.exists() + " isFile=" + sourceFile.isFile());
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        FileInputStream fis = new FileInputStream(sourceFile);
        FileChannel output = fos.getChannel();
        FileChannel input = fis.getChannel();
        try {
            long size = input.size();
            for (long position = 0L; position < size; position += output.transferFrom(input, position, size)) {
            }
        }
        finally {
            fos.close();
            fis.close();
        }
    }

    private static String copyLockString(File sourceFrsFolder) throws IOException {
        return new File(sourceFrsFolder, "frs.backup.lck").getCanonicalPath().intern();
    }
}

