/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.nio.ByteBuffer;

public class AllocatingBufferSource
implements BufferSource {
    private ByteBuffer soleSource;

    @Override
    public ByteBuffer getBuffer(int size) {
        if (this.soleSource == null) {
            this.soleSource = ByteBuffer.allocateDirect(size);
            return this.soleSource;
        }
        if (this.soleSource.limit() != 0) {
            throw new AssertionError((Object)"source in use");
        }
        if (this.soleSource.capacity() < size) {
            this.soleSource = ByteBuffer.allocateDirect(size);
        }
        return (ByteBuffer)this.soleSource.clear().limit(size);
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        assert (buffer == this.soleSource);
        buffer.limit(0);
    }

    @Override
    public void reclaim() {
        if (this.soleSource != null) {
            this.soleSource.limit(0);
        }
    }
}

