/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.configuration;

import com.terracottatech.offheapstore.util.DebuggingUtils;
import net.sf.ehcache.store.offheap.configuration.OffHeapConfiguration;

public class ExplicitConfiguration
implements OffHeapConfiguration {
    private final long maximumSize;
    private final int minimumChunkSize;
    private final int maximumChunkSize;
    private final int concurrency;
    private final int initialSegmentTableSize;
    private final int segmentDataPageSize;

    public ExplicitConfiguration(long maximumSize, int minimumChunkSize, int maximumChunkSize, int concurrency, int initialSegmentTableSize, int segmentDataPageSize) {
        this.maximumSize = maximumSize;
        this.minimumChunkSize = minimumChunkSize;
        this.maximumChunkSize = maximumChunkSize;
        this.concurrency = concurrency;
        this.initialSegmentTableSize = initialSegmentTableSize;
        this.segmentDataPageSize = segmentDataPageSize;
    }

    public ExplicitConfiguration(int maximumSize, int concurrency, int initialSegmentTableSize, int segmentDataPageSize) {
        this(maximumSize, maximumSize, maximumSize, concurrency, initialSegmentTableSize, segmentDataPageSize);
    }

    @Override
    public long getMaximumSize() {
        return this.maximumSize;
    }

    @Override
    public int getMinimumChunkSize() {
        return this.minimumChunkSize;
    }

    @Override
    public int getMaximumChunkSize() {
        return this.maximumChunkSize;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getInitialSegmentTableSize() {
        return this.initialSegmentTableSize;
    }

    @Override
    public int getSegmentDataPageSize() {
        return this.segmentDataPageSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Explicit Configuration:\n");
        sb.append("Maximum Size (specified)   : ").append(DebuggingUtils.toBase2SuffixedString(this.getMaximumSize())).append("B\n");
        sb.append("Minimum Chunk Size         : ").append(DebuggingUtils.toBase2SuffixedString(this.getMinimumChunkSize())).append("B\n");
        sb.append("Maximum Chunk Size         : ").append(DebuggingUtils.toBase2SuffixedString(this.getMaximumChunkSize())).append("B\n");
        sb.append("Concurrency                : ").append(this.getConcurrency()).append("\n");
        sb.append("Initial Segment Table Size : ").append(DebuggingUtils.toBase2SuffixedString(this.getInitialSegmentTableSize())).append(" slots\n");
        sb.append("Segment Data Page Size     : ").append(DebuggingUtils.toBase2SuffixedString(this.getSegmentDataPageSize())).append("B\n");
        return sb.toString();
    }
}

