/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.DoubleSum;
import com.terracottatech.search.aggregator.EmptySum;
import com.terracottatech.search.aggregator.FloatSum;
import com.terracottatech.search.aggregator.LongSum;

public abstract class Sum
extends AbstractAggregator {
    public Sum(String attributeName, ValueType type) {
        super(AggregatorOperations.SUM, attributeName, type);
    }

    public static Sum sum(String attributeName, ValueType type) throws IllegalArgumentException {
        if (type == null) {
            return new EmptySum(attributeName);
        }
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongSum(attributeName, type);
            }
            case FLOAT: {
                return new FloatSum(attributeName, type);
            }
            case DOUBLE: {
                return new DoubleSum(attributeName, type);
            }
        }
        throw new IllegalArgumentException("Attribute [" + attributeName + ":" + (Object)((Object)type) + "] is not a numeric type");
    }
}

