/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SysOutLoggerFactory
implements LoggerFactory {
    private final boolean debugOn;

    public SysOutLoggerFactory() {
        this(false);
    }

    public SysOutLoggerFactory(boolean debugOn) {
        this.debugOn = debugOn;
    }

    @Override
    public Logger getLogger(String name) {
        return new SysOutLogger(name);
    }

    @Override
    public Logger getLogger(Class c) {
        return this.getLogger(c.getName());
    }

    private class SysOutLogger
    implements Logger {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        private final String name;

        public SysOutLogger(String name) {
            this.name = name;
        }

        @Override
        public void debug(Object message) {
            if (message instanceof Throwable) {
                this.debug(null, (Throwable)message);
            } else {
                this.debug(message, null);
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.log("DEBUG", message, t);
            }
        }

        @Override
        public void error(Object message) {
            if (message instanceof Throwable) {
                this.error(null, (Throwable)message);
            } else {
                this.error(message, null);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            this.log("ERROR", message, t);
        }

        @Override
        public void fatal(Object message) {
            if (message instanceof Throwable) {
                this.fatal(null, (Throwable)message);
            } else {
                this.fatal(message, null);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.log("FATAL", message, t);
        }

        @Override
        public void info(Object message) {
            if (message instanceof Throwable) {
                this.info(null, (Throwable)message);
            } else {
                this.info(message, null);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            this.log("INFO", message, t);
        }

        @Override
        public void warn(Object message) {
            if (message instanceof Throwable) {
                this.warn(null, (Throwable)message);
            } else {
                this.warn(message, null);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.log("WARN", message, t);
        }

        private synchronized void log(String level, Object message, Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print(this.dateFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] " + level + " " + this.name + " - " + (message == null ? "" : message));
            if (t != null) {
                pw.println();
                t.printStackTrace(pw);
            }
            pw.close();
            System.out.println(sw.toString());
        }

        @Override
        public boolean isDebugEnabled() {
            return SysOutLoggerFactory.this.debugOn;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

