/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuedThreadPool
extends AbstractLifeCycle
implements ThreadPool.SizedThreadPool,
Executor,
Dumpable {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private final AtomicInteger _threadsStarted = new AtomicInteger();
    private final AtomicInteger _threadsIdle = new AtomicInteger();
    private final AtomicLong _lastShrink = new AtomicLong();
    private final ConcurrentLinkedQueue<Thread> _threads = new ConcurrentLinkedQueue();
    private final Object _joinLock = new Object();
    private BlockingQueue<Runnable> _jobs;
    private String _name;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 254;
    private int _minThreads = 8;
    private int _maxQueued = -1;
    private int _priority = 5;
    private boolean _daemon = false;
    private int _maxStopTime = 100;
    private boolean _detailedDump = false;
    private Runnable _runnable = new /* Unavailable Anonymous Inner Class!! */;

    public QueuedThreadPool() {
        this._name = "qtp" + super.hashCode();
    }

    public QueuedThreadPool(int maxThreads) {
        this();
        this.setMaxThreads(maxThreads);
    }

    public QueuedThreadPool(BlockingQueue<Runnable> jobQ) {
        this();
        this._jobs = jobQ;
        this._jobs.clear();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._threadsStarted.set(0);
        if (this._jobs == null) {
            this._jobs = this._maxQueued > 0 ? new ArrayBlockingQueue(this._maxQueued) : new BlockingArrayQueue(this._minThreads, this._minThreads);
        }
        int threads = this._threadsStarted.get();
        while (this.isRunning() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        long start = System.currentTimeMillis();
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)(this._maxStopTime / 2)) {
            Thread.sleep(1L);
        }
        this._jobs.clear();
        1 noop = new /* Unavailable Anonymous Inner Class!! */;
        int i = this._threadsIdle.get();
        while (i-- > 0) {
            this._jobs.offer(noop);
        }
        Thread.yield();
        if (this._threadsStarted.get() > 0) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)this._maxStopTime) {
            Thread.sleep(1L);
        }
        Thread.yield();
        int size = this._threads.size();
        if (size > 0) {
            LOG.warn(size + " threads could not be stopped", new Object[0]);
            if (size == 1 || LOG.isDebugEnabled()) {
                for (Thread unstopped : this._threads) {
                    LOG.info("Couldn't stop " + unstopped, new Object[0]);
                    for (StackTraceElement element : unstopped.getStackTrace()) {
                        LOG.info(" at " + element, new Object[0]);
                    }
                }
            }
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxStopTimeMs(int stopTimeMs) {
        this._maxStopTime = stopTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        int threads = this._threadsStarted.get();
        while (this.isStarted() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    public int getMaxQueued() {
        return this._maxQueued;
    }

    public void setMaxQueued(int max) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._maxQueued = max;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTime;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    public boolean dispatch(Runnable job) {
        if (this.isRunning()) {
            int jobQ = this._jobs.size();
            int idle = this.getIdleThreads();
            if (this._jobs.offer(job)) {
                int threads;
                if ((idle == 0 || jobQ > idle) && (threads = this._threadsStarted.get()) < this._maxThreads) {
                    this.startThread(threads);
                }
                return true;
            }
        }
        LOG.debug("Dispatched {} to stopped {}", new Object[]{job, this});
        return false;
    }

    @Override
    public void execute(Runnable job) {
        if (!this.dispatch(job)) {
            throw new RejectedExecutionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    public int getThreads() {
        return this._threadsStarted.get();
    }

    public int getIdleThreads() {
        return this._threadsIdle.get();
    }

    public boolean isLowOnThreads() {
        return this._threadsStarted.get() == this._maxThreads && this._jobs.size() >= this._threadsIdle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startThread(int threads) {
        int next = threads + 1;
        if (!this._threadsStarted.compareAndSet(threads, next)) {
            return false;
        }
        boolean started = false;
        try {
            Thread thread = this.newThread(this._runnable);
            thread.setDaemon(this._daemon);
            thread.setPriority(this._priority);
            thread.setName(this._name + "-" + thread.getId());
            this._threads.add(thread);
            thread.start();
            started = true;
        }
        finally {
            if (!started) {
                this._threadsStarted.decrementAndGet();
            }
        }
        return started;
    }

    protected Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> dump = new ArrayList<Object>(this.getMaxThreads());
        for (Thread thread : this._threads) {
            StackTraceElement[] trace = thread.getStackTrace();
            boolean inIdleJobPoll = false;
            if (trace != null) {
                for (StackTraceElement t : trace) {
                    if (!"idleJobPoll".equals(t.getMethodName())) continue;
                    inIdleJobPoll = true;
                    break;
                }
            }
            boolean idle = inIdleJobPoll;
            if (this._detailedDump) {
                dump.add(new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            dump.add(thread.getId() + " " + thread.getName() + " " + (Object)((Object)thread.getState()) + " @ " + (trace.length > 0 ? trace[0] : "???") + (idle ? " IDLE" : ""));
        }
        AggregateLifeCycle.dumpObject((Appendable)out, (Object)this);
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{dump});
    }

    public String toString() {
        return this._name + "{" + this.getMinThreads() + "<=" + this.getIdleThreads() + "<=" + this.getThreads() + "/" + this.getMaxThreads() + "," + (this._jobs == null ? -1 : this._jobs.size()) + "}";
    }

    private Runnable idleJobPoll() throws InterruptedException {
        return (Runnable)this._jobs.poll(this._maxIdleTimeMs, TimeUnit.MILLISECONDS);
    }

    protected void runJob(Runnable job) {
        job.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    @Deprecated
    public boolean stopThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.stop();
            return true;
        }
        return false;
    }

    public boolean interruptThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    public String dumpThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ").append((Object)thread.getState()).append(":\n");
            for (StackTraceElement element : thread.getStackTrace()) {
                buf.append("  at ").append(element.toString()).append('\n');
            }
            return buf.toString();
        }
        return null;
    }

    static /* synthetic */ BlockingQueue access$000(QueuedThreadPool x0) {
        return x0._jobs;
    }

    static /* synthetic */ AtomicInteger access$100(QueuedThreadPool x0) {
        return x0._threadsIdle;
    }

    static /* synthetic */ int access$200(QueuedThreadPool x0) {
        return x0._maxIdleTimeMs;
    }

    static /* synthetic */ AtomicInteger access$300(QueuedThreadPool x0) {
        return x0._threadsStarted;
    }

    static /* synthetic */ int access$400(QueuedThreadPool x0) {
        return x0._minThreads;
    }

    static /* synthetic */ AtomicLong access$500(QueuedThreadPool x0) {
        return x0._lastShrink;
    }

    static /* synthetic */ Runnable access$600(QueuedThreadPool x0) throws InterruptedException {
        return x0.idleJobPoll();
    }

    static /* synthetic */ Logger access$700() {
        return LOG;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$800(QueuedThreadPool x0) {
        return x0._threads;
    }
}

