/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.util.IPAddressMap;
import org.eclipse.jetty.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressMap<TYPE>
extends HashMap<String, TYPE> {
    private final HashMap<String, IPAddrPattern> _patterns = new HashMap();

    public IPAddressMap() {
        super(11);
    }

    public IPAddressMap(int capacity) {
        super(capacity);
    }

    @Override
    public TYPE put(String addrSpec, TYPE object) throws IllegalArgumentException {
        if (addrSpec == null || addrSpec.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid IP address pattern: " + addrSpec);
        }
        String spec = addrSpec.trim();
        if (this._patterns.get(spec) == null) {
            this._patterns.put(spec, new IPAddrPattern(spec));
        }
        return super.put(spec, object);
    }

    @Override
    public TYPE get(Object key) {
        return (TYPE)super.get(key);
    }

    public TYPE match(String addr) {
        Map.Entry entry = this.getMatch(addr);
        return entry == null ? null : (TYPE)entry.getValue();
    }

    public Map.Entry<String, TYPE> getMatch(String addr) {
        if (addr != null) {
            for (Map.Entry entry : super.entrySet()) {
                if (!((IPAddrPattern)this._patterns.get(entry.getKey())).match(addr)) continue;
                return entry;
            }
        }
        return null;
    }

    public Object getLazyMatches(String addr) {
        if (addr == null) {
            return LazyList.getList(super.entrySet());
        }
        Object entries = null;
        for (Map.Entry entry : super.entrySet()) {
            if (!((IPAddrPattern)this._patterns.get(entry.getKey())).match(addr)) continue;
            entries = LazyList.add(entries, entry);
        }
        return entries;
    }
}

