/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class IO {
    private static final Logger LOG = Log.getLogger(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = 65536;
    private static NullOS __nullStream = new NullOS(null);
    private static ClosedIS __closedStream = new ClosedIS(null);
    private static NullWrite __nullWriter = new NullWrite(null);
    private static PrintWriter __nullPrintWriter = new PrintWriter((Writer)__nullWriter);

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            Job job = new Job(in, out);
            if (!Singleton.__pool.dispatch((Runnable)job)) {
                job.run();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy((InputStream)in, (OutputStream)out, (long)-1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            Job job = new Job(in, out);
            if (!Singleton.__pool.dispatch((Runnable)job)) {
                job.run();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy((Reader)in, (Writer)out, (long)-1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            int max;
            while (byteCount > 0L && (len = in.read(buffer, 0, max = byteCount < (long)bufferSize ? (int)byteCount : bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else if (out instanceof PrintWriter) {
            PrintWriter pout = (PrintWriter)out;
            while (!pout.checkError() && (len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            IO.copyDir((File)from, (File)to);
        } else {
            IO.copyFile((File)from, (File)to);
        }
    }

    public static void copyDir(File from, File to) throws IOException {
        File[] files;
        if (to.exists()) {
            if (!to.isDirectory()) {
                throw new IllegalArgumentException(to.toString());
            }
        } else {
            to.mkdirs();
        }
        if ((files = from.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (".".equals(name) || "..".equals(name)) continue;
                IO.copy((File)files[i], (File)new File(to, name));
            }
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        IO.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
    }

    public static String toString(InputStream in) throws IOException {
        return IO.toString((InputStream)in, null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        IO.copy((Reader)reader, (Writer)writer);
        return writer.toString();
    }

    public static String toString(Reader in) throws IOException {
        StringWriter writer = new StringWriter();
        IO.copy((Reader)in, (Writer)writer);
        return writer.toString();
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                IO.delete((File)files[i]);
            }
        }
        return file.delete();
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy((InputStream)in, (OutputStream)bout);
        return bout.toByteArray();
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static InputStream getClosedStream() {
        return __closedStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    public static PrintWriter getNullPrintWriter() {
        return __nullPrintWriter;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

