/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SocketConnector
extends AbstractConnector {
    private static final Logger LOG = Log.getLogger(SocketConnector.class);
    protected ServerSocket _serverSocket;
    protected final Set<EndPoint> _connections = new HashSet();
    protected volatile int _localPort = -1;

    public Object getConnection() {
        return this._serverSocket;
    }

    public void open() throws IOException {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
        }
        this._serverSocket.setReuseAddress(this.getReuseAddress());
        this._localPort = this._serverSocket.getLocalPort();
        if (this._localPort <= 0) {
            throw new IllegalStateException("port not allocated for " + this);
        }
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        ServerSocket ss = host == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(host));
        return ss;
    }

    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
        this._localPort = -2;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        ConnectorEndPoint connection = new ConnectorEndPoint(this, socket);
        connection.dispatch();
    }

    protected Connection newConnection(EndPoint endpoint) {
        return new BlockingHttpConnection((Connector)this, endpoint, this.getServer());
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        ConnectorEndPoint connection = (ConnectorEndPoint)endpoint;
        int lrmit = this.isLowResources() ? this._lowResourceMaxIdleTime : this._maxIdleTime;
        connection.setMaxIdleTime(lrmit);
        super.customize(endpoint, request);
    }

    public int getLocalPort() {
        return this._localPort;
    }

    protected void doStart() throws Exception {
        this._connections.clear();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        HashSet set = new HashSet();
        Set set2 = this._connections;
        synchronized (set2) {
            set.addAll(this._connections);
        }
        for (EndPoint endPoint : set) {
            ConnectorEndPoint connection = (ConnectorEndPoint)endPoint;
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        HashSet connections = new HashSet();
        Set set = this._connections;
        synchronized (set) {
            connections.addAll(this._connections);
        }
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{connections});
    }

    static /* synthetic */ int access$000(SocketConnector x0) {
        return x0._maxIdleTime;
    }

    static /* synthetic */ void access$100(SocketConnector x0, Connection x1, Connection x2) {
        x0.connectionUpgraded(x1, x2);
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    static /* synthetic */ void access$300(SocketConnector x0, Connection x1) {
        x0.connectionOpened(x1);
    }

    static /* synthetic */ void access$400(SocketConnector x0, Connection x1) {
        x0.connectionClosed(x1);
    }
}

