/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LocalConnector
extends AbstractConnector {
    private static final Logger LOG = Log.getLogger(LocalConnector.class);
    private final BlockingQueue<Request> _requests = new LinkedBlockingQueue();

    public LocalConnector() {
        this.setMaxIdleTime(30000);
    }

    public Object getConnection() {
        return this;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer result = this.getResponses(new ByteArrayBuffer(requests, "ISO-8859-1"), keepOpen);
        return result == null ? null : result.toString("ISO-8859-1");
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer requestsBuffer, boolean keepOpen) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Request request = new Request(this, requestsBuffer, keepOpen, latch, null);
        this._requests.add(request);
        latch.await(this.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        return request.getResponsesBuffer();
    }

    protected void accept(int acceptorID) throws IOException, InterruptedException {
        Request request = (Request)this._requests.take();
        this.getThreadPool().dispatch((Runnable)request);
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }

    public void executeRequest(String rawRequest) throws IOException {
        Request request = new Request(this, new ByteArrayBuffer(rawRequest, "UTF-8"), true, null, null);
        this._requests.add(request);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

