/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private final ContextHandler _contextHandler;
    private final String _uri;
    private final String _path;
    private final String _dQuery;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
        this._uri = null;
        this._path = null;
        this._dQuery = null;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest;
        Request request2 = baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)baseRequest.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry entry : old_params.entrySet()) {
                            String name = (String)entry.getKey();
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add((Object)name, LazyList.get(values, (int)i));
                            }
                        }
                    }
                    baseRequest.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(this, old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                baseRequest.setAttributes((Attributes)attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            baseRequest.setAttributes(old_attr);
            baseRequest.getConnection().included();
            baseRequest.setParameters(old_params);
            baseRequest.setDispatcherType(old_type);
            throw throwable;
        }
        baseRequest.setAttributes(old_attr);
        baseRequest.getConnection().included();
        baseRequest.setParameters(old_params);
        baseRequest.setDispatcherType(old_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
        Response base_response = baseRequest.getResponse();
        response.resetBuffer();
        base_response.fwdReset();
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        boolean old_handled = baseRequest.isHandled();
        String old_uri = baseRequest.getRequestURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        String old_query = baseRequest.getQueryString();
        Attributes old_attr = baseRequest.getAttributes();
        DispatcherType old_type = baseRequest.getDispatcherType();
        MultiMap old_params = baseRequest.getParameters();
        try {
            baseRequest.setHandled(false);
            baseRequest.setDispatcherType(dispatch);
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    baseRequest.mergeQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(this, old_attr);
                if (old_attr.getAttribute(FORWARD_REQUEST_URI) != null) {
                    attr._pathInfo = (String)old_attr.getAttribute(FORWARD_PATH_INFO);
                    attr._query = (String)old_attr.getAttribute(FORWARD_QUERY_STRING);
                    attr._requestURI = (String)old_attr.getAttribute(FORWARD_REQUEST_URI);
                    attr._contextPath = (String)old_attr.getAttribute(FORWARD_CONTEXT_PATH);
                    attr._servletPath = (String)old_attr.getAttribute(FORWARD_SERVLET_PATH);
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                baseRequest.setRequestURI(this._uri);
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(this._uri);
                baseRequest.setAttributes((Attributes)attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                if (!baseRequest.getAsyncContinuation().isAsyncStarted()) {
                    this.commitResponse(response, baseRequest);
                }
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            baseRequest.setHandled(old_handled);
            baseRequest.setRequestURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setAttributes(old_attr);
            baseRequest.setParameters(old_params);
            baseRequest.setQueryString(old_query);
            baseRequest.setDispatcherType(old_type);
            throw throwable;
        }
        baseRequest.setHandled(old_handled);
        baseRequest.setRequestURI(old_uri);
        baseRequest.setContextPath(old_context_path);
        baseRequest.setServletPath(old_servlet_path);
        baseRequest.setPathInfo(old_path_info);
        baseRequest.setAttributes(old_attr);
        baseRequest.setParameters(old_params);
        baseRequest.setQueryString(old_query);
        baseRequest.setDispatcherType(old_type);
    }

    private void commitResponse(ServletResponse response, Request baseRequest) throws IOException {
        if (baseRequest.getResponse().isWriting()) {
            try {
                response.getWriter().close();
            }
            catch (IllegalStateException e) {
                response.getOutputStream().close();
            }
        } else {
            try {
                response.getOutputStream().close();
            }
            catch (IllegalStateException e) {
                response.getWriter().close();
            }
        }
    }

    static /* synthetic */ String access$000(Dispatcher x0) {
        return x0._named;
    }
}

