/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpBuffersImpl;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class AbstractConnector
extends AggregateLifeCycle
implements HttpBuffers,
Connector,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractConnector.class);
    private String _name;
    private Server _server;
    private ThreadPool _threadPool;
    private String _host;
    private int _port = 0;
    private String _integralScheme = "https";
    private int _integralPort = 0;
    private String _confidentialScheme = "https";
    private int _confidentialPort = 0;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private int _acceptorPriorityOffset = 0;
    private boolean _useDNS;
    private boolean _forwarded;
    private String _hostHeader;
    private String _forwardedHostHeader = "X-Forwarded-Host";
    private String _forwardedServerHeader = "X-Forwarded-Server";
    private String _forwardedForHeader = "X-Forwarded-For";
    private String _forwardedProtoHeader = "X-Forwarded-Proto";
    private String _forwardedCipherSuiteHeader;
    private String _forwardedSslSessionIdHeader;
    private boolean _reuseAddress = true;
    protected int _maxIdleTime = 200000;
    protected int _lowResourceMaxIdleTime = -1;
    protected int _soLingerTime = -1;
    private transient Thread[] _acceptorThreads;
    private final AtomicLong _statsStartedAt = new AtomicLong(-1L);
    private final CounterStatistic _connectionStats = new CounterStatistic();
    private final SampleStatistic _requestStats = new SampleStatistic();
    private final SampleStatistic _connectionDurationStats = new SampleStatistic();
    protected final HttpBuffersImpl _buffers = new HttpBuffersImpl();

    public AbstractConnector() {
        this.addBean((Object)this._buffers);
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this.removeBean((Object)this._threadPool);
        this._threadPool = pool;
        this.addBean((Object)this._threadPool);
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getLowResourcesMaxIdleTime() {
        return this._lowResourceMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(int maxIdleTime) {
        this._lowResourceMaxIdleTime = maxIdleTime;
    }

    @Deprecated
    public final int getLowResourceMaxIdleTime() {
        return this.getLowResourcesMaxIdleTime();
    }

    @Deprecated
    public final void setLowResourceMaxIdleTime(int maxIdleTime) {
        this.setLowResourcesMaxIdleTime(maxIdleTime);
    }

    public int getSoLingerTime() {
        return this._soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public void setAcceptors(int acceptors) {
        if (acceptors > 2 * Runtime.getRuntime().availableProcessors()) {
            LOG.warn("Acceptors should be <=2*availableProcessors: " + this, new Object[0]);
        }
        this._acceptors = acceptors;
    }

    public void setSoLingerTime(int soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this._server == null) {
            throw new IllegalStateException("No server");
        }
        this.open();
        if (this._threadPool == null) {
            this._threadPool = this._server.getThreadPool();
            this.addBean((Object)this._threadPool, false);
        }
        super.doStart();
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            this._acceptorThreads = new Thread[this.getAcceptors()];
            for (int i = 0; i < this._acceptorThreads.length; ++i) {
                if (this._threadPool.dispatch((Runnable)new Acceptor(this, i))) continue;
                throw new IllegalStateException("!accepting");
            }
            if (this._threadPool.isLowOnThreads()) {
                LOG.warn("insufficient threads configured for {}", new Object[]{this});
            }
        }
        LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Thread[] acceptors;
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        super.doStop();
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            acceptors = this._acceptorThreads;
            this._acceptorThreads = null;
        }
        if (acceptors != null) {
            for (Thread thread : acceptors) {
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Thread[] threads;
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            threads = this._acceptorThreads;
        }
        if (threads != null) {
            for (Thread thread : threads) {
                if (thread == null) continue;
                thread.join();
            }
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._soLingerTime >= 0) {
                socket.setSoLinger(true, this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        if (this.isForwarded()) {
            this.checkForwardedHeaders(endpoint, request);
        }
    }

    protected void checkForwardedHeaders(EndPoint endpoint, Request request) throws IOException {
        String ssl_session_id;
        String cipher_suite;
        HttpFields httpFields = request.getConnection().getRequestFields();
        if (this.getForwardedCipherSuiteHeader() != null && (cipher_suite = httpFields.getStringField(this.getForwardedCipherSuiteHeader())) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipher_suite);
        }
        if (this.getForwardedSslSessionIdHeader() != null && (ssl_session_id = httpFields.getStringField(this.getForwardedSslSessionIdHeader())) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", (Object)ssl_session_id);
            request.setScheme("https");
        }
        String forwardedHost = this.getLeftMostFieldValue(httpFields, this.getForwardedHostHeader());
        String forwardedServer = this.getLeftMostFieldValue(httpFields, this.getForwardedServerHeader());
        String forwardedFor = this.getLeftMostFieldValue(httpFields, this.getForwardedForHeader());
        String forwardedProto = this.getLeftMostFieldValue(httpFields, this.getForwardedProtoHeader());
        if (this._hostHeader != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, this._hostHeader);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedHost != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, forwardedHost);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (forwardedServer != null) {
            request.setServerName(forwardedServer);
        }
        if (forwardedFor != null) {
            request.setRemoteAddr(forwardedFor);
            InetAddress inetAddress = null;
            if (this._useDNS) {
                try {
                    inetAddress = InetAddress.getByName(forwardedFor);
                }
                catch (UnknownHostException e) {
                    LOG.ignore((Throwable)e);
                }
            }
            request.setRemoteHost(inetAddress == null ? forwardedFor : inetAddress.getHostName());
        }
        if (forwardedProto != null) {
            request.setScheme(forwardedProto);
        }
    }

    protected String getLeftMostFieldValue(HttpFields fields, String header) {
        if (header == null) {
            return null;
        }
        String headerValue = fields.getStringField(header);
        if (headerValue == null) {
            return null;
        }
        int commaIndex = headerValue.indexOf(44);
        if (commaIndex == -1) {
            return headerValue;
        }
        return headerValue.substring(0, commaIndex);
    }

    public void persist(EndPoint endpoint) throws IOException {
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public boolean isIntegral(Request request) {
        return false;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public boolean isConfidential(Request request) {
        return this._forwarded && request.getScheme().equalsIgnoreCase("https");
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    public void stopAccept(int acceptorID) throws Exception {
    }

    public boolean getResolveNames() {
        return this._useDNS;
    }

    public void setResolveNames(boolean resolve) {
        this._useDNS = resolve;
    }

    public boolean isForwarded() {
        return this._forwarded;
    }

    public void setForwarded(boolean check) {
        if (check) {
            LOG.debug("{} is forwarded", new Object[]{this});
        }
        this._forwarded = check;
    }

    public String getHostHeader() {
        return this._hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this._hostHeader = hostHeader;
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String forwardedHostHeader) {
        this._forwardedHostHeader = forwardedHostHeader;
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String forwardedServerHeader) {
        this._forwardedServerHeader = forwardedServerHeader;
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String forwardedRemoteAddressHeader) {
        this._forwardedForHeader = forwardedRemoteAddressHeader;
    }

    public String getForwardedProtoHeader() {
        return this._forwardedProtoHeader;
    }

    public void setForwardedProtoHeader(String forwardedProtoHeader) {
        this._forwardedProtoHeader = forwardedProtoHeader;
    }

    public String getForwardedCipherSuiteHeader() {
        return this._forwardedCipherSuiteHeader;
    }

    public void setForwardedCipherSuiteHeader(String forwardedCipherSuite) {
        this._forwardedCipherSuiteHeader = forwardedCipherSuite;
    }

    public String getForwardedSslSessionIdHeader() {
        return this._forwardedSslSessionIdHeader;
    }

    public void setForwardedSslSessionIdHeader(String forwardedSslSessionId) {
        this._forwardedSslSessionIdHeader = forwardedSslSessionId;
    }

    public int getRequestBufferSize() {
        return this._buffers.getRequestBufferSize();
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this._buffers.setRequestBufferSize(requestBufferSize);
    }

    public int getRequestHeaderSize() {
        return this._buffers.getRequestHeaderSize();
    }

    public void setRequestHeaderSize(int requestHeaderSize) {
        this._buffers.setRequestHeaderSize(requestHeaderSize);
    }

    public int getResponseBufferSize() {
        return this._buffers.getResponseBufferSize();
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this._buffers.setResponseBufferSize(responseBufferSize);
    }

    public int getResponseHeaderSize() {
        return this._buffers.getResponseHeaderSize();
    }

    public void setResponseHeaderSize(int responseHeaderSize) {
        this._buffers.setResponseHeaderSize(responseHeaderSize);
    }

    public Buffers.Type getRequestBufferType() {
        return this._buffers.getRequestBufferType();
    }

    public Buffers.Type getRequestHeaderType() {
        return this._buffers.getRequestHeaderType();
    }

    public Buffers.Type getResponseBufferType() {
        return this._buffers.getResponseBufferType();
    }

    public Buffers.Type getResponseHeaderType() {
        return this._buffers.getResponseHeaderType();
    }

    public void setRequestBuffers(Buffers requestBuffers) {
        this._buffers.setRequestBuffers(requestBuffers);
    }

    public void setResponseBuffers(Buffers responseBuffers) {
        this._buffers.setResponseBuffers(responseBuffers);
    }

    public Buffers getRequestBuffers() {
        return this._buffers.getRequestBuffers();
    }

    public Buffers getResponseBuffers() {
        return this._buffers.getResponseBuffers();
    }

    public void setMaxBuffers(int maxBuffers) {
        this._buffers.setMaxBuffers(maxBuffers);
    }

    public int getMaxBuffers() {
        return this._buffers.getMaxBuffers();
    }

    public String toString() {
        return String.format("%s@%s:%d", this.getClass().getSimpleName(), this.getHost() == null ? "0.0.0.0" : this.getHost(), this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    public String getName() {
        if (this._name == null) {
            this._name = (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getRequests() {
        return (int)this._requestStats.getTotal();
    }

    public long getConnectionsDurationTotal() {
        return this._connectionDurationStats.getTotal();
    }

    public int getConnections() {
        return (int)this._connectionStats.getTotal();
    }

    public int getConnectionsOpen() {
        return (int)this._connectionStats.getCurrent();
    }

    public int getConnectionsOpenMax() {
        return (int)this._connectionStats.getMax();
    }

    public double getConnectionsDurationMean() {
        return this._connectionDurationStats.getMean();
    }

    public long getConnectionsDurationMax() {
        return this._connectionDurationStats.getMax();
    }

    public double getConnectionsDurationStdDev() {
        return this._connectionDurationStats.getStdDev();
    }

    public double getConnectionsRequestsMean() {
        return this._requestStats.getMean();
    }

    public int getConnectionsRequestsMax() {
        return (int)this._requestStats.getMax();
    }

    public double getConnectionsRequestsStdDev() {
        return this._requestStats.getStdDev();
    }

    public void statsReset() {
        this.updateNotEqual(this._statsStartedAt, -1L, System.currentTimeMillis());
        this._requestStats.reset();
        this._connectionStats.reset();
        this._connectionDurationStats.reset();
    }

    public void setStatsOn(boolean on) {
        if (on && this._statsStartedAt.get() != -1L) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Statistics on = " + on + " for " + this, new Object[0]);
        }
        this.statsReset();
        this._statsStartedAt.set(on ? System.currentTimeMillis() : -1L);
    }

    public boolean getStatsOn() {
        return this._statsStartedAt.get() != -1L;
    }

    public long getStatsOnMs() {
        long start = this._statsStartedAt.get();
        return start != -1L ? System.currentTimeMillis() - start : 0L;
    }

    protected void connectionOpened(Connection connection) {
        if (this._statsStartedAt.get() == -1L) {
            return;
        }
        this._connectionStats.increment();
    }

    protected void connectionUpgraded(Connection oldConnection, Connection newConnection) {
        this._requestStats.set(oldConnection instanceof AbstractHttpConnection ? (long)((AbstractHttpConnection)oldConnection).getRequests() : 0L);
    }

    protected void connectionClosed(Connection connection) {
        connection.onClose();
        if (this._statsStartedAt.get() == -1L) {
            return;
        }
        long duration = System.currentTimeMillis() - connection.getTimeStamp();
        int requests = connection instanceof AbstractHttpConnection ? ((AbstractHttpConnection)connection).getRequests() : 0;
        this._requestStats.set((long)requests);
        this._connectionStats.decrement();
        this._connectionDurationStats.set(duration);
    }

    public int getAcceptorPriorityOffset() {
        return this._acceptorPriorityOffset;
    }

    public void setAcceptorPriorityOffset(int offset) {
        this._acceptorPriorityOffset = offset;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this._reuseAddress = reuseAddress;
    }

    public boolean isLowResources() {
        if (this._threadPool != null) {
            return this._threadPool.isLowOnThreads();
        }
        return this._server.getThreadPool().isLowOnThreads();
    }

    private void updateNotEqual(AtomicLong valueHolder, long compare, long value) {
        long oldValue = valueHolder.get();
        while (compare != oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    static /* synthetic */ Thread[] access$000(AbstractConnector x0) {
        return x0._acceptorThreads;
    }

    static /* synthetic */ int access$100(AbstractConnector x0) {
        return x0._acceptorPriorityOffset;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

