/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DeferredAuthentication
implements Authentication.Deferred {
    private static final Logger LOG = Log.getLogger(DeferredAuthentication.class);
    protected final Authenticator _authenticator;
    private LoginService _loginService;
    private IdentityService _identityService;
    private Object _previousAssociation;
    static final HttpServletResponse __deferredResponse = new /* Unavailable Anonymous Inner Class!! */;
    private static ServletOutputStream __nullOut = new /* Unavailable Anonymous Inner Class!! */;

    public DeferredAuthentication(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }

    public Authentication authenticate(ServletRequest request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, (ServletResponse)__deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                if (this._identityService != null) {
                    this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            LOG.debug((Throwable)e);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public Authentication authenticate(ServletRequest request, ServletResponse response) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, response, true);
            if (authentication instanceof Authentication.User && this._identityService != null) {
                this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            LOG.debug((Throwable)e);
            return Authentication.UNAUTHENTICATED;
        }
    }

    public Authentication login(String username, String password) {
        UserIdentity user;
        if (this._loginService != null && (user = this._loginService.login(username, (Object)password)) != null) {
            UserAuthentication authentication = new UserAuthentication("API", user);
            if (this._identityService != null) {
                this._previousAssociation = this._identityService.associate(user);
            }
            return authentication;
        }
        return null;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public static boolean isDeferred(HttpServletResponse response) {
        return response == __deferredResponse;
    }

    static /* synthetic */ ServletOutputStream access$000() {
        return __nullOut;
    }
}

