/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class PropertyUserStore
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(PropertyUserStore.class);
    private String _config;
    private Resource _configResource;
    private Scanner _scanner;
    private int _refreshInterval = 0;
    private IdentityService _identityService = new DefaultIdentityService();
    private boolean _firstLoad = true;
    private final List<String> _knownUsers = new ArrayList();
    private final Map<String, UserIdentity> _knownUserIdentities = new HashMap();
    private List<UserListener> _listeners;

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public UserIdentity getUserIdentity(String userName) {
        return (UserIdentity)this._knownUserIdentities.get(userName);
    }

    public Resource getConfigResource() throws IOException {
        if (this._configResource == null) {
            this._configResource = Resource.newResource((String)this._config);
        }
        return this._configResource;
    }

    public void setRefreshInterval(int msec) {
        this._refreshInterval = msec;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() throws IOException {
        if (this._config == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Load " + this + " from " + this._config, new Object[0]);
        }
        Properties properties = new Properties();
        if (this.getConfigResource().exists()) {
            properties.load(this.getConfigResource().getInputStream());
        }
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = ((String)entry.getKey()).trim();
            String credentials = ((String)entry.getValue()).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            String[] roleArray = IdentityService.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = roles.split(",");
            }
            known.add(username);
            Credential credential = Credential.getCredential((String)credentials);
            MappedLoginService.KnownUser userPrincipal = new MappedLoginService.KnownUser(username, credential);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)userPrincipal);
            subject.getPrivateCredentials().add(credential);
            if (roles != null) {
                for (String role : roleArray) {
                    subject.getPrincipals().add((Principal)new MappedLoginService.RolePrincipal(role));
                }
            }
            subject.setReadOnly();
            this._knownUserIdentities.put(username, this._identityService.newUserIdentity(subject, (Principal)userPrincipal, roleArray));
            this.notifyUpdate(username, credential, roleArray);
        }
        List list = this._knownUsers;
        synchronized (list) {
            if (!this._firstLoad) {
                for (String user : this._knownUsers) {
                    if (known.contains(user)) continue;
                    this._knownUserIdentities.remove(user);
                    this.notifyRemove(user);
                }
            }
            this._knownUsers.clear();
            this._knownUsers.addAll(known);
        }
        this._firstLoad = false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getRefreshInterval() > 0) {
            this._scanner = new Scanner();
            this._scanner.setScanInterval(this.getRefreshInterval());
            ArrayList<File> dirList = new ArrayList<File>(1);
            dirList.add(this.getConfigResource().getFile().getParentFile());
            this._scanner.setScanDirs(dirList);
            this._scanner.setFilenameFilter((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            this._scanner.addListener((Scanner.Listener)new /* Unavailable Anonymous Inner Class!! */);
            this._scanner.setReportExistingFilesOnStartup(true);
            this._scanner.setRecursive(false);
            this._scanner.start();
        } else {
            this.loadUsers();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        this._scanner = null;
    }

    private void notifyUpdate(String username, Credential credential, String[] roleArray) {
        if (this._listeners != null) {
            Iterator i = this._listeners.iterator();
            while (i.hasNext()) {
                ((UserListener)i.next()).update(username, credential, roleArray);
            }
        }
    }

    private void notifyRemove(String username) {
        if (this._listeners != null) {
            Iterator i = this._listeners.iterator();
            while (i.hasNext()) {
                ((UserListener)i.next()).remove(username);
            }
        }
    }

    public void registerUserListener(UserListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    static /* synthetic */ Resource access$000(PropertyUserStore x0) {
        return x0._configResource;
    }

    static /* synthetic */ void access$100(PropertyUserStore x0) throws IOException {
        x0.loadUsers();
    }
}

