/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferDateCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HttpFields {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    public static final String __COOKIE_DELIM = "\"\\\n\r\t\f\b%+ ;=";
    public static final TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final BufferDateCache __dateCache = new BufferDateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final String __separators = ", \t";
    private static final String[] DAYS;
    private static final String[] MONTHS;
    private static final ThreadLocal<DateGenerator> __dateGenerator;
    private static final String[] __dateReceiveFmt;
    private static final ThreadLocal<DateParser> __dateParser;
    public static final String __01Jan1970;
    public static final Buffer __01Jan1970_BUFFER;
    public static final String __01Jan1970_COOKIE;
    private final ArrayList<Field> _fields = new ArrayList(20);
    private final HashMap<Buffer, Field> _names = new HashMap(32);
    private static ConcurrentMap<String, Buffer> __cache;
    private static int __cacheSize;
    private static final Float __one;
    private static final Float __zero;
    private static final StringMap __qualities;

    public static String formatDate(long date) {
        return ((DateGenerator)__dateGenerator.get()).formatDate(date);
    }

    public static void formatCookieDate(StringBuilder buf, long date) {
        ((DateGenerator)__dateGenerator.get()).formatCookieDate(buf, date);
    }

    public static String formatCookieDate(long date) {
        StringBuilder buf = new StringBuilder(28);
        HttpFields.formatCookieDate((StringBuilder)buf, (long)date);
        return buf.toString();
    }

    public static long parseDate(String date) {
        return ((DateParser)__dateParser.get()).parse(date);
    }

    private Buffer convertValue(String value) {
        Buffer buffer = (Buffer)__cache.get(value);
        if (buffer != null) {
            return buffer;
        }
        try {
            buffer = new ByteArrayBuffer(value, "ISO-8859-1");
            if (__cacheSize > 0) {
                Buffer b;
                if (__cache.size() > __cacheSize) {
                    __cache.clear();
                }
                if ((b = __cache.putIfAbsent(value, buffer)) != null) {
                    buffer = b;
                }
            }
            return buffer;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Enumeration<String> getFieldNames() {
        Enumeration buffers = Collections.enumeration(this._names.keySet());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int size() {
        return this._fields.size();
    }

    public Field getField(int i) {
        return (Field)this._fields.get(i);
    }

    private Field getField(String name) {
        return (Field)this._names.get(HttpHeaders.CACHE.lookup(name));
    }

    private Field getField(Buffer name) {
        return (Field)this._names.get(HttpHeaders.CACHE.lookup(name));
    }

    public boolean containsKey(Buffer name) {
        return this._names.containsKey(HttpHeaders.CACHE.lookup(name));
    }

    public boolean containsKey(String name) {
        return this._names.containsKey(HttpHeaders.CACHE.lookup(name));
    }

    public String getStringField(String name) {
        Field field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public String getStringField(Buffer name) {
        Field field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public Buffer get(Buffer name) {
        Field field = this.getField(name);
        return field == null ? null : Field.access$500((Field)field);
    }

    public Enumeration<String> getValues(String name) {
        Field field = this.getField(name);
        if (field == null) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Enumeration<String> getValues(Buffer name) {
        Field field = this.getField(name);
        if (field == null) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Enumeration<String> getValues(String name, String separators) {
        Enumeration e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void put(String name, String value) {
        if (value == null) {
            this.remove(name);
        } else {
            Buffer n = HttpHeaders.CACHE.lookup(name);
            Buffer v = this.convertValue(value);
            this.put(n, v);
        }
    }

    public void put(Buffer name, String value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = this.convertValue(value);
        this.put(n, v);
    }

    public void put(Buffer name, Buffer value) {
        this.remove(name);
        if (value == null) {
            return;
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        if (!(value instanceof BufferCache.CachedBuffer)) {
            value = HttpHeaderValues.CACHE.lookup(value).asImmutableBuffer();
        }
        Field field = new Field(name, value, null);
        this._fields.add(field);
        this._names.put(name, field);
    }

    public void put(String name, List<?> list) {
        if (list == null || list.size() == 0) {
            this.remove(name);
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Object v = list.get(0);
        if (v != null) {
            this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
        } else {
            this.remove(n);
        }
        if (list.size() > 1) {
            Iterator<?> iter = list.iterator();
            iter.next();
            while (iter.hasNext()) {
                v = iter.next();
                if (v == null) continue;
                this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
            }
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = this.convertValue(value);
        this.add(n, v);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        name = name.asImmutableBuffer();
        if (!(value instanceof BufferCache.CachedBuffer) && HttpHeaderValues.hasKnownValues((int)HttpHeaders.CACHE.getOrdinal(name))) {
            value = HttpHeaderValues.CACHE.lookup(value);
        }
        value = value.asImmutableBuffer();
        Field field = (Field)this._names.get(name);
        Field last = null;
        while (field != null) {
            last = field;
            field = Field.access$600((Field)field);
        }
        field = new Field(name, value, null);
        this._fields.add(field);
        if (last != null) {
            Field.access$602((Field)last, (Field)field);
        } else {
            this._names.put(name, field);
        }
    }

    public void remove(String name) {
        this.remove(HttpHeaders.CACHE.lookup(name));
    }

    public void remove(Buffer name) {
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        Field field = (Field)this._names.remove(name);
        while (field != null) {
            this._fields.remove(field);
            field = Field.access$600((Field)field);
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        Field field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        Field field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getDateField(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters((String)BufferUtil.to8859_1_String((Buffer)Field.access$500((Field)field)), null);
        if (val == null) {
            return -1L;
        }
        long date = ((DateParser)__dateParser.get()).parse(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer((long)value);
        this.put(name, v);
    }

    public void putLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer((long)value);
        this.put(n, v);
    }

    public void addLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer((long)value);
        this.add(n, v);
    }

    public void addLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer((long)value);
        this.add(name, v);
    }

    public void putDateField(Buffer name, long date) {
        String d = HttpFields.formatDate((long)date);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.put(name, (Buffer)v);
    }

    public void putDateField(String name, long date) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        this.putDateField(n, date);
    }

    public void addDateField(String name, long date) {
        String d = HttpFields.formatDate((long)date);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.add(n, (Buffer)v);
    }

    public void addSetCookie(HttpCookie cookie) {
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(), cookie.getComment(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String name, String value, String domain, String path, long maxAge, String comment, boolean isSecure, boolean isHttpOnly, int version) {
        String delim = "\"\\\n\r\t\f\b%+ ;=";
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder(128);
        QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)name, (String)delim);
        buf.append('=');
        String start = buf.toString();
        if (value != null && value.length() > 0) {
            QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)value, (String)delim);
        }
        if (comment != null && comment.length() > 0) {
            buf.append(";Comment=");
            QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)comment, (String)delim);
        }
        if (path != null && path.length() > 0) {
            buf.append(";Path=");
            if (path.trim().startsWith("\"")) {
                buf.append(path);
            } else {
                QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)path, (String)delim);
            }
        }
        if (domain != null && domain.length() > 0) {
            buf.append(";Domain=");
            QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)domain.toLowerCase(), (String)delim);
        }
        if (maxAge >= 0L) {
            buf.append(";Expires=");
            if (maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                HttpFields.formatCookieDate((StringBuilder)buf, (long)(System.currentTimeMillis() + 1000L * maxAge));
            }
            if (version > 0) {
                buf.append(";Max-Age=");
                buf.append(maxAge);
            }
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        String name_value_params = buf.toString();
        Field field = this.getField("Set-Cookie");
        Field last = null;
        while (field != null) {
            if (Field.access$500((Field)field) != null && Field.access$500((Field)field).toString().startsWith(start)) {
                this._fields.remove(field);
                if (last == null) {
                    this._names.put(HttpHeaders.SET_COOKIE_BUFFER, Field.access$600((Field)field));
                    break;
                }
                Field.access$602((Field)last, (Field)Field.access$600((Field)field));
                break;
            }
            last = field;
            field = Field.access$600((Field)field);
        }
        this.add(HttpHeaders.SET_COOKIE_BUFFER, (Buffer)new ByteArrayBuffer(name_value_params));
        this.put(HttpHeaders.EXPIRES_BUFFER, __01Jan1970_BUFFER);
    }

    public void putTo(Buffer buffer) throws IOException {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field field = (Field)this._fields.get(i);
            if (field == null) continue;
            field.putTo(buffer);
        }
        BufferUtil.putCRLF((Buffer)buffer);
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return e.toString();
        }
    }

    public void clear() {
        this._fields.clear();
        this._names.clear();
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, (String)values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Map<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Map.Entry entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (entry = __qualities.getEntry(value, ++qe, value.length() - qe)) != null) {
            return (Float)entry.getValue();
        }
        HashMap params = new HashMap(3);
        HttpFields.valueParameters((String)value, params);
        String qs = (String)params.get("q");
        Float q = (Float)__qualities.get(qs);
        if (q == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List qualityList(Enumeration e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement().toString();
            Float q = HttpFields.getQuality((String)v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, (Object)v);
            qual = LazyList.add(qual, (Object)q);
        }
        List vl = LazyList.getList(list, (boolean)false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, (boolean)false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                Object tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    static /* synthetic */ String[] access$000() {
        return DAYS;
    }

    static /* synthetic */ String[] access$100() {
        return MONTHS;
    }

    static /* synthetic */ String[] access$300() {
        return __dateReceiveFmt;
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __dateGenerator = new /* Unavailable Anonymous Inner Class!! */;
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
        __dateParser = new /* Unavailable Anonymous Inner Class!! */;
        __01Jan1970 = HttpFields.formatDate((long)0L);
        __01Jan1970_BUFFER = new ByteArrayBuffer(__01Jan1970);
        __01Jan1970_COOKIE = HttpFields.formatCookieDate((long)0L).trim();
        __cache = new ConcurrentHashMap();
        __cacheSize = Integer.getInteger("org.eclipse.jetty.http.HttpFields.CACHE", 2000);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }
}

