/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.continuation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationFilter;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.continuation.Servlet3Continuation;

public class Servlet3Continuation
implements Continuation {
    private static final ContinuationThrowable __exception = new ContinuationThrowable();
    private final ServletRequest _request;
    private ServletResponse _response;
    private AsyncContext _context;
    private List<AsyncListener> _listeners = new ArrayList();
    private volatile boolean _initial = true;
    private volatile boolean _resumed = false;
    private volatile boolean _expired = false;
    private volatile boolean _responseWrapped = false;
    private long _timeoutMs = -1L;

    public Servlet3Continuation(ServletRequest request) {
        this._request = request;
        this._listeners.add(new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addContinuationListener(ContinuationListener listener) {
        2 wrapped = new /* Unavailable Anonymous Inner Class!! */;
        if (this._context != null) {
            this._context.addListener((AsyncListener)wrapped);
        } else {
            this._listeners.add(wrapped);
        }
    }

    public void complete() {
        AsyncContext context = this._context;
        if (context == null) {
            throw new IllegalStateException();
        }
        this._context.complete();
    }

    public ServletResponse getServletResponse() {
        return this._response;
    }

    public boolean isExpired() {
        return this._expired;
    }

    public boolean isInitial() {
        return this._initial && this._request.getDispatcherType() != DispatcherType.ASYNC;
    }

    public boolean isResumed() {
        return this._resumed;
    }

    public boolean isSuspended() {
        return this._request.isAsyncStarted();
    }

    public void keepWrappers() {
        this._responseWrapped = true;
    }

    public void resume() {
        AsyncContext context = this._context;
        if (context == null) {
            throw new IllegalStateException();
        }
        this._resumed = true;
        this._context.dispatch();
    }

    public void setTimeout(long timeoutMs) {
        this._timeoutMs = timeoutMs;
        if (this._context != null) {
            this._context.setTimeout(timeoutMs);
        }
    }

    public void suspend(ServletResponse response) {
        this._response = response;
        this._responseWrapped = response instanceof ServletResponseWrapper;
        this._resumed = false;
        this._expired = false;
        this._context = this._request.startAsync();
        this._context.setTimeout(this._timeoutMs);
        for (AsyncListener listener : this._listeners) {
            this._context.addListener(listener);
        }
        this._listeners.clear();
    }

    public void suspend() {
        this._resumed = false;
        this._expired = false;
        this._context = this._request.startAsync();
        this._context.setTimeout(this._timeoutMs);
        for (AsyncListener listener : this._listeners) {
            this._context.addListener(listener);
        }
        this._listeners.clear();
    }

    public boolean isResponseWrapped() {
        return this._responseWrapped;
    }

    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._request.setAttribute(name, attribute);
    }

    public void undispatch() {
        if (this.isSuspended()) {
            if (ContinuationFilter.__debug) {
                throw new ContinuationThrowable();
            }
            throw __exception;
        }
        throw new IllegalStateException("!suspended");
    }

    static /* synthetic */ boolean access$002(Servlet3Continuation x0, boolean x1) {
        x0._initial = x1;
        return x0._initial;
    }

    static /* synthetic */ boolean access$102(Servlet3Continuation x0, boolean x1) {
        x0._expired = x1;
        return x0._expired;
    }
}

