/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.io.NumberInput;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class StdDeserializer<T>
extends JsonDeserializer<T> {
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    public Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultSerializer(JsonDeserializer<?> deserializer) {
        return deserializer != null && deserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return jp.getIntValue() != 0;
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text)) {
                return true;
            }
            if ("false".equals(text) || text.length() == 0) {
                return Boolean.FALSE;
            }
            throw ctxt.weirdStringException(this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Boolean _parseBoolean(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return jp.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text)) {
                return Boolean.FALSE;
            }
            if (text.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            throw ctxt.weirdStringException(this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Byte _parseByte(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue();
                }
                value = NumberInput.parseInt((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Byte value");
            }
            if (value < -128 || value > 127) {
                throw ctxt.weirdStringException(this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Short _parseShort(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue();
                }
                value = NumberInput.parseInt((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Short value");
            }
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdStringException(this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final short _parseShortPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        int value = this._parseIntPrimitive(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(this._valueClass, "Overflow: numeric value (" + text + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid int value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Integer _parseInteger(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(this._valueClass, "Overflow: numeric value (" + text + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Integer value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Long _parseLong(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            try {
                return NumberInput.parseLong((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final long _parseLongPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return 0L;
            }
            try {
                return NumberInput.parseLong((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0L;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Float _parseFloat(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jp.getFloatValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(text) && !"INF".equals(text)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!"NaN".equals(text)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!"-Infinity".equals(text) && !"-INF".equals(text)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final float _parseFloatPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return 0.0f;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(text) && !"INF".equals(text)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(text)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(text) && !"-INF".equals(text)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Double _parseDouble(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(text) && !"INF".equals(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(text) && !"-INF".equals(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid Double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final double _parseDoublePrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return 0.0;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(text) && !"INF".equals(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(text) && !"-INF".equals(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble((String)text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Date _parseDate(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jp.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            try {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                return ctxt.parseDate(str);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid representation (error: " + iae.getMessage() + ")");
            }
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected static final double parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationConfig config, DeserializerProvider provider, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = provider.findValueDeserializer(config, type, property);
        return deser;
    }

    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException, JsonProcessingException {
        if (instanceOrClass == null) {
            instanceOrClass = this.getValueClass();
        }
        if (ctxt.handleUnknownProperty(jp, (JsonDeserializer)this, instanceOrClass, propName)) {
            return;
        }
        this.reportUnknownProperty(ctxt, instanceOrClass, propName);
        jp.skipChildren();
    }

    protected void reportUnknownProperty(DeserializationContext ctxt, Object instanceOrClass, String fieldName) throws IOException, JsonProcessingException {
        if (ctxt.isEnabled(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            throw ctxt.unknownFieldException(instanceOrClass, fieldName);
        }
    }
}

