/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.std.FromStringDeserializer;
import org.codehaus.jackson.map.deser.std.StdScalarDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    protected FromStringDeserializer(Class<?> vc) {
        super(vc);
    }

    public static Iterable<FromStringDeserializer<?>> all() {
        ArrayList all = new ArrayList();
        all.add((FromStringDeserializer<?>)new UUIDDeserializer());
        all.add((FromStringDeserializer<?>)new URLDeserializer());
        all.add((FromStringDeserializer<?>)new URIDeserializer());
        all.add((FromStringDeserializer<?>)new CurrencyDeserializer());
        all.add((FromStringDeserializer<?>)new PatternDeserializer());
        all.add((FromStringDeserializer<?>)new LocaleDeserializer());
        all.add((FromStringDeserializer<?>)new InetAddressDeserializer());
        all.add((FromStringDeserializer<?>)new TimeZoneDeserializer());
        return all;
    }

    public final T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if (text.length() == 0) {
                return null;
            }
            try {
                Object result = this._deserialize(text, ctxt);
                if (result != null) {
                    return (T)result;
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            throw ctxt.weirdStringException(this._valueClass, "not a valid textual representation");
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(ob.getClass())) {
                return (T)ob;
            }
            return (T)this._deserializeEmbedded(ob, ctxt);
        }
        throw ctxt.mappingException(this._valueClass);
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected T _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        throw ctxt.mappingException("Don't know how to convert embedded Object of type " + ob.getClass().getName() + " into " + this._valueClass.getName());
    }
}

