/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.GregorianCalendar;
import java.util.HashMap;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.deser.std.AtomicBooleanDeserializer;
import org.codehaus.jackson.map.deser.std.CalendarDeserializer;
import org.codehaus.jackson.map.deser.std.ClassDeserializer;
import org.codehaus.jackson.map.deser.std.DateDeserializer;
import org.codehaus.jackson.map.deser.std.FromStringDeserializer;
import org.codehaus.jackson.map.deser.std.JavaTypeDeserializer;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.deser.std.StringDeserializer;
import org.codehaus.jackson.map.deser.std.TimestampDeserializer;
import org.codehaus.jackson.map.deser.std.TokenBufferDeserializer;
import org.codehaus.jackson.map.deser.std.UntypedObjectDeserializer;
import org.codehaus.jackson.map.type.ClassKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdDeserializers {
    final HashMap<ClassKey, JsonDeserializer<Object>> _deserializers = new HashMap();

    private StdDeserializers() {
        this.add((StdDeserializer)new UntypedObjectDeserializer());
        StringDeserializer strDeser = new StringDeserializer();
        this.add((StdDeserializer)strDeser, String.class);
        this.add((StdDeserializer)strDeser, CharSequence.class);
        this.add((StdDeserializer)new ClassDeserializer());
        this.add((StdDeserializer)new StdDeserializer.BooleanDeserializer(Boolean.class, null));
        this.add((StdDeserializer)new StdDeserializer.ByteDeserializer(Byte.class, null));
        this.add((StdDeserializer)new StdDeserializer.ShortDeserializer(Short.class, null));
        this.add((StdDeserializer)new StdDeserializer.CharacterDeserializer(Character.class, null));
        this.add((StdDeserializer)new StdDeserializer.IntegerDeserializer(Integer.class, null));
        this.add((StdDeserializer)new StdDeserializer.LongDeserializer(Long.class, null));
        this.add((StdDeserializer)new StdDeserializer.FloatDeserializer(Float.class, null));
        this.add((StdDeserializer)new StdDeserializer.DoubleDeserializer(Double.class, null));
        this.add((StdDeserializer)new StdDeserializer.BooleanDeserializer(Boolean.TYPE, Boolean.FALSE));
        this.add((StdDeserializer)new StdDeserializer.ByteDeserializer(Byte.TYPE, Byte.valueOf((byte)0)));
        this.add((StdDeserializer)new StdDeserializer.ShortDeserializer(Short.TYPE, Short.valueOf((short)0)));
        this.add((StdDeserializer)new StdDeserializer.CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000')));
        this.add((StdDeserializer)new StdDeserializer.IntegerDeserializer(Integer.TYPE, Integer.valueOf(0)));
        this.add((StdDeserializer)new StdDeserializer.LongDeserializer(Long.TYPE, Long.valueOf(0L)));
        this.add((StdDeserializer)new StdDeserializer.FloatDeserializer(Float.TYPE, Float.valueOf(0.0f)));
        this.add((StdDeserializer)new StdDeserializer.DoubleDeserializer(Double.TYPE, Double.valueOf(0.0)));
        this.add((StdDeserializer)new StdDeserializer.NumberDeserializer());
        this.add((StdDeserializer)new StdDeserializer.BigDecimalDeserializer());
        this.add((StdDeserializer)new StdDeserializer.BigIntegerDeserializer());
        this.add((StdDeserializer)new CalendarDeserializer());
        this.add((StdDeserializer)new DateDeserializer());
        this.add((StdDeserializer)new CalendarDeserializer(GregorianCalendar.class), GregorianCalendar.class);
        this.add((StdDeserializer)new StdDeserializer.SqlDateDeserializer());
        this.add((StdDeserializer)new TimestampDeserializer());
        for (FromStringDeserializer deser : FromStringDeserializer.all()) {
            this.add((StdDeserializer)deser);
        }
        this.add((StdDeserializer)new StdDeserializer.StackTraceElementDeserializer());
        this.add((StdDeserializer)new AtomicBooleanDeserializer());
        this.add((StdDeserializer)new TokenBufferDeserializer());
        this.add((StdDeserializer)new JavaTypeDeserializer());
    }

    public static HashMap<ClassKey, JsonDeserializer<Object>> constructAll() {
        return new StdDeserializers()._deserializers;
    }

    private void add(StdDeserializer<?> stdDeser) {
        this.add(stdDeser, stdDeser.getValueClass());
    }

    private void add(StdDeserializer<?> stdDeser, Class<?> valueClass) {
        StdDeserializer<?> deser = stdDeser;
        this._deserializers.put(new ClassKey(valueClass), deser);
    }
}

