/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.map.AbstractTypeResolver;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.ContextualKeyDeserializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.KeyDeserializers;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.StdDeserializerProvider;
import org.codehaus.jackson.map.deser.ValueInstantiators;
import org.codehaus.jackson.map.deser.std.StdKeyDeserializers;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionLikeType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.map.util.RootNameLookup;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerProvider
extends DeserializerProvider {
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);
    protected final RootNameLookup _rootNames;
    protected DeserializerFactory _factory;

    public StdDeserializerProvider() {
        this((DeserializerFactory)BeanDeserializerFactory.instance);
    }

    public StdDeserializerProvider(DeserializerFactory f) {
        this._factory = f;
        this._rootNames = new RootNameLookup();
    }

    public DeserializerProvider withAdditionalDeserializers(Deserializers d) {
        return this.withFactory(this._factory.withAdditionalDeserializers(d));
    }

    public DeserializerProvider withAdditionalKeyDeserializers(KeyDeserializers d) {
        return this.withFactory(this._factory.withAdditionalKeyDeserializers(d));
    }

    public DeserializerProvider withDeserializerModifier(BeanDeserializerModifier modifier) {
        return this.withFactory(this._factory.withDeserializerModifier(modifier));
    }

    public DeserializerProvider withAbstractTypeResolver(AbstractTypeResolver resolver) {
        return this.withFactory(this._factory.withAbstractTypeResolver(resolver));
    }

    public DeserializerProvider withValueInstantiators(ValueInstantiators instantiators) {
        return this.withFactory(this._factory.withValueInstantiators(instantiators));
    }

    public StdDeserializerProvider withFactory(DeserializerFactory factory) {
        if (this.getClass() != StdDeserializerProvider.class) {
            throw new IllegalStateException("DeserializerProvider of type " + this.getClass().getName() + " does not override 'withFactory()' method");
        }
        return new StdDeserializerProvider(factory);
    }

    public JavaType mapAbstractType(DeserializationConfig config, JavaType type) throws JsonMappingException {
        return this._factory.mapAbstractType(config, type);
    }

    public SerializedString findExpectedRootName(DeserializationConfig config, JavaType type) throws JsonMappingException {
        return this._rootNames.findRootName(type, (MapperConfig)config);
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationConfig config, JavaType propertyType, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._findCachedDeserializer(propertyType);
        if (deser != null) {
            if (deser instanceof ContextualDeserializer) {
                JsonDeserializer d;
                deser = d = ((ContextualDeserializer)deser).createContextual(config, property);
            }
            return deser;
        }
        deser = this._createAndCacheValueDeserializer(config, propertyType, property);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(propertyType);
        }
        if (deser instanceof ContextualDeserializer) {
            JsonDeserializer d;
            deser = d = ((ContextualDeserializer)deser).createContextual(config, property);
        }
        return deser;
    }

    public JsonDeserializer<Object> findTypedValueDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this.findValueDeserializer(config, type, property);
        TypeDeserializer typeDeser = this._factory.findTypeDeserializer(config, type, property);
        if (typeDeser != null) {
            return new WrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._factory.createKeyDeserializer(config, type, property);
        if (kd == null) {
            Class raw = type.getRawClass();
            if (raw == String.class || raw == Object.class) {
                return null;
            }
            KeyDeserializer kdes = (KeyDeserializer)_keyDeserializers.get(type);
            if (kdes != null) {
                return kdes;
            }
            if (type.isEnumType()) {
                return StdKeyDeserializers.constructEnumKeyDeserializer((DeserializationConfig)config, (JavaType)type);
            }
            kdes = StdKeyDeserializers.findStringBasedKeyDeserializer((DeserializationConfig)config, (JavaType)type);
            if (kdes != null) {
                return kdes;
            }
            if (kd == null) {
                return this._handleUnknownKeyDeserializer(type);
            }
        }
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)kd).createContextual(config, property);
        }
        return kd;
    }

    public boolean hasValueDeserializerFor(DeserializationConfig config, JavaType type) {
        JsonDeserializer deser = this._findCachedDeserializer(type);
        if (deser == null) {
            try {
                deser = this._createAndCacheValueDeserializer(config, type, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return deser != null;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return (JsonDeserializer)this._cachedDeserializers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        HashMap hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer jsonDeserializer;
            block9: {
                JsonDeserializer deser = this._findCachedDeserializer(type);
                if (deser != null) {
                    return deser;
                }
                int count = this._incompleteDeserializers.size();
                if (count > 0 && (deser = (JsonDeserializer)this._incompleteDeserializers.get(type)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(config, type, property);
                    if (count != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (count == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        AnnotatedClass ac;
        AnnotationIntrospector aintr;
        Boolean cacheAnn;
        boolean addToCache;
        JsonDeserializer deser;
        try {
            deser = this._createDeserializer(config, type, property);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, (Throwable)iae);
        }
        if (deser == null) {
            return null;
        }
        boolean isResolvable = deser instanceof ResolvableDeserializer;
        boolean bl = addToCache = deser.getClass() == BeanDeserializer.class;
        if (!addToCache && config.isEnabled(DeserializationConfig.Feature.USE_ANNOTATIONS) && (cacheAnn = (aintr = config.getAnnotationIntrospector()).findCachability(ac = AnnotatedClass.construct(deser.getClass(), (AnnotationIntrospector)aintr, null))) != null) {
            addToCache = cacheAnn;
        }
        if (isResolvable) {
            this._incompleteDeserializers.put(type, deser);
            this._resolveDeserializer(config, (ResolvableDeserializer)deser);
            this._incompleteDeserializers.remove(type);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        if (type.isEnumType()) {
            return this._factory.createEnumDeserializer(config, (DeserializerProvider)this, type, property);
        }
        if (type.isContainerType()) {
            if (type.isArrayType()) {
                return this._factory.createArrayDeserializer(config, (DeserializerProvider)this, (ArrayType)type, property);
            }
            if (type.isMapLikeType()) {
                MapLikeType mlt = (MapLikeType)type;
                if (mlt.isTrueMapType()) {
                    return this._factory.createMapDeserializer(config, (DeserializerProvider)this, (MapType)mlt, property);
                }
                return this._factory.createMapLikeDeserializer(config, (DeserializerProvider)this, mlt, property);
            }
            if (type.isCollectionLikeType()) {
                CollectionLikeType clt = (CollectionLikeType)type;
                if (clt.isTrueCollectionType()) {
                    return this._factory.createCollectionDeserializer(config, (DeserializerProvider)this, (CollectionType)clt, property);
                }
                return this._factory.createCollectionLikeDeserializer(config, (DeserializerProvider)this, clt, property);
            }
        }
        if (JsonNode.class.isAssignableFrom(type.getRawClass())) {
            return this._factory.createTreeDeserializer(config, (DeserializerProvider)this, type, property);
        }
        return this._factory.createBeanDeserializer(config, (DeserializerProvider)this, type, property);
    }

    protected void _resolveDeserializer(DeserializationConfig config, ResolvableDeserializer ser) throws JsonMappingException {
        ser.resolve(config, (DeserializerProvider)this);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) throws JsonMappingException {
        Class rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete((Class)rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type);
    }
}

