/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject.support;

import java.io.Serializable;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.HostAuthenticationToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.MapContext;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubjectContext
extends MapContext
implements SubjectContext {
    private static final String SECURITY_MANAGER = DefaultSubjectContext.class.getName() + ".SECURITY_MANAGER";
    private static final String SESSION_ID = DefaultSubjectContext.class.getName() + ".SESSION_ID";
    private static final String AUTHENTICATION_TOKEN = DefaultSubjectContext.class.getName() + ".AUTHENTICATION_TOKEN";
    private static final String AUTHENTICATION_INFO = DefaultSubjectContext.class.getName() + ".AUTHENTICATION_INFO";
    private static final String SUBJECT = DefaultSubjectContext.class.getName() + ".SUBJECT";
    private static final String PRINCIPALS = DefaultSubjectContext.class.getName() + ".PRINCIPALS";
    private static final String SESSION = DefaultSubjectContext.class.getName() + ".SESSION";
    private static final String AUTHENTICATED = DefaultSubjectContext.class.getName() + ".AUTHENTICATED";
    private static final String HOST = DefaultSubjectContext.class.getName() + ".HOST";
    public static final String SESSION_CREATION_ENABLED = DefaultSubjectContext.class.getName() + ".SESSION_CREATION_ENABLED";
    public static final String PRINCIPALS_SESSION_KEY = DefaultSubjectContext.class.getName() + "_PRINCIPALS_SESSION_KEY";
    public static final String AUTHENTICATED_SESSION_KEY = DefaultSubjectContext.class.getName() + "_AUTHENTICATED_SESSION_KEY";
    private static final transient Logger log = LoggerFactory.getLogger(DefaultSubjectContext.class);

    public DefaultSubjectContext() {
    }

    public DefaultSubjectContext(SubjectContext ctx) {
        super((Map)ctx);
    }

    public SecurityManager getSecurityManager() {
        return (SecurityManager)this.getTypedValue(SECURITY_MANAGER, SecurityManager.class);
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.nullSafePut(SECURITY_MANAGER, (Object)securityManager);
    }

    public SecurityManager resolveSecurityManager() {
        SecurityManager securityManager;
        block4: {
            securityManager = this.getSecurityManager();
            if (securityManager == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No SecurityManager available in subject context map.  Falling back to SecurityUtils.getSecurityManager() lookup.");
                }
                try {
                    securityManager = SecurityUtils.getSecurityManager();
                }
                catch (UnavailableSecurityManagerException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("No SecurityManager available via SecurityUtils.  Heuristics exhausted.", (Throwable)e);
                }
            }
        }
        return securityManager;
    }

    public Serializable getSessionId() {
        return (Serializable)this.getTypedValue(SESSION_ID, Serializable.class);
    }

    public void setSessionId(Serializable sessionId) {
        this.nullSafePut(SESSION_ID, (Object)sessionId);
    }

    public Subject getSubject() {
        return (Subject)this.getTypedValue(SUBJECT, Subject.class);
    }

    public void setSubject(Subject subject) {
        this.nullSafePut(SUBJECT, (Object)subject);
    }

    public PrincipalCollection getPrincipals() {
        return (PrincipalCollection)this.getTypedValue(PRINCIPALS, PrincipalCollection.class);
    }

    public void setPrincipals(PrincipalCollection principals) {
        if (!CollectionUtils.isEmpty((PrincipalCollection)principals)) {
            this.put(PRINCIPALS, (Object)principals);
        }
    }

    public PrincipalCollection resolvePrincipals() {
        Session session;
        Subject subject;
        AuthenticationInfo info;
        PrincipalCollection principals = this.getPrincipals();
        if (CollectionUtils.isEmpty((PrincipalCollection)principals) && (info = this.getAuthenticationInfo()) != null) {
            principals = info.getPrincipals();
        }
        if (CollectionUtils.isEmpty((PrincipalCollection)principals) && (subject = this.getSubject()) != null) {
            principals = subject.getPrincipals();
        }
        if (CollectionUtils.isEmpty((PrincipalCollection)principals) && (session = this.resolveSession()) != null) {
            principals = (PrincipalCollection)session.getAttribute((Object)PRINCIPALS_SESSION_KEY);
        }
        return principals;
    }

    public Session getSession() {
        return (Session)this.getTypedValue(SESSION, Session.class);
    }

    public void setSession(Session session) {
        this.nullSafePut(SESSION, (Object)session);
    }

    public Session resolveSession() {
        Subject existingSubject;
        Session session = this.getSession();
        if (session == null && (existingSubject = this.getSubject()) != null) {
            session = existingSubject.getSession(false);
        }
        return session;
    }

    public boolean isSessionCreationEnabled() {
        Boolean val = (Boolean)this.getTypedValue(SESSION_CREATION_ENABLED, Boolean.class);
        return val == null || val != false;
    }

    public void setSessionCreationEnabled(boolean enabled) {
        this.nullSafePut(SESSION_CREATION_ENABLED, (Object)enabled);
    }

    public boolean isAuthenticated() {
        Boolean authc = (Boolean)this.getTypedValue(AUTHENTICATED, Boolean.class);
        return authc != null && authc != false;
    }

    public void setAuthenticated(boolean authc) {
        this.put(AUTHENTICATED, (Object)authc);
    }

    public boolean resolveAuthenticated() {
        Session session;
        Boolean authc = (Boolean)this.getTypedValue(AUTHENTICATED, Boolean.class);
        if (authc == null) {
            AuthenticationInfo info = this.getAuthenticationInfo();
            authc = info != null;
        }
        if (!authc.booleanValue() && (session = this.resolveSession()) != null) {
            Boolean sessionAuthc = (Boolean)session.getAttribute((Object)AUTHENTICATED_SESSION_KEY);
            authc = sessionAuthc != null && sessionAuthc != false;
        }
        return authc;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return (AuthenticationInfo)this.getTypedValue(AUTHENTICATION_INFO, AuthenticationInfo.class);
    }

    public void setAuthenticationInfo(AuthenticationInfo info) {
        this.nullSafePut(AUTHENTICATION_INFO, (Object)info);
    }

    public AuthenticationToken getAuthenticationToken() {
        return (AuthenticationToken)this.getTypedValue(AUTHENTICATION_TOKEN, AuthenticationToken.class);
    }

    public void setAuthenticationToken(AuthenticationToken token) {
        this.nullSafePut(AUTHENTICATION_TOKEN, (Object)token);
    }

    public String getHost() {
        return (String)this.getTypedValue(HOST, String.class);
    }

    public void setHost(String host) {
        if (StringUtils.hasText((String)host)) {
            this.put(HOST, (Object)host);
        }
    }

    public String resolveHost() {
        Session session;
        AuthenticationToken token;
        String host = this.getHost();
        if (host == null && (token = this.getAuthenticationToken()) instanceof HostAuthenticationToken) {
            host = ((HostAuthenticationToken)token).getHost();
        }
        if (host == null && (session = this.resolveSession()) != null) {
            host = session.getHost();
        }
        return host;
    }
}

