/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.mgt.CachingSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealmSecurityManager
extends CachingSecurityManager {
    private Collection<Realm> realms;

    public void setRealm(Realm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Realm argument cannot be null");
        }
        ArrayList<Realm> realms = new ArrayList<Realm>(1);
        realms.add(realm);
        this.setRealms(realms);
    }

    public void setRealms(Collection<Realm> realms) {
        if (realms == null) {
            throw new IllegalArgumentException("Realms collection argument cannot be null.");
        }
        if (realms.isEmpty()) {
            throw new IllegalArgumentException("Realms collection argument cannot be empty.");
        }
        this.realms = realms;
        this.afterRealmsSet();
    }

    protected void afterRealmsSet() {
        this.applyCacheManagerToRealms();
    }

    public Collection<Realm> getRealms() {
        return this.realms;
    }

    protected void applyCacheManagerToRealms() {
        CacheManager cacheManager = this.getCacheManager();
        Collection realms = this.getRealms();
        if (cacheManager != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof CacheManagerAware)) continue;
                ((CacheManagerAware)realm).setCacheManager(cacheManager);
            }
        }
    }

    protected void afterCacheManagerSet() {
        this.applyCacheManagerToRealms();
    }

    public void destroy() {
        LifecycleUtils.destroy((Collection)this.getRealms());
        this.realms = null;
        super.destroy();
    }
}

