/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.ConfigurableHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;

public class DefaultHashService
implements ConfigurableHashService {
    private RandomNumberGenerator rng = new SecureRandomNumberGenerator();
    private String algorithmName = "SHA-512";
    private ByteSource privateSalt;
    private int iterations = 1;
    private boolean generatePublicSalt = false;

    public Hash computeHash(HashRequest request) {
        if (request == null || request.getSource() == null || request.getSource().isEmpty()) {
            return null;
        }
        String algorithmName = this.getAlgorithmName(request);
        ByteSource source = request.getSource();
        int iterations = this.getIterations(request);
        ByteSource publicSalt = this.getPublicSalt(request);
        ByteSource privateSalt = this.getPrivateSalt();
        ByteSource salt = this.combine(privateSalt, publicSalt);
        SimpleHash computed = new SimpleHash(algorithmName, (Object)source, (Object)salt, iterations);
        SimpleHash result = new SimpleHash(algorithmName);
        result.setBytes(computed.getBytes());
        result.setIterations(iterations);
        result.setSalt(publicSalt);
        return result;
    }

    protected String getAlgorithmName(HashRequest request) {
        String name = request.getAlgorithmName();
        if (name == null) {
            name = this.getHashAlgorithmName();
        }
        return name;
    }

    protected int getIterations(HashRequest request) {
        int iterations = Math.max(0, request.getIterations());
        if (iterations < 1) {
            iterations = Math.max(1, this.getHashIterations());
        }
        return iterations;
    }

    protected ByteSource getPublicSalt(HashRequest request) {
        boolean privateSaltExists;
        ByteSource publicSalt = request.getSalt();
        if (publicSalt != null && !publicSalt.isEmpty()) {
            return publicSalt;
        }
        publicSalt = null;
        ByteSource privateSalt = this.getPrivateSalt();
        boolean bl = privateSaltExists = privateSalt != null && !privateSalt.isEmpty();
        if (privateSaltExists || this.isGeneratePublicSalt()) {
            publicSalt = this.getRandomNumberGenerator().nextBytes();
        }
        return publicSalt;
    }

    protected ByteSource combine(ByteSource privateSalt, ByteSource publicSalt) {
        int j;
        byte[] publicSaltBytes;
        int extraBytesLength;
        byte[] privateSaltBytes = privateSalt != null ? privateSalt.getBytes() : null;
        int privateSaltLength = privateSaltBytes != null ? privateSaltBytes.length : 0;
        int length = privateSaltLength + (extraBytesLength = (publicSaltBytes = publicSalt != null ? publicSalt.getBytes() : null) != null ? publicSaltBytes.length : 0);
        if (length <= 0) {
            return null;
        }
        byte[] combined = new byte[length];
        int i = 0;
        for (j = 0; j < privateSaltLength; ++j) {
            assert (privateSaltBytes != null);
            combined[i++] = privateSaltBytes[j];
        }
        for (j = 0; j < extraBytesLength; ++j) {
            assert (publicSaltBytes != null);
            combined[i++] = publicSaltBytes[j];
        }
        return ByteSource.Util.bytes((byte[])combined);
    }

    public void setHashAlgorithmName(String name) {
        this.algorithmName = name;
    }

    public String getHashAlgorithmName() {
        return this.algorithmName;
    }

    public void setPrivateSalt(ByteSource privateSalt) {
        this.privateSalt = privateSalt;
    }

    public ByteSource getPrivateSalt() {
        return this.privateSalt;
    }

    public void setHashIterations(int count) {
        this.iterations = count;
    }

    public int getHashIterations() {
        return this.iterations;
    }

    public void setRandomNumberGenerator(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    public RandomNumberGenerator getRandomNumberGenerator() {
        return this.rng;
    }

    public boolean isGeneratePublicSalt() {
        return this.generatePublicSalt;
    }

    public void setGeneratePublicSalt(boolean generatePublicSalt) {
        this.generatePublicSalt = generatePublicSalt;
    }
}

