/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardPermission
implements Permission,
Serializable {
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final boolean DEFAULT_CASE_SENSITIVE = false;
    private List<Set<String>> parts;

    protected WildcardPermission() {
    }

    public WildcardPermission(String wildcardString) {
        this(wildcardString, false);
    }

    public WildcardPermission(String wildcardString, boolean caseSensitive) {
        this.setParts(wildcardString, caseSensitive);
    }

    protected void setParts(String wildcardString) {
        this.setParts(wildcardString, false);
    }

    protected void setParts(String wildcardString, boolean caseSensitive) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        wildcardString = wildcardString.trim();
        List parts = CollectionUtils.asList((Object[])wildcardString.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList();
        for (String part : parts) {
            Set subparts = CollectionUtils.asSet((Object[])part.split(SUBPART_DIVIDER_TOKEN));
            if (!caseSensitive) {
                subparts = this.lowercase(subparts);
            }
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    private Set<String> lowercase(Set<String> subparts) {
        LinkedHashSet<String> lowerCasedSubparts = new LinkedHashSet<String>(subparts.size());
        for (String subpart : subparts) {
            lowerCasedSubparts.add(subpart.toLowerCase());
        }
        return lowerCasedSubparts;
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission wp = (WildcardPermission)p;
        List otherParts = wp.getParts();
        int i = 0;
        for (Set otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set part = (Set)this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set part = (Set)this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set part : this.parts) {
            if (buffer.length() > 0) {
                buffer.append(PART_DIVIDER_TOKEN);
            }
            buffer.append(part);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardPermission) {
            WildcardPermission wp = (WildcardPermission)o;
            return ((Object)this.parts).equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.parts).hashCode();
    }
}

