/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MethodUtils {
    private static boolean loggedAccessibleWarning = false;
    private static boolean CACHE_METHODS = true;
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map cache = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public static synchronized void setCacheMethods(boolean cacheMethods) {
        CACHE_METHODS = cacheMethods;
        if (!CACHE_METHODS) {
            MethodUtils.clearCache();
        }
    }

    public static synchronized int clearCache() {
        int size = cache.size();
        cache.clear();
        return size;
    }

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), (String)methodName, (Class[])parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod((Object)object, (String)methodName, (Object[])args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), (String)methodName, (Class[])parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class objectClass, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod((Class)objectClass, (String)methodName, (Class[])parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeStaticMethod((Class)objectClass, (String)methodName, (Object[])args);
    }

    public static Object invokeStaticMethod(Class objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeStaticMethod((Class)objectClass, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeStaticMethod(Class objectClass, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod((Class)objectClass, (String)methodName, (Class[])parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeExactStaticMethod(Class objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactStaticMethod((Class)objectClass, (String)methodName, (Object[])args);
    }

    public static Object invokeExactStaticMethod(Class objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactStaticMethod((Class)objectClass, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod((Class)clazz, (String)methodName, (Class[])parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            MethodDescriptor md = new MethodDescriptor(clazz, methodName, parameterTypes, true);
            Method method = MethodUtils.getCachedMethod((MethodDescriptor)md);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod((Class)clazz, (Method)clazz.getMethod(methodName, parameterTypes));
            MethodUtils.cacheMethod((MethodDescriptor)md, (Method)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        return MethodUtils.getAccessibleMethod(method.getDeclaringClass(), (Method)method);
    }

    public static Method getAccessibleMethod(Class clazz, Method method) {
        Class[] parameterTypes;
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        boolean sameClass = true;
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else {
            sameClass = clazz.equals(method.getDeclaringClass());
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
            }
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            if (!sameClass && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                MethodUtils.setMethodAccessible((Method)method);
            }
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, (String)methodName, (Class[])(parameterTypes = method.getParameterTypes()))) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, (String)methodName, (Class[])parameterTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class clazz, String methodName, Class[] parameterTypes) {
        for (Class parentClazz = clazz.getSuperclass(); parentClazz != null; parentClazz = parentClazz.getSuperclass()) {
            if (!Modifier.isPublic(parentClazz.getModifiers())) continue;
            try {
                return parentClazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null) {
                    return method;
                }
                method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], (String)methodName, (Class[])parameterTypes);
                if (method == null) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$((String)"org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Matching name=" + methodName + " on " + clazz));
        }
        MethodDescriptor md = new MethodDescriptor(clazz, methodName, parameterTypes, false);
        try {
            Method method = MethodUtils.getCachedMethod((MethodDescriptor)md);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found straight match: " + method));
                log.trace((Object)("isPublic:" + Modifier.isPublic(method.getModifiers())));
            }
            MethodUtils.setMethodAccessible((Method)method);
            MethodUtils.cacheMethod((MethodDescriptor)md, (Method)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Method bestMatch = null;
            Method[] methods = clazz.getMethods();
            float bestMatchCost = Float.MAX_VALUE;
            float myCost = Float.MAX_VALUE;
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Class<?>[] methodsParams;
                int methodParamSize;
                if (!methods[i].getName().equals(methodName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Found matching name:");
                    log.trace((Object)methods[i]);
                }
                if ((methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Param=" + parameterTypes[n].getName()));
                        log.trace((Object)("Method=" + methodsParams[n].getName()));
                    }
                    if (MethodUtils.isAssignmentCompatible(methodsParams[n], (Class)parameterTypes[n])) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(methodsParams[n] + " is not assignable from " + parameterTypes[n]));
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                Method method = MethodUtils.getAccessibleMethod((Class)clazz, (Method)methods[i]);
                if (method != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(method + " accessible version of " + methods[i]));
                    }
                    MethodUtils.setMethodAccessible((Method)method);
                    myCost = MethodUtils.getTotalTransformationCost((Class[])parameterTypes, (Class[])method.getParameterTypes());
                    if (myCost < bestMatchCost) {
                        bestMatch = method;
                        bestMatchCost = myCost;
                    }
                }
                log.trace((Object)"Couldn't find accessible method.");
            }
            if (bestMatch != null) {
                MethodUtils.cacheMethod((MethodDescriptor)md, bestMatch);
            } else {
                log.trace((Object)"No match found.");
            }
            return bestMatch;
        }
    }

    private static void setMethodAccessible(Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (SecurityException se) {
            Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$((String)"org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
            if (!loggedAccessibleWarning) {
                boolean vulnerableJVM = false;
                try {
                    String specVersion = System.getProperty("java.specification.version");
                    if (specVersion.charAt(0) == '1' && (specVersion.charAt(2) == '0' || specVersion.charAt(2) == '1' || specVersion.charAt(2) == '2' || specVersion.charAt(2) == '3')) {
                        vulnerableJVM = true;
                    }
                }
                catch (SecurityException e) {
                    vulnerableJVM = true;
                }
                if (vulnerableJVM) {
                    log.warn((Object)"Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                }
                loggedAccessibleWarning = true;
            }
            log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)se);
        }
    }

    private static float getTotalTransformationCost(Class[] srcArgs, Class[] destArgs) {
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class srcClass = srcArgs[i];
            Class destClass = destArgs[i];
            totalCost += MethodUtils.getObjectTransformationCost((Class)srcClass, (Class)destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class srcClass, Class destClass) {
        float cost = 0.0f;
        while (destClass != null && !destClass.equals(srcClass)) {
            if (destClass.isInterface() && MethodUtils.isAssignmentCompatible((Class)destClass, (Class)srcClass)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            destClass = destClass.getSuperclass();
        }
        if (destClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    public static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        Class parameterWrapperClazz;
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive() && (parameterWrapperClazz = MethodUtils.getPrimitiveWrapper((Class)parameterType)) != null) {
            return parameterWrapperClazz.equals(parameterization);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$((String)"java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$((String)"java.lang.Float")) : class$java$lang$Float;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$((String)"java.lang.Long")) : class$java$lang$Long;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$((String)"java.lang.Integer")) : class$java$lang$Integer;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$((String)"java.lang.Short")) : class$java$lang$Short;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$((String)"java.lang.Byte")) : class$java$lang$Byte;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$((String)"java.lang.Double")) : class$java$lang$Double;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$((String)"java.lang.Character")) : class$java$lang$Character;
        }
        return null;
    }

    public static Class getPrimitiveType(Class wrapperType) {
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$((String)"java.lang.Boolean")) : class$java$lang$Boolean).equals(wrapperType)) {
            return Boolean.TYPE;
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$((String)"java.lang.Float")) : class$java$lang$Float).equals(wrapperType)) {
            return Float.TYPE;
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$((String)"java.lang.Long")) : class$java$lang$Long).equals(wrapperType)) {
            return Long.TYPE;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$((String)"java.lang.Integer")) : class$java$lang$Integer).equals(wrapperType)) {
            return Integer.TYPE;
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$((String)"java.lang.Short")) : class$java$lang$Short).equals(wrapperType)) {
            return Short.TYPE;
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$((String)"java.lang.Byte")) : class$java$lang$Byte).equals(wrapperType)) {
            return Byte.TYPE;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$((String)"java.lang.Double")) : class$java$lang$Double).equals(wrapperType)) {
            return Double.TYPE;
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$((String)"java.lang.Character")) : class$java$lang$Character).equals(wrapperType)) {
            return Character.TYPE;
        }
        Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$((String)"org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not a known primitive wrapper class: " + wrapperType));
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class primitiveClazz = MethodUtils.getPrimitiveWrapper((Class)clazz);
            if (primitiveClazz != null) {
                return primitiveClazz;
            }
            return clazz;
        }
        return clazz;
    }

    private static Method getCachedMethod(MethodDescriptor md) {
        Reference methodRef;
        if (CACHE_METHODS && (methodRef = (Reference)cache.get(md)) != null) {
            return (Method)methodRef.get();
        }
        return null;
    }

    private static void cacheMethod(MethodDescriptor md, Method method) {
        if (CACHE_METHODS && method != null) {
            cache.put(md, new WeakReference<Method>(method));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Class[] access$000() {
        return EMPTY_CLASS_PARAMETERS;
    }
}

