/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.search;

import com.terracottatech.offheapstore.storage.listener.StorageEngineListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;

public class SearchStorageEngineListener<K>
implements StorageEngineListener<K, Element> {
    private final Map<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
    private final LuceneIndexedSearchManager searchManager;
    private final String cacheName;
    private final int segmentId;

    public SearchStorageEngineListener(LuceneIndexedSearchManager searchManager, CacheConfiguration cacheConfig, int segmentId) {
        this.searchManager = searchManager;
        this.segmentId = segmentId;
        this.cacheName = cacheConfig.getName();
        for (Map.Entry<String, SearchAttribute> entry : cacheConfig.getSearchable().getSearchAttributes().entrySet()) {
            this.extractors.put(entry.getKey(), entry.getValue().constructExtractor());
        }
    }

    @Override
    public void written(K key, Element value, ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata, long encoding) {
        if (this.searchManager.shouldIndex()) {
            this.insertSearchRecord(encoding, hash, binaryKey, value);
        }
    }

    private void insertSearchRecord(long encoding, int hash, ByteBuffer binaryKey, Element element) {
        byte[] serializedKey = SearchStorageEngineListener.getBytes(binaryKey);
        String uniqueKey = SearchStorageEngineListener.makeSearchKey(encoding, hash);
        this.searchManager.put(this.cacheName, this.segmentId, uniqueKey, serializedKey, element, this.extractors);
    }

    @Override
    public void freed(long encoding, int hash, boolean removed) {
        String key = SearchStorageEngineListener.makeSearchKey(encoding, hash);
        if (this.searchManager.shouldIndex()) {
            this.searchManager.remove(this.cacheName, key, this.segmentId);
        }
    }

    @Override
    public void cleared() {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.clear(this.cacheName, this.segmentId);
        }
    }

    @Override
    public void copied(int hash, long oldEncoding, long newEncoding, int metadata) {
        if (newEncoding != oldEncoding) {
            String existingKey = SearchStorageEngineListener.makeSearchKey(oldEncoding, hash);
            String newKey = SearchStorageEngineListener.makeSearchKey(newEncoding, hash);
            this.searchManager.move(this.cacheName, this.segmentId, existingKey, newKey);
        }
    }

    private static String makeSearchKey(Long encoding, int hash) {
        return encoding + ":" + hash;
    }

    private static byte[] getBytes(ByteBuffer buf) {
        byte[] rv = new byte[buf.remaining()];
        buf.get(rv);
        return rv;
    }
}

