/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.util.Factory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DiskWriteThreadPool
implements Factory<ThreadPoolExecutor> {
    private final List<ThreadPoolExecutor> writers = new CopyOnWriteArrayList<ThreadPoolExecutor>();
    private final String name;
    private final int threads;
    private int index = 0;

    public DiskWriteThreadPool(String name, int threads) {
        this.name = name;
        this.threads = threads;
    }

    @Override
    public ThreadPoolExecutor newInstance() {
        ThreadPoolExecutor writer;
        if (this.writers.size() < this.threads) {
            final int index = this.writers.size();
            writer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "Ehcache Disk Write Thread [" + DiskWriteThreadPool.this.name + "] - " + index);
                }
            });
            this.writers.add(writer);
        } else {
            writer = this.writers.get(this.index++);
            if (this.index == this.writers.size()) {
                this.index = 0;
            }
        }
        return writer;
    }

    public long getTotalQueueSize() {
        long size = 0L;
        for (ThreadPoolExecutor e : this.writers) {
            size += (long)e.getQueue().size();
        }
        return size;
    }
}

