/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.heap;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.AbstractObjectManagerStripe;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.chm.SelectableConcurrentHashMap;

public class RestartableSelectableConcurrentHashMap
extends SelectableConcurrentHashMap {
    private final ByteBuffer identifier;
    private final Portability<Serializable> keyPortability;
    private final Portability<Element> elementPortability;
    private final RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability;
    private final boolean synchronous;

    public RestartableSelectableConcurrentHashMap(ByteBuffer identifier, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability, boolean synchronous, Portability<Serializable> keyPortability, Portability<Element> elementPortability, PoolAccessor<?> poolAccessor, boolean elementPinningEnabled, int initialCapacity, float loadFactor, int concurrency, long maximumSize, RegisteredEventListeners cacheEventNotificationService) {
        super(poolAccessor, elementPinningEnabled, initialCapacity, loadFactor, concurrency, maximumSize, cacheEventNotificationService);
        this.identifier = identifier;
        this.keyPortability = keyPortability;
        this.elementPortability = elementPortability;
        this.restartability = restartability;
        this.synchronous = synchronous;
    }

    @Override
    protected SelectableConcurrentHashMap.Segment createSegment(int initialCapacity, float lf) {
        return new RestartableSegment(initialCapacity, lf);
    }

    public ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return new HeapEhcacheObjectManagerStripe(this.segments());
    }

    public class HeapEhcacheObjectManagerStripe
    extends AbstractObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final Collection<ObjectManagerSegment<ByteBuffer, ByteBuffer, ByteBuffer>> segmentCollection;

        public HeapEhcacheObjectManagerStripe(List<SelectableConcurrentHashMap.Segment> segments) {
            ArrayList<RestartableSegment> restartableSegments = new ArrayList<RestartableSegment>();
            for (SelectableConcurrentHashMap.Segment s : segments) {
                restartableSegments.add((RestartableSegment)s);
            }
            this.segmentCollection = Collections.unmodifiableCollection(restartableSegments);
        }

        @Override
        public Collection<ObjectManagerSegment<ByteBuffer, ByteBuffer, ByteBuffer>> getSegments() {
            return this.segmentCollection;
        }

        @Override
        protected ObjectManagerSegment<ByteBuffer, ByteBuffer, ByteBuffer> getSegmentFor(int hash, ByteBuffer key) {
            return (RestartableSegment)RestartableSelectableConcurrentHashMap.this.segmentFor(hash);
        }

        @Override
        protected int extractHashCode(ByteBuffer frsBinaryKey) {
            return RestartableSelectableConcurrentHashMap.hash(RestartableStorageEngine.extractHashcode(frsBinaryKey));
        }

        @Override
        public void delete() {
        }
    }

    static class LinkedHashEntry
    extends SelectableConcurrentHashMap.HashEntry {
        LinkedHashEntry nextEntry;
        LinkedHashEntry prevEntry;
        long lsn = -1L;

        LinkedHashEntry(Object key, int hash, SelectableConcurrentHashMap.HashEntry next, Element value, long sizeOf, boolean pinned) {
            super(key, hash, next, value, sizeOf, pinned);
        }
    }

    class RestartableSegment
    extends SelectableConcurrentHashMap.Segment
    implements ObjectManagerSegment<ByteBuffer, ByteBuffer, ByteBuffer> {
        private long byteSize;
        private LinkedHashEntry first;
        private LinkedHashEntry last;
        private ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> compactingEntry;

        RestartableSegment(int initialCapacity, float lf) {
            super(initialCapacity, lf);
        }

        @Override
        protected SelectableConcurrentHashMap.HashEntry createHashEntry(Object key, int hash, SelectableConcurrentHashMap.HashEntry next, Element value, long sizeOf, boolean pinned) {
            return new LinkedHashEntry(key, hash, next, value, sizeOf, pinned);
        }

        @Override
        protected SelectableConcurrentHashMap.HashEntry relinkHashEntry(SelectableConcurrentHashMap.HashEntry e, SelectableConcurrentHashMap.HashEntry next) {
            LinkedHashEntry original = (LinkedHashEntry)e;
            LinkedHashEntry relinked = new LinkedHashEntry(e.key, e.hash, next, e.value, e.sizeOf, e.pinned);
            if (this.first == original) {
                this.first = relinked;
            }
            if (this.last == original) {
                this.last = relinked;
            }
            if (original.nextEntry != null) {
                relinked.nextEntry = original.nextEntry;
                relinked.nextEntry.prevEntry = relinked;
            }
            if (original.prevEntry != null) {
                relinked.prevEntry = original.prevEntry;
                relinked.prevEntry.nextEntry = relinked;
            }
            relinked.lsn = ((LinkedHashEntry)e).lsn;
            return relinked;
        }

        @Override
        public ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> acquireCompactionEntry(long ceilingLsn) {
            this.writeLock().lock();
            LinkedHashEntry entry = this.first;
            if (entry == null) {
                this.writeLock().unlock();
                return null;
            }
            try {
                if (entry.lsn >= ceilingLsn) {
                    this.writeLock().unlock();
                    return null;
                }
                int metadata = entry.pinned ? 0x40000000 : 0;
                ByteBuffer offheapBinaryKey = RestartableSelectableConcurrentHashMap.this.keyPortability.encode((Serializable)entry.key);
                ByteBuffer offheapBinaryValue = RestartableSelectableConcurrentHashMap.this.elementPortability.encode(entry.value);
                this.compactingEntry = new SimpleObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer>(RestartableSelectableConcurrentHashMap.this.identifier, RestartableStorageEngine.encodeKey(offheapBinaryKey, entry.key.hashCode()), RestartableStorageEngine.encodeValue(offheapBinaryValue, 0L, metadata), entry.lsn);
                return this.compactingEntry;
            }
            catch (Exception e) {
                this.writeLock().unlock();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void releaseCompactionEntry(ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry) {
            if (entry == null) {
                throw new NullPointerException("Tried to release a null entry.");
            }
            if (entry != this.compactingEntry) {
                throw new IllegalArgumentException("Released entry is not the same as acquired entry.");
            }
            this.compactingEntry = null;
            this.writeLock().unlock();
        }

        @Override
        public void updateLsn(int hash, ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry, long newLsn) {
            if (entry != this.compactingEntry) {
                throw new IllegalArgumentException("Tried to update the LSN on an entry that was not acquired.");
            }
            ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(entry.getKey());
            this.writeLock().lock();
            try {
                if (this.count != 0) {
                    SelectableConcurrentHashMap.HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && RestartableSelectableConcurrentHashMap.this.keyPortability.equals(e.key, offheapBinaryKey.duplicate())) {
                            LinkedHashEntry lhe = (LinkedHashEntry)e;
                            assert (lhe.lsn == entry.getLsn());
                            lhe.lsn = newLsn;
                            this.unlinkEntry(lhe);
                            this.linkNodeExpectingLast(lhe);
                            return;
                        }
                        e = e.next;
                    }
                }
                throw new AssertionError();
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLowestLsn() {
            this.readLock().lock();
            try {
                if (this.first == null) {
                    Long l = null;
                    return l;
                }
                Long l = this.first.lsn;
                return l;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLsn(int hash, ByteBuffer frsBinaryKey) {
            ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    SelectableConcurrentHashMap.HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && RestartableSelectableConcurrentHashMap.this.keyPortability.equals(e.key, offheapBinaryKey.duplicate())) {
                            Long l = ((LinkedHashEntry)e).lsn;
                            return l;
                        }
                        e = e.next;
                    }
                }
                Long l = null;
                return l;
            }
            finally {
                this.readLock().unlock();
            }
        }

        @Override
        public void put(int hash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
            ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
            this.writeLock().lock();
            try {
                if (this.count != 0) {
                    SelectableConcurrentHashMap.HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && RestartableSelectableConcurrentHashMap.this.keyPortability.equals(e.key, offheapBinaryKey.duplicate())) {
                            ((LinkedHashEntry)e).lsn = lsn;
                            this.unlinkEntry((LinkedHashEntry)e);
                            this.linkNodeExpectingLast((LinkedHashEntry)e);
                            return;
                        }
                        e = e.next;
                    }
                }
                throw new AssertionError();
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replayPut(int hash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
            ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
            ByteBuffer offheapBinaryValue = RestartableStorageEngine.decodeValue(frsBinaryValue);
            boolean pinned = (0x40000000 & RestartableStorageEngine.extractMetadata(frsBinaryValue)) != 0;
            Object key = RestartableSelectableConcurrentHashMap.this.keyPortability.decode(offheapBinaryKey);
            Element element = (Element)RestartableSelectableConcurrentHashMap.this.elementPortability.decode(offheapBinaryValue);
            if (element.getObjectValue() instanceof SelectableConcurrentHashMap.DummyPinnedValue) {
                element = DUMMY_PINNED_ELEMENT;
                ++this.numDummyPinnedKeys;
            }
            if (pinned) {
                ++this.pinnedCount;
            }
            this.byteSize += (long)(offheapBinaryKey.capacity() + offheapBinaryValue.capacity());
            this.writeLock().lock();
            try {
                this.put(key, hash, element, 0L, false, pinned, false);
                this.put(hash, frsBinaryKey, frsBinaryValue, lsn);
            }
            finally {
                this.writeLock().unlock();
            }
            this.recalculateSize(key, hash);
        }

        @Override
        public void remove(int hash, ByteBuffer key) {
        }

        @Override
        public long size() {
            return this.count;
        }

        @Override
        public long sizeInBytes() {
            return this.byteSize;
        }

        @Override
        protected void clear() {
            this.byteSize = 0L;
            try {
                RestartableSelectableConcurrentHashMap.this.restartability.beginTransaction(RestartableSelectableConcurrentHashMap.this.synchronous).delete(RestartableSelectableConcurrentHashMap.this.identifier).commit();
            }
            catch (TransactionException e) {
                throw new RuntimeException(e);
            }
            super.clear();
        }

        @Override
        protected void preRemove(SelectableConcurrentHashMap.HashEntry entry) {
            ByteBuffer offheapBinaryKey = RestartableSelectableConcurrentHashMap.this.keyPortability.encode((Serializable)entry.key);
            ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(offheapBinaryKey, entry.key.hashCode());
            this.unlinkEntry((LinkedHashEntry)entry);
            this.byteSize -= (long)(offheapBinaryKey.capacity() + RestartableSelectableConcurrentHashMap.this.elementPortability.encode(entry.value).capacity());
            try {
                RestartableSelectableConcurrentHashMap.this.restartability.beginTransaction(RestartableSelectableConcurrentHashMap.this.synchronous).remove(RestartableSelectableConcurrentHashMap.this.identifier, frsBinaryKey).commit();
            }
            catch (TransactionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void postInstall(Object key, Element element, boolean pinned) {
            ByteBuffer offheapBinaryKey = RestartableSelectableConcurrentHashMap.this.keyPortability.encode((Serializable)key);
            ByteBuffer offheapBinaryValue = RestartableSelectableConcurrentHashMap.this.elementPortability.encode(element);
            ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(offheapBinaryKey, key.hashCode());
            ByteBuffer frsBinaryValue = RestartableStorageEngine.encodeValue(offheapBinaryValue, 0L, pinned ? 0x40000000 : 0);
            this.byteSize += (long)(offheapBinaryKey.capacity() + offheapBinaryValue.capacity());
            try {
                RestartableSelectableConcurrentHashMap.this.restartability.beginTransaction(RestartableSelectableConcurrentHashMap.this.synchronous).put(RestartableSelectableConcurrentHashMap.this.identifier, frsBinaryKey, frsBinaryValue).commit();
            }
            catch (TransactionException e) {
                throw new RuntimeException(e);
            }
        }

        protected final void unlinkEntry(LinkedHashEntry entry) {
            if (this.last == entry) {
                this.last = entry.prevEntry;
            }
            if (this.first == entry) {
                this.first = entry.nextEntry;
            }
            if (entry.nextEntry != null) {
                entry.nextEntry.prevEntry = entry.prevEntry;
            }
            if (entry.prevEntry != null) {
                entry.prevEntry.nextEntry = entry.nextEntry;
            }
            entry.prevEntry = null;
            entry.nextEntry = null;
        }

        protected final void linkNodeExpectingLast(LinkedHashEntry entry) {
            LinkedHashEntry next;
            if (entry.lsn < 0L) {
                this.unlinkEntry(entry);
                return;
            }
            if (this.last == null) {
                assert (this.first == null);
                this.last = entry;
                this.first = entry;
                return;
            }
            LinkedHashEntry previous = this.last;
            while (true) {
                if (previous.lsn < entry.lsn) {
                    next = previous.nextEntry;
                    break;
                }
                if (previous.prevEntry == null) {
                    next = previous;
                    previous = null;
                    break;
                }
                previous = previous.prevEntry;
            }
            if (next == null) {
                assert (previous == this.last);
                this.last = entry;
                entry.prevEntry = previous;
                previous.nextEntry = entry;
            } else if (previous == null) {
                assert (next == this.first);
                this.first = entry;
                entry.nextEntry = next;
                next.prevEntry = entry;
            } else {
                entry.nextEntry = next;
                entry.prevEntry = previous;
                previous.nextEntry = entry;
                next.prevEntry = entry;
            }
        }

        protected final void linkNodeExpectingFirst(LinkedHashEntry entry, long lsn) {
            LinkedHashEntry previous;
            if (lsn < 0L) {
                this.unlinkEntry(entry);
                return;
            }
            if (this.last == null) {
                assert (this.first == null);
                this.last = entry;
                this.first = entry;
                return;
            }
            LinkedHashEntry next = this.first;
            while (true) {
                if (next.lsn > lsn) {
                    previous = next.prevEntry;
                    break;
                }
                if (next.nextEntry == null) {
                    previous = next;
                    next = null;
                    break;
                }
                next = next.nextEntry;
            }
            if (previous == null) {
                assert (next == this.first);
                this.first = entry;
                entry.nextEntry = next;
                next.prevEntry = entry;
            } else if (next == null) {
                assert (previous == this.last);
                this.last = entry;
                entry.prevEntry = previous;
                previous.nextEntry = entry;
            } else {
                entry.prevEntry = previous;
                entry.nextEntry = next;
                next.prevEntry = entry;
                previous.nextEntry = entry;
            }
        }
    }
}

