/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableOffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.BinaryStorageEngine;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.portability.BooleanPortability;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.LinkedNode;
import com.terracottatech.offheapstore.storage.restartable.LinkedNodePortability;
import com.terracottatech.offheapstore.storage.restartable.RestartablePinnableDelegateStorageEngine;
import com.terracottatech.offheapstore.util.Factory;

public class RestartablePinnableDelegateOffHeapBufferStorageEngine<K, V>
extends PinnableOffHeapBufferStorageEngine<K, V>
implements RestartablePinnableDelegateStorageEngine<OffHeapBufferStorageEngine<K, LinkedNode<Boolean>>, K> {
    private final OffHeapBufferStorageEngine<K, LinkedNode<Boolean>> pinnedKeyEngineDelegate;

    public static <K, V> Factory<RestartablePinnableDelegateOffHeapBufferStorageEngine<K, V>> createRestartableFactory(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        return RestartablePinnableDelegateOffHeapBufferStorageEngine.createRestartableFactory(source, pageSize, keyPortability, valuePortability, false, false);
    }

    public static <K, V> Factory<RestartablePinnableDelegateOffHeapBufferStorageEngine<K, V>> createRestartableFactory(final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<RestartablePinnableDelegateOffHeapBufferStorageEngine<K, V>>(){

            @Override
            public RestartablePinnableDelegateOffHeapBufferStorageEngine<K, V> newInstance() {
                return new RestartablePinnableDelegateOffHeapBufferStorageEngine(source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public RestartablePinnableDelegateOffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, pageSize, keyPortability, valuePortability, false, false);
    }

    public RestartablePinnableDelegateOffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(source, pageSize, keyPortability, valuePortability, thief, victim);
        this.pinnedKeyEngineDelegate = new OffHeapBufferStorageEngine<K, Boolean>(source, pageSize, keyPortability, new LinkedNodePortability<Boolean>(BooleanPortability.INSTANCE), true, false);
    }

    @Override
    public OffHeapBufferStorageEngine<K, LinkedNode<Boolean>> getRestartablePinnedKeyEngine() {
        return this.pinnedKeyEngineDelegate;
    }

    @Override
    public int deriveMetadata(long encoding) {
        BinaryStorageEngine engine = this.getStorageEngineForEncoding(encoding);
        if (engine == this.normalEngine) {
            return 0;
        }
        if (engine == this.pinnedEngine) {
            return 0x40000000;
        }
        throw new AssertionError();
    }
}

