/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.frs.object.AbstractObjectManagerStripe;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OffHeapObjectManagerStripe<I>
extends AbstractObjectManagerStripe<I, ByteBuffer, ByteBuffer>
implements RestartableObject<I, ByteBuffer, ByteBuffer> {
    private final I identifier;
    private final AbstractConcurrentOffHeapMap<?, ?> concurrentMap;
    private final List<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> segments;

    public OffHeapObjectManagerStripe(I identifier, OffHeapHashMap<?, ?> map) {
        this(identifier, Collections.singletonList((RestartableStorageEngine)map.getStorageEngine()), null);
    }

    public OffHeapObjectManagerStripe(I identifier, AbstractConcurrentOffHeapMap<?, ?> map) {
        this(identifier, OffHeapObjectManagerStripe.getRestartableSegments(map), map);
    }

    protected OffHeapObjectManagerStripe(I identifier, List<RestartableStorageEngine<?, I, ?, ?>> segments, AbstractConcurrentOffHeapMap<?, ?> map) {
        this.identifier = identifier;
        this.segments = Collections.unmodifiableList(segments);
        this.concurrentMap = map;
    }

    @Override
    public Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> getSegments() {
        return this.segments;
    }

    @Override
    public void replayPut(ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        try {
            super.replayPut(frsBinaryKey, frsBinaryValue, lsn);
        }
        catch (OversizeMappingException e) {
            if (this.concurrentMap instanceof AbstractConcurrentOffHeapCache) {
                AbstractConcurrentOffHeapCache concurrentCache = (AbstractConcurrentOffHeapCache)this.concurrentMap;
                int hashcode = this.extractHashCode(frsBinaryKey);
                if (concurrentCache.handleOversizeMappingException(hashcode)) {
                    try {
                        super.replayPut(frsBinaryKey, frsBinaryValue, lsn);
                        return;
                    }
                    catch (OversizeMappingException ex) {
                        e = ex;
                    }
                }
                concurrentCache.writeLockAll();
                while (true) {
                    try {
                        super.replayPut(frsBinaryKey, frsBinaryValue, lsn);
                        return;
                    }
                    catch (OversizeMappingException ex) {
                        e = ex;
                        if (concurrentCache.handleOversizeMappingException(hashcode)) continue;
                        throw e;
                    }
                    break;
                }
                finally {
                    concurrentCache.writeUnlockAll();
                }
            }
            throw e;
        }
    }

    @Override
    protected ObjectManagerSegment<I, ByteBuffer, ByteBuffer> getSegmentFor(int hash, ByteBuffer key) {
        if (this.segments.size() == 1) {
            return this.segments.get(0);
        }
        return this.segments.get(this.concurrentMap.getIndexFor(hash));
    }

    @Override
    protected int extractHashCode(ByteBuffer frsBinaryKey) {
        return RestartableStorageEngine.extractHashcode(frsBinaryKey);
    }

    private static <I> List<RestartableStorageEngine<?, I, ?, ?>> getRestartableSegments(AbstractConcurrentOffHeapMap<?, ?> map) {
        ArrayList result = new ArrayList();
        for (Segment<?, ?> segment : map.getSegments()) {
            result.add((RestartableStorageEngine)((OffHeapHashMap)((Object)segment)).getStorageEngine());
        }
        return result;
    }

    @Override
    public void delete() {
    }

    @Override
    public I getId() {
        return this.identifier;
    }

    @Override
    public ObjectManagerStripe<I, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return this;
    }
}

