/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning;

import com.terracottatech.offheapstore.AbstractOffHeapClockCache;
import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableCache;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.set.OffHeapHashSet;
import com.terracottatech.offheapstore.storage.StorageEngine;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractPinnableOffHeapClockCache<K, V>
extends AbstractOffHeapClockCache<K, V>
implements PinnableCache<K, V>,
PinnableSegment<K, V> {
    private final OffHeapHashSet<K> pinnedKeys;
    private volatile int missingPinnedKeys;
    private volatile PinnedKeySet pinnedKeySet;

    public AbstractPinnableOffHeapClockCache(PageSource source, boolean tableAllocationsSteal, PinnableStorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, tableAllocationsSteal, storageEngine, tableSize);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    public AbstractPinnableOffHeapClockCache(PageSource source, boolean tableAllocationsSteal, PinnableStorageEngine<? super K, ? super V> storageEngine) {
        super(source, tableAllocationsSteal, storageEngine);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    public AbstractPinnableOffHeapClockCache(PageSource source, PinnableStorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super(source, storageEngine, bootstrap);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    public AbstractPinnableOffHeapClockCache(PageSource source, PinnableStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super(source, storageEngine, tableSize, bootstrap);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    public AbstractPinnableOffHeapClockCache(PageSource source, PinnableStorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, storageEngine, tableSize);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    public AbstractPinnableOffHeapClockCache(PageSource source, PinnableStorageEngine<? super K, ? super V> storageEngine) {
        super(source, storageEngine);
        this.pinnedKeys = new OffHeapHashSet(new ExternallyLockedMap<K>(this, source, true, storageEngine.getPinnedKeyEngine(), 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPinned(Object key) {
        Lock l = this.readLock();
        l.lock();
        try {
            boolean bl = this.pinnedKeys.contains(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPinning(K key, boolean pinned) {
        block8: {
            Lock l = this.writeLock();
            l.lock();
            try {
                if (pinned) {
                    boolean added;
                    try {
                        added = this.pinnedKeys.add(key);
                    }
                    catch (OutOfMemoryError e) {
                        throw new OversizeMappingException(e);
                    }
                    if (added && !this.updateMetadata(key, 0x40000000)) {
                        ++this.missingPinnedKeys;
                    }
                    break block8;
                }
                if (this.pinnedKeys.remove(key) && !this.updateMetadata(key, 0)) {
                    --this.missingPinnedKeys;
                }
            }
            finally {
                l.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpinAll() {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (this.pinnedKeys.size() < this.size()) {
                for (K key : this.pinnedKeys) {
                    this.updateMetadata(key, 0);
                }
            } else {
                for (Object key : this.keySet()) {
                    if (!this.pinnedKeys.contains(key)) continue;
                    this.updateMetadata(key, 0);
                }
            }
            this.pinnedKeys.clear();
            this.missingPinnedKeys = 0;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock writeLock = this.writeLock();
        writeLock.lock();
        try {
            super.clear();
            this.missingPinnedKeys = this.pinnedKeys.size();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fill(K key, V value) {
        Lock writeLock = this.writeLock();
        writeLock.lock();
        try {
            V fill = super.fill(key, value);
            if (fill == null && this.pinnedKeys.contains(key)) {
                --this.missingPinnedKeys;
            }
            V v = fill;
            return v;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Lock writeLock = this.writeLock();
        writeLock.lock();
        try {
            if (this.pinnedKeys.contains(key)) {
                V old = super.put(key, value, 0x40000000);
                if (old == null) {
                    --this.missingPinnedKeys;
                }
                V v = old;
                return v;
            }
            V v = this.put(key, value, 0);
            return v;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Lock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Object remove = super.remove(key);
            if (remove != null && this.pinnedKeys.contains(key)) {
                ++this.missingPinnedKeys;
            }
            Object v = remove;
            return v;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNoReturn(Object key) {
        boolean removed;
        Lock writeLock = this.writeLock();
        writeLock.lock();
        try {
            removed = super.removeNoReturn(key);
            if (removed && this.pinnedKeys.contains(key)) {
                ++this.missingPinnedKeys;
            }
        }
        finally {
            writeLock.unlock();
        }
        return removed;
    }

    @Override
    protected final boolean evictable(int status) {
        return super.evictable(status) && (status & 0x40000000) == 0;
    }

    public Set<K> pinnedKeySet() {
        PinnedKeySet pks = this.pinnedKeySet;
        return pks != null ? pks : (this.pinnedKeySet = new PinnedKeySet());
    }

    public StorageEngine<? super K, ?> getPinnedKeyStorageEngine() {
        return this.pinnedKeys.getStorageEngine();
    }

    static class ExternallyLockedMap<E>
    extends OffHeapHashMap<E, Boolean>
    implements ReadWriteLock {
        private final ReadWriteLock lock;

        ExternallyLockedMap(ReadWriteLock lock, PageSource source, boolean tableSteals, StorageEngine<? super E, Boolean> engine, int capacity) {
            super(source, tableSteals, engine, capacity);
            this.lock = lock;
        }

        @Override
        public Lock readLock() {
            return this.lock.readLock();
        }

        @Override
        public Lock writeLock() {
            return this.lock.writeLock();
        }
    }

    private class PinnedKeySet
    extends AbstractSet<K> {
        private PinnedKeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new PinnedKeySetIterator(AbstractPinnableOffHeapClockCache.this.pinnedKeys.iterator());
        }

        @Override
        public int size() {
            return AbstractPinnableOffHeapClockCache.this.pinnedKeys.size() - AbstractPinnableOffHeapClockCache.this.missingPinnedKeys;
        }

        private class PinnedKeySetIterator
        implements Iterator<K> {
            private final Iterator<K> iterator;
            private K next;

            private PinnedKeySetIterator(Iterator<K> iterator) {
                this.iterator = iterator;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            private void advance() {
                this.next = null;
                while (this.iterator.hasNext()) {
                    Object key = this.iterator.next();
                    if (!AbstractPinnableOffHeapClockCache.this.containsKey(key)) continue;
                    this.next = key;
                    break;
                }
            }

            @Override
            public K next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.advance();
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

